/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.items;

import java.util.List;
import lyon.aom.Main;
import lyon.aom.capabilities.iceburst_container.IIceburstCanister;
import lyon.aom.capabilities.iceburst_container.IceburstCanisterProvider;
import lyon.aom.capabilities.iceburst_container.IceburstCanisterStorage;
import lyon.aom.init.ItemInit;
import lyon.aom.items.base_items.ItemBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemStackHandler;

public class ItemIceBurstCanister
extends ItemBase {
    public ItemIceBurstCanister(String name) {
        super(name);
        this.func_185043_a(new ResourceLocation("state"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (ItemIceBurstCanister.getShardCount(stack) > 0) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public int getItemStackLimit(ItemStack stack) {
        if (ItemIceBurstCanister.getShardCount(stack) > 0) {
            return 1;
        }
        return 64;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K && playerIn.func_70093_af() && playerIn.func_184586_b(handIn).func_190916_E() == 1) {
            playerIn.openGui((Object)Main.instance, 5, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public static ItemStackHandler getHandler(ItemStack stack) {
        if (stack.hasCapability(IceburstCanisterProvider.ICEBURST_CANISTER_CAP, null)) {
            IIceburstCanister canister = (IIceburstCanister)stack.getCapability(IceburstCanisterProvider.ICEBURST_CANISTER_CAP, null);
            return canister.getStackHandler();
        }
        return null;
    }

    public static int getShardCount(ItemStack stack) {
        ItemStackHandler handler = ItemIceBurstCanister.getHandler(stack);
        if (handler != null) {
            int count = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).func_77973_b() != ItemInit.ICEBURST_SHARD) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    public static ItemStack getShardInSlot(int slot, ItemStack stack) {
        ItemStackHandler handler = ItemIceBurstCanister.getHandler(stack);
        if (handler != null) {
            return handler.getStackInSlot(slot);
        }
        return ItemStack.field_190927_a;
    }

    public static void setShardInSlot(int slot, ItemStack stack) {
        ItemStackHandler handler = ItemIceBurstCanister.getHandler(stack);
        if (handler != null) {
            handler.setStackInSlot(slot, stack);
        }
    }

    public static void removeFirstShard(ItemStack stack) {
        ItemStackHandler handler = ItemIceBurstCanister.getHandler(stack);
        if (handler != null) {
            for (int i = handler.getSlots() - 1; i >= 0; --i) {
                if (handler.getStackInSlot(i).func_77973_b() != ItemInit.ICEBURST_SHARD) continue;
                handler.setStackInSlot(i, ItemStack.field_190927_a);
                return;
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b() || slotChanged;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        IceburstCanisterProvider provider = new IceburstCanisterProvider();
        provider.deserializeNBT((NBTBase)nbt);
        return provider;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (stack.func_77942_o()) {
            nbt = stack.func_77978_p();
        }
        nbt.func_74782_a("CAP", new IceburstCanisterStorage().writeNBT(IceburstCanisterProvider.ICEBURST_CANISTER_CAP, (IIceburstCanister)stack.getCapability(IceburstCanisterProvider.ICEBURST_CANISTER_CAP, null), null));
        return nbt;
    }

    public void readNBTShareTag(ItemStack stack, NBTTagCompound nbt) {
        super.readNBTShareTag(stack, nbt);
        if (nbt != null) {
            new IceburstCanisterStorage().readNBT(IceburstCanisterProvider.ICEBURST_CANISTER_CAP, (IIceburstCanister)stack.getCapability(IceburstCanisterProvider.ICEBURST_CANISTER_CAP, null), null, nbt.func_74781_a("CAP"));
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Style style = new Style().func_150238_a(TextFormatting.YELLOW);
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r.func_146272_n()) {
            tooltip.add(new TextComponentString(Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentString(" + ").func_150255_a(style).func_150254_d() + new TextComponentString(Minecraft.func_71410_x().field_71474_y.field_74313_G.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentTranslation("tooltip.iceburst_canister_text_1.name", new Object[]{0}).func_150255_a(style).func_150254_d());
        } else {
            tooltip.add(new TextComponentTranslation("tooltip.extend_controls.name", new Object[]{0}).func_150255_a(style).func_150254_d());
        }
        style = new Style().func_150238_a(TextFormatting.RED);
        Minecraft minecraft2 = Minecraft.func_71410_x();
        if (minecraft2.field_71462_r.func_146271_m()) {
            int shardCount = ItemIceBurstCanister.getShardCount(stack);
            tooltip.add(new TextComponentTranslation("tooltip.iceburst_canister_text_2.name", new Object[0]).func_150255_a(style).func_150254_d() + new TextComponentString(": ").func_150255_a(style).func_150254_d() + new TextComponentString(shardCount + "/10").func_150255_a(style).func_150254_d());
        } else {
            tooltip.add(new TextComponentTranslation("tooltip.extend_info.name", new Object[]{0}).func_150255_a(style).func_150254_d());
        }
    }
}

