/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import lyon.aom.Main;
import lyon.aom.items.base_items.ItemSword;
import lyon.aom.utils.handlers.KeyBindingHandler;
import lyon.aom.utils.interfaces.IDualWieldable;
import lyon.aom.utils.interfaces.IShouldSwordSweep;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ToolHandle
extends ItemSword
implements IShouldSwordSweep,
IDualWieldable {
    private final float attackDamage;
    private final Item.ToolMaterial material;

    public ToolHandle(String name, Item.ToolMaterial material) {
        super(name, material);
        this.material = material;
        this.attackDamage = 3.0f + this.material.func_78000_c();
        this.func_185043_a(new ResourceLocation("state"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                float state = 4.0f - (float)Math.max((stack.func_77952_i() - 1) / 395, 0);
                if (stack.func_77952_i() == 0) {
                    state = 5.0f;
                }
                return state;
            }
        });
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab.equals(Main.AOMTAB)) {
            items.add((Object)new ItemStack((Item)this, 1, this.getMaxDamage(new ItemStack((Item)this))));
        }
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_180312_n || enchantment == Enchantments.field_185303_l) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public float func_150931_i() {
        return this.material.func_78000_c();
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (stack.func_77952_i() < stack.func_77958_k() && stack.func_77952_i() != 0) {
            stack.func_77972_a(1, attacker);
        }
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77952_i() > 1 && stack.func_77952_i() != stack.func_77958_k();
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            return "item.handle_thunderspear";
        }
        if (stack.func_77952_i() < stack.func_77958_k()) {
            return "item.sword";
        }
        return super.func_77667_c(stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            double damage = this.attackDamage;
            damage = stack.func_77952_i() == stack.func_77958_k() || stack.func_77952_i() == 0 ? 0.0 : (damage -= (double)(stack.func_77952_i() / 395));
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", damage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    @Override
    public boolean shouldSwordSweep(ItemStack stack) {
        return stack.func_77952_i() != stack.func_77958_k() && stack.func_77952_i() != 0;
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.func_77952_i() > 1 && stack.func_77952_i() != stack.func_77958_k();
    }

    @Override
    public float getAttackDamage(EnumHand hand, ItemStack stack) {
        Multimap<String, AttributeModifier> map = this.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack);
        return (float)((AttributeModifier)map.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).iterator().next()).func_111164_d();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Style style = new Style().func_150238_a(TextFormatting.YELLOW);
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r.func_146272_n()) {
            tooltip.add(new TextComponentString(KeyBindingHandler.keyBindEquipHandle.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentTranslation("tooltip.handle_text_1.name", new Object[0]).func_150255_a(style).func_150254_d());
            tooltip.add(new TextComponentString(KeyBindingHandler.keyBindReloadBlades.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentString(" + ").func_150255_a(style).func_150254_d() + new TextComponentString(Minecraft.func_71410_x().field_71474_y.field_74312_F.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentString("/").func_150255_a(style).func_150254_d() + new TextComponentString(Minecraft.func_71410_x().field_71474_y.field_74313_G.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentTranslation("tooltip.handle_text_2.name", new Object[]{0}).func_150255_a(style).func_150254_d());
        } else {
            tooltip.add(new TextComponentTranslation("tooltip.extend_controls.name", new Object[]{0}).func_150255_a(style).func_150254_d());
        }
    }
}

