/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.packets.both.open_gui_req;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketOpenGuiReq
implements IMessage {
    private UUID uuid;
    private GuiTypes type;

    public PacketOpenGuiReq() {
    }

    public PacketOpenGuiReq(EntityPlayer sender, GuiTypes type) {
        this.uuid = sender.func_110124_au();
        this.type = type;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public GuiTypes getGuiType() {
        return this.type;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.uuid = nbt.func_186857_a("UUID");
        this.type = GuiTypes.getTypeByID(nbt.func_74762_e("GuiType"));
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_186854_a("UUID", this.uuid);
        nbt.func_74768_a("GuiType", this.type.getID());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public static enum GuiTypes {
        TABBED_SURVIVAL_INVENTORY(0);

        private int id;

        private GuiTypes(int id) {
            this.id = id;
        }

        public int getID() {
            return this.id;
        }

        public static GuiTypes getTypeByID(int id) {
            for (GuiTypes s : GuiTypes.values()) {
                if (s.getID() != id) continue;
                return s;
            }
            return null;
        }
    }
}

