/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.packets.both.play_sound_req;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketPlaySoundReq
implements IMessage {
    private SoundEvent event;
    private Vec3d pos;
    private SoundCategory category;
    private float volume;
    private float pitch;
    private boolean isDelayed;

    public PacketPlaySoundReq() {
    }

    public PacketPlaySoundReq(SoundEvent event, double posX, double posY, double posZ, SoundCategory category, float volume, float pitch, boolean isDelayed) {
        this.event = event;
        this.pos = new Vec3d(posX, posY, posZ);
        this.category = category;
        this.volume = volume;
        this.pitch = pitch;
        this.isDelayed = isDelayed;
    }

    public SoundEvent getSoundEvent() {
        return this.event;
    }

    public Vec3d getPos() {
        return this.pos;
    }

    public SoundCategory getSoundCategory() {
        return this.category;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isDelayed() {
        return this.isDelayed;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.event = (SoundEvent)SoundEvent.field_187505_a.func_148754_a(nbt.func_74762_e("EventID"));
        this.pos = new Vec3d(nbt.func_74769_h("PosX"), nbt.func_74769_h("PosY"), nbt.func_74769_h("PosZ"));
        this.category = SoundCategory.func_187950_a((String)nbt.func_74779_i("Category"));
        this.volume = nbt.func_74760_g("Volume");
        this.pitch = nbt.func_74760_g("Pitch");
        this.isDelayed = nbt.func_74767_n("IsDelayed");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("EventID", SoundEvent.field_187505_a.func_148757_b((Object)this.event));
        nbt.func_74780_a("PosX", this.pos.field_72450_a);
        nbt.func_74780_a("PosY", this.pos.field_72448_b);
        nbt.func_74780_a("PosZ", this.pos.field_72449_c);
        nbt.func_74778_a("Category", this.category.func_187948_a());
        nbt.func_74776_a("Volume", this.volume);
        nbt.func_74776_a("Pitch", this.pitch);
        nbt.func_74757_a("IsDelayed", this.isDelayed);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }
}

