/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.proxy;

import java.util.Map;
import lyon.aom.init.BlockInit;
import lyon.aom.init.FluidInit;
import lyon.aom.init.TileEntityInit;
import lyon.aom.odm_gear.handlers.ODMGearMovementHandler;
import lyon.aom.particles.ParticleBoost;
import lyon.aom.particles.ParticleFlareSmoke;
import lyon.aom.particles.ParticleGas;
import lyon.aom.proxy.CommonProxy;
import lyon.aom.utils.AOMConfig;
import lyon.aom.utils.enums.EnumParticles;
import lyon.aom.utils.handlers.InventoryHandler;
import lyon.aom.utils.handlers.KeyBindingHandler;
import lyon.aom.utils.render.CustomTileEntityItemStackRenderer;
import lyon.aom.utils.render.EntityRenderRegistryHandler;
import lyon.aom.utils.render.HUDRenderer;
import lyon.aom.utils.render.RenderHandHandler;
import lyon.aom.utils.render.RenderPlayerHandler;
import lyon.aom.utils.render.RenderPlayerSpecialsHandler;
import lyon.aom.utils.render.RenderReflectionHandler;
import lyon.aom.utils.render.RenderUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.Tuple2;

public class ClientProxy
extends CommonProxy {
    private Map<String, Tuple2<Class, Object>> syncedConfigFields = null;

    public void setSyncedConfigFields(Map<String, Tuple2<Class, Object>> map) {
        if (this.syncedConfigFields == null) {
            this.syncedConfigFields = map;
        }
    }

    public <T> T getSyncedField(String name, Class<T> c) {
        Tuple2<Class, Object> tuple = this.syncedConfigFields.get(name);
        if (tuple._1 == c) {
            return c.cast(tuple._2);
        }
        return null;
    }

    @Override
    public void registerItemRenderer(Item item, int meta, String id) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), id));
    }

    @Override
    public void registerItemMetaRenderer(Item item, int meta, String itemLocation, String id) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(itemLocation, id));
    }

    @Override
    public void registerBlockRenderer(Block block, int meta, String id) {
    }

    @Override
    public void registerSoundEvent(String id, SoundEvent event) {
        SoundEvent.field_187505_a.func_82595_a((Object)new ResourceLocation("aom", "sounds/" + id + ".ogg"), (Object)event);
    }

    @Override
    public void registerHandlers() {
        super.registerHandlers();
        EntityRenderRegistryHandler.registerEntityRenders();
        RenderUtils.init();
        MinecraftForge.EVENT_BUS.register((Object)new RenderPlayerSpecialsHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RenderPlayerHandler());
        MinecraftForge.EVENT_BUS.register((Object)new InventoryHandler());
        MinecraftForge.EVENT_BUS.register((Object)new KeyBindingHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RenderHandHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ODMGearMovementHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HUDRenderer());
    }

    @Override
    public void registerKeyBindings() {
        KeyBindingHandler.registerKeyBindings();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(EnumParticles.EnumAOMParticleTypes type, World world, double posX, double posY, double posZ, float xSpeed, float ySpeed, float zSpeed, int ... arg) {
        if (world.field_72995_K) {
            if (type == EnumParticles.EnumAOMParticleTypes.FLARE_SMOKE) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleFlareSmoke(world, posX, posY, posZ, xSpeed, ySpeed, zSpeed, arg[0]));
            } else if (type == EnumParticles.EnumAOMParticleTypes.GAS) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleGas(world, posX, posY, posZ, xSpeed, ySpeed, zSpeed));
            } else if (type == EnumParticles.EnumAOMParticleTypes.BOOST) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleBoost(world, posX, posY, posZ, xSpeed, ySpeed, zSpeed));
            }
        }
    }

    @Override
    public void registerSpecialEntityRenderers() {
    }

    @Override
    public void registerTileEntityRenderers() {
        TileEntityInit.registerTileEntityRenderers();
    }

    @Override
    public void setTEISRs() {
        Item.func_150898_a((Block)BlockInit.GAS_TANK).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)CustomTileEntityItemStackRenderer.instance);
    }

    @Override
    public World getWorld() {
        if (Minecraft.func_71410_x() != null) {
            return Minecraft.func_71410_x().field_71441_e;
        }
        return null;
    }

    @Override
    public void preInit() {
        FluidInit.registerFluidsRenderers();
    }

    @Override
    public void postInit() {
        if (AOMConfig.useSpecialRender) {
            RenderReflectionHandler.overrideItemRendererInit();
            MinecraftForge.EVENT_BUS.register((Object)Minecraft.func_71410_x().func_175597_ag());
        }
    }
}

