/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class Timer {
    private int timer;
    private boolean isRunning;
    private int delay;
    private boolean repeat;
    private Runnable listener;
    private TickEvent.Type type;

    public Timer(UpdateTypes type, int delay, boolean repeat, Runnable listener) {
        this.delay = delay;
        this.repeat = repeat;
        this.listener = listener;
        if (type != UpdateTypes.CUSTOM) {
            if (type == UpdateTypes.CLIENT_TICK) {
                this.type = TickEvent.Type.CLIENT;
            } else if (type == UpdateTypes.PLAYER_TICK) {
                this.type = TickEvent.Type.PLAYER;
            } else if (type == UpdateTypes.RENDER_TICK) {
                this.type = TickEvent.Type.RENDER;
            } else if (type == UpdateTypes.SERVER_TICK) {
                this.type = TickEvent.Type.SERVER;
            } else if (type == UpdateTypes.WORLD_TICK) {
                this.type = TickEvent.Type.WORLD;
            }
        }
    }

    public void startTimer() {
        this.isRunning = true;
        if (this.type != null) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public void stopTimer() {
        this.isRunning = false;
        if (this.type != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public void update() {
        if (this.isRunning) {
            ++this.timer;
            if (this.timer == this.delay) {
                this.listener.run();
                this.timer = 0;
                if (!this.repeat) {
                    this.stopTimer();
                }
            }
        }
    }

    public int getTime() {
        return this.timer;
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    @SubscribeEvent
    public void onUpdate(TickEvent event) {
        if (event.type == this.type && event.phase == TickEvent.Phase.END) {
            this.update();
        }
    }

    public static enum UpdateTypes {
        CUSTOM(0),
        RENDER_TICK(1),
        WORLD_TICK(2),
        CLIENT_TICK(3),
        PLAYER_TICK(4),
        SERVER_TICK(5);

        private int id;

        private UpdateTypes(int id) {
            this.id = id;
        }

        public int getID() {
            return this.id;
        }
    }
}

