/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils;

import java.util.List;
import java.util.UUID;
import lyon.aom.capabilities.accessory.AccessoryProvider;
import lyon.aom.capabilities.accessory.IAccessory;
import lyon.aom.capabilities.odm_gear.IODMGear;
import lyon.aom.capabilities.odm_gear.ODMGearProvider;
import lyon.aom.capabilities.special_equipment.ISpecialEquipment;
import lyon.aom.capabilities.special_equipment.SpecialEquipmentProvider;
import lyon.aom.init.ItemInit;
import lyon.aom.utils.enums.EnumEntitys;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class Utils {
    public static final double getATanWithOffset(double gK, double aK) {
        if (gK >= 0.0 && aK >= 0.0) {
            return aK == 0.0 ? 0.0 : 1.5707963267948966 - Math.atan(gK / aK);
        }
        if (gK < 0.0 && aK >= 0.0) {
            return aK == 0.0 ? Math.PI : 1.5707963267948966 + Math.atan(Math.abs(gK) / aK);
        }
        if (gK <= 0.0 && aK < 0.0) {
            return 4.71238898038469 - Math.atan(Math.abs(gK) / Math.abs(aK));
        }
        if (gK > 0.0 && aK < 0.0) {
            return 4.71238898038469 + Math.atan(gK / Math.abs(aK));
        }
        return 0.0;
    }

    public static final double calcVel(double xVel, double yVel, double zVel) {
        return Math.sqrt(xVel * xVel + yVel * yVel + zVel * zVel);
    }

    public static final double getRotationSideWithRandom(double deg) {
        if (Math.abs(deg) > 0.0 && Math.abs(deg) < 180.0) {
            return 1.0;
        }
        if (Math.abs(deg) > 180.0 && Math.abs(deg) < 359.0) {
            return -1.0;
        }
        return Math.random() >= 0.5 ? 1.0 : -1.0;
    }

    public static final double modulo(double a, double mod) {
        if (a >= 0.0) {
            return a % mod;
        }
        a %= mod;
        a = mod + a;
        return a;
    }

    public static final float interpolate(float f, float pref, float partial) {
        return pref + (f - pref) * partial;
    }

    public static final float interpolateModulo(float f, float pref, float mod, float partial) {
        if ((double)Math.abs(pref - f) > (double)mod / 2.0) {
            return (float)Utils.modulo(pref + (float)((double)(f - pref) > 0.0 ? -1 : 1) * Utils.getModDifference(f, pref, mod) * partial, mod);
        }
        return pref + (f - pref) * partial;
    }

    public static float interpolateAngle(float angle, float prevAngle, float partial) {
        return Utils.interpolateModulo((float)Utils.modulo(angle, 360.0), (float)Utils.modulo(prevAngle, 360.0), 360.0f, partial);
    }

    public static final float getModDifference(float f, float pref, float mod) {
        float fdiff = (double)f > (double)mod / 2.0 ? Math.abs(mod - f) : Math.abs(f);
        float prefdiff = (double)pref > (double)mod / 2.0 ? Math.abs(mod - pref) : Math.abs(pref);
        return fdiff + prefdiff;
    }

    public static final EntityLivingBase getShooter(String name, Entity entity) {
        EntityPlayer thrower = null;
        if (name != null && !name.isEmpty() && (thrower = entity.field_70170_p.func_72924_a(name)) == null && entity.field_70170_p instanceof WorldServer) {
            try {
                Entity e = ((WorldServer)entity.field_70170_p).func_175733_a(UUID.fromString(name));
                if (e instanceof EntityLivingBase) {
                    thrower = (EntityLivingBase)e;
                }
            }
            catch (Throwable var2) {
                thrower = null;
            }
        }
        return thrower;
    }

    public static boolean contains(Object[] array, Object obj) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    public static double getHighestPointOffset(List<AxisAlignedBB> boxes, double y) {
        double highestYOff = y;
        for (AxisAlignedBB box : boxes) {
            if (!(box.field_72337_e > y)) continue;
            highestYOff = box.field_72337_e;
        }
        return highestYOff - y;
    }

    public static double getEntityDist(Entity e1, Entity e2) {
        double xDist = Math.abs(e2.field_70165_t - e1.field_70165_t);
        double yDist = Math.abs(e2.field_70163_u - e1.field_70163_u);
        double zDist = Math.abs(e2.field_70161_v - e1.field_70161_v);
        return Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist);
    }

    public static double getEntityDistInterpolated(Entity e1, Entity e2, float partialTicks) {
        double xDist = Math.abs(Utils.interpolate((float)e2.field_70165_t, (float)e2.field_70169_q, partialTicks) - Utils.interpolate((float)e1.field_70165_t, (float)e1.field_70169_q, partialTicks));
        double yDist = Math.abs(Utils.interpolate((float)e2.field_70163_u, (float)e2.field_70167_r, partialTicks) - Utils.interpolate((float)e1.field_70163_u, (float)e1.field_70167_r, partialTicks));
        double zDist = Math.abs(Utils.interpolate((float)e2.field_70161_v, (float)e2.field_70166_s, partialTicks) - Utils.interpolate((float)e1.field_70161_v, (float)e1.field_70166_s, partialTicks));
        return Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist);
    }

    public static void overrideProjectileRotation(Entity e, float yaw, float pitch) {
        yaw = (float)Utils.modulo(yaw, 360.0);
        pitch = (float)Utils.modulo(pitch, 360.0);
        double vel = Math.sqrt(e.field_70159_w * e.field_70159_w + e.field_70181_x * e.field_70181_x + e.field_70179_y * e.field_70179_y);
        e.field_70159_w = (double)(-MathHelper.func_76126_a((float)((float)Math.toRadians(Utils.modulo(yaw, 360.0)))) * MathHelper.func_76134_b((float)((float)Math.toRadians(Utils.modulo(pitch, 360.0))))) * vel;
        e.field_70181_x = (double)(-MathHelper.func_76126_a((float)((float)Math.toRadians(Utils.modulo(pitch, 360.0))))) * vel;
        e.field_70179_y = (double)(MathHelper.func_76134_b((float)((float)Math.toRadians(Utils.modulo(yaw, 360.0)))) * MathHelper.func_76134_b((float)((float)Math.toRadians(Utils.modulo(pitch, 360.0))))) * vel;
        e.field_70177_z = yaw;
        e.field_70125_A = pitch;
    }

    public static void copyRotationAnglesAndPoints(ModelBiped src, ModelBiped dest) {
        Utils.copyRotationAnglesAndPoints(src.field_78115_e, dest.field_78115_e);
        Utils.copyRotationAnglesAndPoints(src.field_78116_c, dest.field_78116_c);
        Utils.copyRotationAnglesAndPoints(src.field_178724_i, dest.field_178724_i);
        Utils.copyRotationAnglesAndPoints(src.field_178722_k, dest.field_178722_k);
        Utils.copyRotationAnglesAndPoints(src.field_178723_h, dest.field_178723_h);
        Utils.copyRotationAnglesAndPoints(src.field_178721_j, dest.field_178721_j);
    }

    public static void copyRotationAngles(ModelBiped src, ModelBiped dest) {
        Utils.copyRotationAngles(src.field_78115_e, dest.field_78115_e);
        Utils.copyRotationAngles(src.field_78116_c, dest.field_78116_c);
        Utils.copyRotationAngles(src.field_178724_i, dest.field_178724_i);
        Utils.copyRotationAngles(src.field_178722_k, dest.field_178722_k);
        Utils.copyRotationAngles(src.field_178723_h, dest.field_178723_h);
        Utils.copyRotationAngles(src.field_178721_j, dest.field_178721_j);
    }

    public static void copyRotationAnglesAndPoints(ModelRenderer src, ModelRenderer dest) {
        dest.field_78800_c = src.field_78800_c;
        dest.field_78797_d = src.field_78797_d;
        dest.field_78798_e = src.field_78798_e;
        dest.field_78795_f = src.field_78795_f;
        dest.field_78796_g = src.field_78796_g;
        dest.field_78808_h = src.field_78808_h;
    }

    public static void copyRotationAngles(ModelRenderer src, ModelRenderer dest) {
        dest.field_78795_f = src.field_78795_f;
        dest.field_78796_g = src.field_78796_g;
        dest.field_78808_h = src.field_78808_h;
    }

    public static void copyRotationsToSecondLayer(ModelPlayer model) {
        Utils.copyRotationAnglesAndPoints(model.field_78116_c, model.field_178720_f);
        Utils.copyRotationAnglesAndPoints(model.field_78115_e, model.field_178730_v);
        Utils.copyRotationAnglesAndPoints(model.field_178724_i, model.field_178734_a);
        Utils.copyRotationAnglesAndPoints(model.field_178723_h, model.field_178732_b);
        Utils.copyRotationAnglesAndPoints(model.field_178722_k, model.field_178733_c);
        Utils.copyRotationAnglesAndPoints(model.field_178721_j, model.field_178731_d);
    }

    public static int getTransferSlot(List<Slot> slots, int minIndex, int maxIndex, ItemStack stack) {
        if (stack != null) {
            for (int i = minIndex; i < maxIndex; ++i) {
                if (!slots.get(i).func_75214_a(stack) || !Utils.canBeStacked(slots.get(i).func_75211_c(), stack) && !slots.get(i).func_75211_c().func_190926_b()) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean canBeStacked(ItemStack stackSlot, ItemStack stack) {
        return stackSlot != null && stack != null && !stackSlot.func_190926_b() && !stack.func_190926_b() && (stackSlot.func_190926_b() || stack.func_190926_b() || stackSlot.func_77973_b().equals(stack.func_77973_b()) && stackSlot.func_77952_i() == stack.func_77952_i() && stackSlot.func_190916_E() < stackSlot.func_77976_d());
    }

    public static boolean mergeItemStack(List<Slot> slots, ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (!stack.func_190926_b() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot = slots.get(i);
                ItemStack itemstack = slot.func_75211_c();
                if (!(itemstack.func_190926_b() || itemstack.func_77973_b() != stack.func_77973_b() || stack.func_77981_g() && stack.func_77960_j() != itemstack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack))) {
                    int maxSize;
                    int j = itemstack.func_190916_E() + stack.func_190916_E();
                    if (j <= (maxSize = Math.min(slot.func_75219_a(), stack.func_77976_d()))) {
                        stack.func_190920_e(0);
                        itemstack.func_190920_e(j);
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.func_190916_E() < maxSize) {
                        stack.func_190918_g(maxSize - itemstack.func_190916_E());
                        itemstack.func_190920_e(maxSize);
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.func_190926_b()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = slots.get(i);
                ItemStack itemstack1 = slot1.func_75211_c();
                if (itemstack1.func_190926_b() && slot1.func_75214_a(stack)) {
                    if (stack.func_190916_E() > slot1.func_75219_a()) {
                        slot1.func_75215_d(stack.func_77979_a(slot1.func_75219_a()));
                    } else {
                        slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                    }
                    slot1.func_75218_e();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public static Vec3d rotateVector(Vec3d vec, float xRot, float yRot, float zRot) {
        return Utils.rotateVecY(Utils.rotateVecX(Utils.rotateVecZ(vec, zRot), xRot), yRot);
    }

    public static Vec3d rotateVecX(Vec3d vec, float xRot) {
        double sin = Math.sin(xRot);
        double cos = Math.cos(xRot);
        double x = vec.field_72450_a;
        double y = -sin * vec.field_72449_c + cos * vec.field_72448_b;
        double z = cos * vec.field_72449_c + sin * vec.field_72448_b;
        return new Vec3d(x, y, z);
    }

    public static Vec3d rotateVecY(Vec3d vec, float yRot) {
        double sin = Math.sin(yRot);
        double cos = Math.cos(yRot);
        double x = -sin * vec.field_72449_c + cos * vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = cos * vec.field_72449_c + sin * vec.field_72450_a;
        return new Vec3d(x, y, z);
    }

    public static Vec3d rotateVecZ(Vec3d vec, float zRot) {
        double sin = Math.sin(zRot);
        double cos = Math.cos(zRot);
        double x = cos * vec.field_72450_a + sin * vec.field_72448_b;
        double y = -sin * vec.field_72450_a + cos * vec.field_72448_b;
        double z = vec.field_72449_c;
        return new Vec3d(x, y, z);
    }

    public static int getArraySum(int[] array) {
        int a = 0;
        for (int i = 0; i < array.length; ++i) {
            a += array[i];
        }
        return a;
    }

    public static double vecDist(Vec3d pos1, Vec3d pos2) {
        double xDiff = pos2.field_72450_a - pos1.field_72450_a;
        double yDiff = pos2.field_72448_b - pos1.field_72448_b;
        double zDiff = pos2.field_72449_c - pos1.field_72449_c;
        return Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
    }

    public static Vec3d interpolateVec(Vec3d vec, Vec3d preVec, float partial) {
        return new Vec3d((double)Utils.interpolate((float)vec.field_72450_a, (float)preVec.field_72450_a, partial), (double)Utils.interpolate((float)vec.field_72448_b, (float)preVec.field_72448_b, partial), (double)Utils.interpolate((float)vec.field_72449_c, (float)preVec.field_72449_c, partial));
    }

    public static float angleBetweenVecs(Vec3d vec1, Vec3d vec2) {
        float absVec1 = (float)vec1.func_72433_c();
        float absVec2 = (float)vec2.func_72433_c();
        float dotProduct = (float)vec1.func_72430_b(vec2);
        return (float)Math.acos(dotProduct / (absVec1 * absVec2));
    }

    public static float yawVecAbsolute(Vec3d vec) {
        float angle1 = Utils.angleBetweenVecs(new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c), new Vec3d(0.0, 0.0, 1.0));
        float angle2 = Utils.angleBetweenVecs(new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c), new Vec3d(-1.0, 0.0, 0.0));
        return (float)Utils.modulo((float)((double)Math.abs(angle2) > 1.5707963267948966 ? -1 : 1) * angle1, Math.PI * 2);
    }

    public static float pitchVecAbsolute(Vec3d vec) {
        float angle1 = Utils.angleBetweenVecs(vec, new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c));
        float angle2 = Utils.angleBetweenVecs(vec, new Vec3d(0.0, -1.0, 0.0));
        return (float)Utils.modulo((float)((double)Math.abs(angle2) > 1.5707963267948966 ? -1 : 1) * angle1, Math.PI * 2);
    }

    public static ISpecialEquipment getSpecialEquipment(EntityPlayer player) {
        if (player != null && player.hasCapability(SpecialEquipmentProvider.SPECIAL_EQUIPMENT_CAP, null)) {
            ISpecialEquipment equipment = (ISpecialEquipment)player.getCapability(SpecialEquipmentProvider.SPECIAL_EQUIPMENT_CAP, null);
            return equipment;
        }
        return null;
    }

    public static IODMGear getODMGear(EntityPlayer player) {
        ISpecialEquipment equipment = Utils.getSpecialEquipment(player);
        if (equipment != null && equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.ODM_GEAR) != null && equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.ODM_GEAR).func_77973_b() == ItemInit.ODM_GEAR && equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.ODM_GEAR).hasCapability(ODMGearProvider.ODMGear_CAP, null)) {
            return (IODMGear)equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.ODM_GEAR).getCapability(ODMGearProvider.ODMGear_CAP, null);
        }
        return null;
    }

    public static IAccessory getAccessory(EntityPlayer player) {
        if (player != null && player.hasCapability(AccessoryProvider.ACCESSORY_CAP, null)) {
            IAccessory accessory = (IAccessory)player.getCapability(AccessoryProvider.ACCESSORY_CAP, null);
            return accessory;
        }
        return null;
    }

    public static RayTraceResult rayTraceBlocks(World world, Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                RayTraceResult raytraceresult;
                int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
                int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
                int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
                int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vec31.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vec31.field_72449_c);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                IBlockState iblockstate = world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (!(ignoreBlockWithoutBoundingBox && iblockstate.func_185890_d((IBlockAccess)world, blockpos) == Block.field_185506_k || !block.func_176209_a(iblockstate, stopOnLiquid) && !(block instanceof BlockLiquid) || (raytraceresult = iblockstate.func_185910_a(world, blockpos, vec31, vec32)) == null)) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec32.field_72450_a - vec31.field_72450_a;
                    double d7 = vec32.field_72448_b - vec31.field_72448_b;
                    double d8 = vec32.field_72449_c - vec31.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vec31.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vec31.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vec31.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        vec31 = new Vec3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                    }
                    l = MathHelper.func_76128_c((double)vec31.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    IBlockState iblockstate1 = world.func_180495_p(blockpos);
                    Block block1 = iblockstate1.func_177230_c();
                    if (ignoreBlockWithoutBoundingBox && iblockstate1.func_185904_a() != Material.field_151567_E && iblockstate1.func_185890_d((IBlockAccess)world, blockpos) == Block.field_185506_k) continue;
                    if (block1.func_176209_a(iblockstate1, stopOnLiquid) || block1 instanceof BlockLiquid) {
                        RayTraceResult raytraceresult1 = iblockstate1.func_185910_a(world, blockpos, vec31, vec32);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, vec31, enumfacing, blockpos);
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }

    public static float getPlayerVelocity(EntityPlayer player) {
        float dx = (float)(player.field_70165_t - player.field_70169_q);
        float dy = (float)(player.field_70163_u - player.field_70167_r);
        float dz = (float)(player.field_70161_v - player.field_70166_s);
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static RayTraceResult rayTraceEntitys(Vec3d start, Vec3d end, List<Entity> list, Entity entity) {
        RayTraceResult nearest = null;
        for (int i = 0; i < list.size(); ++i) {
            RayTraceResult ray;
            if (entity != null && list.get(i).equals((Object)entity) || (ray = list.get(i).func_174813_aQ().func_72327_a(start, end)) == null || !(list.get(i) instanceof EntityLivingBase) || nearest != null && !(ray.field_72307_f.func_72438_d(start) < nearest.field_72307_f.func_72438_d(start))) continue;
            nearest = ray = new RayTraceResult(list.get(i), ray.field_72307_f);
        }
        return nearest;
    }
}

