/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils.handlers;

import java.util.List;
import lyon.aom.entity.cannon.EntityCannon;
import lyon.aom.entity.mobile_cannon.EntityMobileCannon;
import lyon.aom.entity.thunderspear.EntityThunderspear;
import lyon.aom.init.BlockInit;
import lyon.aom.init.ItemInit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber
public class SpecialPlayerEventHandler {
    @SubscribeEvent
    public void onDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player != null && !event.player.field_70170_p.field_72995_K) {
            this.handlePlayerRidingOnDisconnect(event);
            this.handleThunderspearOnDisconnect(event);
        }
    }

    @SubscribeEvent
    public void onBlockBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getState().func_177230_c() == BlockInit.TITAN_WALL && event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() != ItemInit.REINFORCED_PICKAXE) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityPlayer && ((EntityPlayer)event.getEntity()).func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == ItemInit.ARMY_BOOTS) {
            event.setDamageMultiplier(event.getDamageMultiplier() * 0.5f);
        }
    }

    public void handlePlayerRidingOnDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.func_184187_bx() instanceof EntityCannon || event.player.func_184187_bx() instanceof EntityMobileCannon) {
            event.player.func_184210_p();
        }
    }

    public void handleThunderspearOnDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        List list = player.field_70170_p.func_72839_b((Entity)player, player.func_174813_aQ().func_186662_g(5.0));
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof EntityThunderspear)) continue;
                EntityThunderspear entity = (EntityThunderspear)((Object)list.get(i));
                if (entity.field_70128_L || !entity.isInEntity() || !entity.getEntityHit().equals((Object)player)) continue;
                entity.explode();
            }
        }
    }
}

