/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils.render;

import lyon.aom.init.ItemInit;
import lyon.aom.items.tools.ToolFlareGun;
import lyon.aom.items.tools.ToolLamp;
import lyon.aom.items.tools.ToolRifle;
import lyon.aom.utils.Utils;
import lyon.aom.utils.render.RenderReflectionHandler;
import lyon.aom.utils.render.SpecialLayerBipedArmor;
import lyon.aom.utils.render.SpecialLayerHeldItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderItemHandler {
    private static final Item[] specialItems = new Item[]{ItemInit.FLARE_GUN, ItemInit.RIFLE, ItemInit.Lamp};

    @SideOnly(value=Side.CLIENT)
    public static void cancelRender(RenderPlayerEvent.Pre event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            SpecialLayerHeldItem itemLayer = RenderReflectionHandler.getSpecialLayerHeldItem(player);
            SpecialLayerBipedArmor armorLayer = RenderReflectionHandler.getSpecialLayerBipedArmor(player);
            if (itemLayer != null && armorLayer != null) {
                if (Utils.contains(specialItems, player.func_184586_b(player.func_184591_cq() == EnumHandSide.RIGHT ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND).func_77973_b())) {
                    event.getRenderer().func_177087_b().field_178723_h.field_78807_k = true;
                    itemLayer.shouldRenderRightItem(false);
                    armorLayer.shouldRender(false);
                }
                if (Utils.contains(specialItems, player.func_184586_b(player.func_184591_cq() == EnumHandSide.LEFT ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND).func_77973_b())) {
                    event.getRenderer().func_177087_b().field_178724_i.field_78807_k = true;
                    itemLayer.shouldRenderLeftItem(false);
                    armorLayer.shouldRender(false);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void applyValues(RenderPlayerEvent.Post event) {
        if (event.getEntity() instanceof EntityPlayer) {
            // empty if block
        }
        EntityPlayer playerR = (EntityPlayer)event.getEntity();
        EntityPlayerSP playerC = Minecraft.func_71410_x().field_71439_g;
        ItemStack stackRightHand = playerR.func_184586_b(((EntityPlayer)event.getEntity()).func_184591_cq() == EnumHandSide.RIGHT ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
        ItemStack stackLeftHand = playerR.func_184586_b(((EntityPlayer)event.getEntity()).func_184591_cq() == EnumHandSide.LEFT ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
        SpecialLayerHeldItem itemLayer = RenderReflectionHandler.getSpecialLayerHeldItem(playerR);
        if (itemLayer != null) {
            if (Utils.contains(specialItems, stackRightHand.func_77973_b()) && !itemLayer.getRenderRightItem()) {
                if (stackRightHand.func_77973_b() instanceof ToolLamp) {
                    RenderItemHandler.renderLamp(event.getRenderer().func_177087_b(), playerR, EnumHandSide.RIGHT, event.getPartialRenderTick());
                } else if (stackRightHand.func_77973_b() instanceof ToolFlareGun) {
                    RenderItemHandler.renderFlareGun(event.getRenderer().func_177087_b(), playerR, EnumHandSide.RIGHT, event.getPartialRenderTick());
                } else if (stackRightHand.func_77973_b() instanceof ToolRifle) {
                    RenderItemHandler.renderRifle(event.getRenderer().func_177087_b(), playerR, EnumHandSide.RIGHT, event.getPartialRenderTick());
                }
            }
            if (Utils.contains(specialItems, stackLeftHand.func_77973_b()) && !itemLayer.getRenderLeftItem()) {
                if (stackLeftHand.func_77973_b() instanceof ToolLamp) {
                    RenderItemHandler.renderLamp(event.getRenderer().func_177087_b(), playerR, EnumHandSide.LEFT, event.getPartialRenderTick());
                } else if (stackLeftHand.func_77973_b() instanceof ToolFlareGun) {
                    RenderItemHandler.renderFlareGun(event.getRenderer().func_177087_b(), playerR, EnumHandSide.LEFT, event.getPartialRenderTick());
                } else if (stackLeftHand.func_77973_b() instanceof ToolRifle) {
                    RenderItemHandler.renderRifle(event.getRenderer().func_177087_b(), playerR, EnumHandSide.LEFT, event.getPartialRenderTick());
                }
            }
        }
    }

    public static void render(RenderPlayerEvent.Post event) {
        if (event.getEntity() instanceof EntityPlayer) {
            // empty if block
        }
        EntityPlayer playerR = (EntityPlayer)event.getEntity();
        EntityPlayerSP playerC = Minecraft.func_71410_x().field_71439_g;
        ItemStack stackRightHand = playerR.func_184586_b(((EntityPlayer)event.getEntity()).func_184591_cq() == EnumHandSide.RIGHT ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
        ItemStack stackLeftHand = playerR.func_184586_b(((EntityPlayer)event.getEntity()).func_184591_cq() == EnumHandSide.LEFT ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
        SpecialLayerHeldItem itemLayer = RenderReflectionHandler.getSpecialLayerHeldItem(playerR);
        if (itemLayer != null) {
            if (!itemLayer.getRenderRightItem()) {
                itemLayer.shouldRenderRightItem(true);
                event.getRenderer().func_177087_b().field_178723_h.field_78807_k = false;
                GlStateManager.func_179094_E();
                if (playerR.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.2133f, (float)0.0f);
                }
                itemLayer.renderHeldItem((EntityLivingBase)playerR, stackRightHand, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, EnumHandSide.RIGHT);
                GlStateManager.func_179121_F();
                event.getRenderer().func_110776_a(event.getRenderer().func_110775_a((AbstractClientPlayer)playerR));
                event.getRenderer().func_177087_b().field_178723_h.func_78785_a(0.0625f);
            }
            if (!itemLayer.getRenderLeftItem()) {
                itemLayer.shouldRenderLeftItem(true);
                event.getRenderer().func_177087_b().field_178724_i.field_78807_k = false;
                GlStateManager.func_179094_E();
                if (playerR.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.2133f, (float)0.0f);
                }
                itemLayer.renderHeldItem((EntityLivingBase)playerR, stackLeftHand, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, EnumHandSide.LEFT);
                GlStateManager.func_179121_F();
                event.getRenderer().func_110776_a(event.getRenderer().func_110775_a((AbstractClientPlayer)playerR));
                event.getRenderer().func_177087_b().field_178724_i.func_78785_a(0.0625f);
            }
        }
    }

    public static void renderFlareGun(ModelPlayer model, EntityPlayer player, EnumHandSide hand, float partialTicks) {
        float interpolatedRenderYawOffset = Utils.interpolateAngle(player.field_70761_aq, player.field_70760_ar, partialTicks);
        float interpolatedYawHead = Utils.interpolateAngle(player.field_70759_as, player.field_70758_at, partialTicks);
        if (player.func_184218_aH() && player.func_184187_bx() != null && player.func_184187_bx() instanceof EntityLivingBase && player.func_184187_bx().shouldRiderSit()) {
            interpolatedRenderYawOffset = Utils.interpolateAngle(((EntityLivingBase)player.func_184187_bx()).field_70761_aq, ((EntityLivingBase)player.func_184187_bx()).field_70760_ar, partialTicks);
            float finalRenderYaw = (float)Utils.modulo(interpolatedYawHead - interpolatedRenderYawOffset, 360.0);
            float f3 = MathHelper.func_76142_g((float)finalRenderYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            interpolatedRenderYawOffset = (float)Utils.modulo(interpolatedYawHead - f3, 360.0);
            if (f3 * f3 > 2500.0f) {
                interpolatedRenderYawOffset += f3 * 0.2f;
            }
        }
        if (hand == EnumHandSide.RIGHT) {
            model.field_178723_h.field_78795_f = (float)Math.toRadians((double)Utils.interpolateAngle(player.field_70125_A, player.field_70127_C, partialTicks) - 90.0);
            model.field_178723_h.field_78796_g = (float)Math.toRadians(interpolatedYawHead) - (float)Math.toRadians(interpolatedRenderYawOffset);
            model.field_178723_h.field_78808_h = 0.0f;
            model.field_178723_h.field_78795_f += MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks) * 0.067f)) * 0.05f;
            model.field_178723_h.field_78808_h += MathHelper.func_76134_b((float)(((float)player.field_70173_aa + partialTicks) * 0.09f)) * 0.05f + 0.05f;
        }
        if (hand == EnumHandSide.LEFT) {
            model.field_178724_i.field_78795_f = (float)Math.toRadians((double)Utils.interpolateAngle(player.field_70125_A, player.field_70127_C, partialTicks) - 90.0);
            model.field_178724_i.field_78796_g = (float)Math.toRadians(interpolatedYawHead) - (float)Math.toRadians(interpolatedRenderYawOffset);
            model.field_178724_i.field_78808_h = 0.0f;
            model.field_178724_i.field_78795_f -= MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks) * 0.067f)) * 0.05f;
            model.field_178724_i.field_78808_h -= MathHelper.func_76134_b((float)(((float)player.field_70173_aa + partialTicks) * 0.09f)) * 0.05f + 0.05f;
        }
    }

    public static void renderRifle(ModelPlayer model, EntityPlayer player, EnumHandSide hand, float partialTicks) {
        float interpolatedRenderYawOffset = Utils.interpolateAngle(player.field_70761_aq, player.field_70760_ar, partialTicks);
        float interpolatedYawHead = Utils.interpolateAngle(player.field_70759_as, player.field_70758_at, partialTicks);
        if (player.func_184218_aH() && player.func_184187_bx() != null && player.func_184187_bx() instanceof EntityLivingBase && player.func_184187_bx().shouldRiderSit()) {
            interpolatedRenderYawOffset = Utils.interpolateAngle(((EntityLivingBase)player.func_184187_bx()).field_70761_aq, ((EntityLivingBase)player.func_184187_bx()).field_70760_ar, partialTicks);
            float finalRenderYaw = (float)Utils.modulo(interpolatedYawHead - interpolatedRenderYawOffset, 360.0);
            float f3 = MathHelper.func_76142_g((float)finalRenderYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            interpolatedRenderYawOffset = (float)Utils.modulo(interpolatedYawHead - f3, 360.0);
            if (f3 * f3 > 2500.0f) {
                interpolatedRenderYawOffset += f3 * 0.2f;
            }
        }
        if (hand == EnumHandSide.RIGHT) {
            model.field_178723_h.field_78795_f = (float)Math.toRadians((double)Utils.interpolateAngle(player.field_70125_A, player.field_70127_C, partialTicks) - 90.0);
            model.field_178723_h.field_78796_g = (float)Math.toRadians(interpolatedYawHead) - (float)Math.toRadians(interpolatedRenderYawOffset);
            model.field_178723_h.field_78808_h = 0.0f;
            model.field_178723_h.field_78795_f += MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks) * 0.067f)) * 0.05f;
            model.field_178723_h.field_78808_h += MathHelper.func_76134_b((float)(((float)player.field_70173_aa + partialTicks) * 0.09f)) * 0.05f + 0.05f;
        }
        if (hand == EnumHandSide.LEFT) {
            model.field_178724_i.field_78795_f = (float)Math.toRadians((double)Utils.interpolateAngle(player.field_70125_A, player.field_70127_C, partialTicks) - 90.0);
            model.field_178724_i.field_78796_g = (float)Math.toRadians(interpolatedYawHead) - (float)Math.toRadians(interpolatedRenderYawOffset);
            model.field_178724_i.field_78808_h = 0.0f;
            model.field_178724_i.field_78795_f -= MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks) * 0.067f)) * 0.05f;
            model.field_178724_i.field_78808_h -= MathHelper.func_76134_b((float)(((float)player.field_70173_aa + partialTicks) * 0.09f)) * 0.05f + 0.05f;
        }
    }

    public static void renderLamp(ModelPlayer model, EntityPlayer player, EnumHandSide hand, float partialTicks) {
        if (hand == EnumHandSide.RIGHT) {
            model.field_178723_h.field_78795_f = (float)Math.toRadians((double)Utils.interpolateAngle(player.field_70125_A, player.field_70127_C, partialTicks) - 90.0);
            model.field_178723_h.field_78796_g = 0.0f;
            model.field_178723_h.field_78808_h = 0.0f;
            model.field_178723_h.field_78795_f += MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks) * 0.067f)) * 0.05f;
            model.field_178723_h.field_78808_h += MathHelper.func_76134_b((float)(((float)player.field_70173_aa + partialTicks) * 0.09f)) * 0.05f + 0.05f;
        }
        if (hand == EnumHandSide.LEFT) {
            model.field_178724_i.field_78795_f = (float)Math.toRadians((double)Utils.interpolateAngle(player.field_70125_A, player.field_70127_C, partialTicks) - 90.0);
            model.field_178724_i.field_78796_g = 0.0f;
            model.field_178724_i.field_78808_h = 0.0f;
            model.field_178724_i.field_78795_f -= MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks) * 0.067f)) * 0.05f;
            model.field_178724_i.field_78808_h -= MathHelper.func_76134_b((float)(((float)player.field_70173_aa + partialTicks) * 0.09f)) * 0.05f + 0.05f;
        }
    }

    public static boolean isSpecialRenderItem(Item item) {
        return Utils.contains(specialItems, item);
    }
}

