/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils.render;

import lyon.aom.capabilities.odm_gear.IODMGear;
import lyon.aom.capabilities.special_equipment.ISpecialEquipment;
import lyon.aom.entity.hook.EntityHook;
import lyon.aom.init.ItemInit;
import lyon.aom.odm_gear.model.ODMGearModel;
import lyon.aom.odm_gear.render.CableRenderer;
import lyon.aom.utils.Utils;
import lyon.aom.utils.enums.EnumEntitys;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RenderSpecialEquipmentHandler {
    private static final ModelBiped beltModel = new ModelBiped(0.41f);
    private static final ModelBiped odmGearModel = new ODMGearModel();
    private static final ResourceLocation beltTexture = new ResourceLocation("aom", "textures/models/armor/belt.png");
    private static final ResourceLocation odmGearTexture = new ResourceLocation("aom", "textures/models/odm_gear/odm_gear.png");
    private static final ResourceLocation cableTexture = new ResourceLocation("aom", "textures/models/odm_gear/cable.png");

    @SideOnly(value=Side.CLIENT)
    public static void render(RenderPlayerEvent.Post event) {
        EntityPlayer player;
        ISpecialEquipment equipment;
        if (event.getEntity() instanceof EntityPlayer && (equipment = Utils.getSpecialEquipment(player = (EntityPlayer)event.getEntity())) != null && !player.func_175149_v() && !player.func_82150_aj()) {
            GlStateManager.func_179094_E();
            if (equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.BELT).func_77973_b().equals(ItemInit.BELT)) {
                RenderSpecialEquipmentHandler.renderBelt((ModelBiped)event.getRenderer().func_177087_b(), player);
            }
            if (equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.ODM_GEAR).func_77973_b().equals(ItemInit.ODM_GEAR)) {
                RenderSpecialEquipmentHandler.renderODMGear((ModelBiped)event.getRenderer().func_177087_b(), player);
            }
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderExtra(EntityPlayer player, float partialTick) {
        IODMGear odm_gear;
        if (!player.func_175149_v() && !player.func_82150_aj() && (odm_gear = Utils.getODMGear(player)) != null) {
            EntityHook leftHook = odm_gear.getHook(EnumHandSide.LEFT, player.field_70170_p);
            EntityHook rightHook = odm_gear.getHook(EnumHandSide.RIGHT, player.field_70170_p);
            GlStateManager.func_179094_E();
            if (player.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.0133f, (float)0.0f);
            }
            if (leftHook != null) {
                CableRenderer.renderCable(EnumHandSide.LEFT, player, odm_gear, leftHook, cableTexture, partialTick);
            }
            if (rightHook != null) {
                CableRenderer.renderCable(EnumHandSide.RIGHT, player, odm_gear, rightHook, cableTexture, partialTick);
            }
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderBelt(ModelBiped playerModel, EntityPlayer player) {
        Utils.copyRotationAnglesAndPoints(playerModel, beltModel);
        beltModel.func_178686_a((ModelBase)playerModel);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(beltTexture);
        RenderSpecialEquipmentHandler.renderModelBiped(beltModel, 0.0625f);
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderODMGear(ModelBiped playerModel, EntityPlayer player) {
        Utils.copyRotationAnglesAndPoints(playerModel, odmGearModel);
        odmGearModel.func_178686_a((ModelBase)playerModel);
        if (odmGearModel instanceof ODMGearModel) {
            ((ODMGearModel)odmGearModel).setPartVisibilities(player);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(odmGearTexture);
        RenderSpecialEquipmentHandler.renderModelBiped(odmGearModel, 0.0625f);
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderModelBiped(ModelBiped model, float scale) {
        model.field_78115_e.func_78785_a(scale);
        model.field_78116_c.func_78785_a(scale);
        model.field_178724_i.func_78785_a(scale);
        model.field_178722_k.func_78785_a(scale);
        model.field_178723_h.func_78785_a(scale);
        model.field_178721_j.func_78785_a(scale);
    }
}

