/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils.render;

import java.nio.FloatBuffer;
import lyon.aom.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    private static boolean flag;
    private static FloatBuffer brightnessBuffer;
    private static final DynamicTexture TEXTURE_BRIGHTNESS;

    @SideOnly(value=Side.CLIENT)
    public static void init() {
        RenderUtils util = new RenderUtils();
    }

    @SideOnly(value=Side.CLIENT)
    public static void preRender(EntityLivingBase entity, RenderLivingBase renderer, float partialTick, float scale) {
        RenderUtils.preRender(entity, renderer.func_177087_b(), partialTick, scale);
    }

    @SideOnly(value=Side.CLIENT)
    public static void preRender(EntityLivingBase entity, ModelBase model, float partialTick, float scale) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float interpolatedRenderYawOffset = Utils.interpolateAngle(entity.field_70761_aq, entity.field_70760_ar, partialTick);
        float interpolatedYawHead = RenderUtils.interpolate(entity.field_70759_as, entity.field_70758_at, partialTick);
        boolean shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        interpolatedRenderYawOffset = RenderUtils.calculateInterpolatedRenderYawOffset(shouldSit, entity, interpolatedYawHead, interpolatedRenderYawOffset, partialTick);
        if (entity instanceof EntityPlayer) {
            if (entity.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.125f, (float)0.0f);
            }
            GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        }
        GlStateManager.func_179129_p();
        if (!entity.equals((Object)player)) {
            RenderUtils.translateToEntity((Entity)player, (Entity)entity, partialTick);
        }
        if (entity.func_70089_S() && entity.func_70608_bn() && entity instanceof EntityPlayer) {
            EntityPlayer player2 = (EntityPlayer)entity;
            GlStateManager.func_179109_b((float)player2.field_71079_bU, (float)player2.field_71082_cx, (float)player2.field_71089_bV);
        }
        RenderUtils.applyRotationsPlayer(entity, interpolatedRenderYawOffset, partialTick);
        RenderUtils.prepareScale(entity, partialTick, scale);
        GlStateManager.func_179141_d();
        RenderUtils.setRotationAngles(model, entity, partialTick);
        flag = RenderUtils.setBrightness(entity, partialTick, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void postRender(EntityLivingBase entity, RenderLivingBase renderer, float partialTick, float scale) {
        if (flag) {
            RenderUtils.unsetBrightness();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179089_o();
        if (entity instanceof EntityPlayer) {
            GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        }
    }

    public static void setRotationAngles(ModelBase model, EntityLivingBase entity, float partialTick) {
        boolean shouldSit;
        float interpolatedLimbSwing = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTick);
        float interpolatedLimbSwingAmount = entity.field_184618_aE + (entity.field_70721_aZ - entity.field_184618_aE) * partialTick;
        float interpolatedYawHead = RenderUtils.interpolate(entity.field_70759_as, entity.field_70758_at, partialTick);
        float interpolatedRenderYawOffset = RenderUtils.interpolate(entity.field_70761_aq, entity.field_70760_ar, partialTick);
        float interpolatedPitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTick;
        float finalRenderYaw = interpolatedYawHead - interpolatedRenderYawOffset;
        model.field_78095_p = entity.func_70678_g(partialTick);
        model.field_78093_q = shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        model.field_78091_s = entity.func_70631_g_();
        interpolatedRenderYawOffset = RenderUtils.calculateInterpolatedRenderYawOffset(shouldSit, entity, interpolatedYawHead, interpolatedRenderYawOffset, partialTick);
        if (shouldSit && entity.func_184187_bx() instanceof EntityLivingBase) {
            finalRenderYaw = interpolatedYawHead - interpolatedRenderYawOffset;
        }
        if (!entity.func_184218_aH()) {
            finalRenderYaw = interpolatedYawHead - interpolatedRenderYawOffset;
        }
        model.func_78087_a(interpolatedLimbSwing, interpolatedLimbSwingAmount, (float)entity.field_70173_aa + partialTick, finalRenderYaw, interpolatedPitch, 0.0625f, (Entity)entity);
    }

    private static float calculateInterpolatedRenderYawOffset(boolean shouldSit, EntityLivingBase entity, float interpolatedYawHead, float interpolatedRenderYawOffset, float partialTick) {
        if (shouldSit && entity.func_184187_bx() instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)entity.func_184187_bx();
            interpolatedRenderYawOffset = RenderUtils.interpolate(entitylivingbase.field_70761_aq, entitylivingbase.field_70760_ar, partialTick);
            float finalRenderYaw = interpolatedYawHead - interpolatedRenderYawOffset;
            float f3 = MathHelper.func_76142_g((float)finalRenderYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            interpolatedRenderYawOffset = interpolatedYawHead - f3;
            if (f3 * f3 > 2500.0f) {
                interpolatedRenderYawOffset += f3 * 0.2f;
            }
        }
        return interpolatedRenderYawOffset;
    }

    private static void applyRotationsPlayer(EntityLivingBase entity, float rotationYaw, float partialTicks) {
        if (entity instanceof EntityPlayer) {
            if (entity.func_70089_S() && entity.func_70608_bn()) {
                GlStateManager.func_179114_b((float)((EntityPlayer)entity).func_71051_bG(), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (entity.func_184613_cA()) {
                RenderUtils.applyRotationsLiving(entity, rotationYaw, partialTicks);
                float f = (float)entity.func_184599_cB() + partialTicks;
                float f1 = MathHelper.func_76131_a((float)(f * f / 100.0f), (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)(f1 * (-90.0f - entity.field_70125_A)), (float)1.0f, (float)0.0f, (float)0.0f);
                Vec3d vec3d = entity.func_70676_i(partialTicks);
                double d0 = entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y;
                double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
                if (d0 > 0.0 && d1 > 0.0) {
                    double d2 = (entity.field_70159_w * vec3d.field_72450_a + entity.field_70179_y * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                    double d3 = entity.field_70159_w * vec3d.field_72449_c - entity.field_70179_y * vec3d.field_72450_a;
                    GlStateManager.func_179114_b((float)((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
                }
            } else {
                RenderUtils.applyRotationsLiving(entity, rotationYaw, partialTicks);
            }
        }
    }

    private static float interpolate(float yawOffset, float prevYawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    private static void applyRotationsLiving(EntityLivingBase entity, float rotationYaw, float partialTicks) {
        GlStateManager.func_179114_b((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entity.field_70725_aQ > 0) {
            float f = ((float)entity.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            GlStateManager.func_179114_b((float)(f * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            String s = TextFormatting.func_110646_a((String)entity.func_70005_c_());
            if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s)) && (!(entity instanceof EntityPlayer) || ((EntityPlayer)entity).func_175148_a(EnumPlayerModelParts.CAPE))) {
                GlStateManager.func_179109_b((float)0.0f, (float)(entity.field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    private static void prepareScale(EntityLivingBase entity, float partialTicks, float scale) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        if (entity instanceof EntityPlayer) {
            GlStateManager.func_179152_a((float)0.9375f, (float)0.9375f, (float)0.9375f);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)(-24.016f * scale), (float)0.0f);
    }

    private static boolean setBrightness(EntityLivingBase entity, float partialTicks, boolean combineTextures) {
        boolean flag1;
        float f = entity.func_70013_c();
        int i = 0;
        boolean flag = (i >> 24 & 0xFF) > 0;
        boolean bl = flag1 = entity.field_70737_aN > 0 || entity.field_70725_aQ > 0;
        if (!flag && !flag1) {
            return false;
        }
        if (!flag && !combineTextures) {
            return false;
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179098_w();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176093_u);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)OpenGlHelper.field_176094_t);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_176092_v);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176080_A, (int)OpenGlHelper.field_176092_v);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176076_D, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        brightnessBuffer.position(0);
        if (flag1) {
            brightnessBuffer.put(1.0f);
            brightnessBuffer.put(0.0f);
            brightnessBuffer.put(0.0f);
            brightnessBuffer.put(0.3f);
        } else {
            float f1 = (float)(i >> 24 & 0xFF) / 255.0f;
            float f2 = (float)(i >> 16 & 0xFF) / 255.0f;
            float f3 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f4 = (float)(i & 0xFF) / 255.0f;
            brightnessBuffer.put(f2);
            brightnessBuffer.put(f3);
            brightnessBuffer.put(f4);
            brightnessBuffer.put(1.0f - f1);
        }
        brightnessBuffer.flip();
        GlStateManager.func_187448_b((int)8960, (int)8705, (FloatBuffer)brightnessBuffer);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_176096_r);
        GlStateManager.func_179098_w();
        GlStateManager.func_179144_i((int)TEXTURE_BRIGHTNESS.func_110552_b());
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        return true;
    }

    private static void unsetBrightness() {
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179098_w();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176093_u);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176079_G, (int)OpenGlHelper.field_176093_u);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176086_J, (int)770);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)5890);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_176096_r);
        GlStateManager.func_179090_x();
        GlStateManager.func_179144_i((int)0);
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)5890);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static boolean bindEntityTexture(Entity entity, Render renderer, ResourceLocation entityTexture) {
        if (entityTexture == null) {
            return false;
        }
        renderer.func_177068_d().field_78724_e.func_110577_a(entityTexture);
        return true;
    }

    public static void translateToEntity(Entity client, Entity render, float partialTick) {
        GlStateManager.func_179137_b((double)RenderUtils.getEntityXOffset(render, client, partialTick), (double)RenderUtils.getEntityYOffset(render, client, partialTick), (double)RenderUtils.getEntityZOffset(render, client, partialTick));
    }

    public static final double getEntityXOffset(Entity eR, Entity eC, float partialTick) {
        return Utils.interpolate((float)eR.field_70165_t, (float)eR.field_70169_q, partialTick) - Utils.interpolate((float)eC.field_70165_t, (float)eC.field_70169_q, partialTick);
    }

    public static final double getEntityYOffset(Entity eR, Entity eC, float partialTick) {
        return Utils.interpolate((float)eR.field_70163_u, (float)eR.field_70167_r, partialTick) - Utils.interpolate((float)eC.field_70163_u, (float)eC.field_70167_r, partialTick);
    }

    public static final double getEntityZOffset(Entity eR, Entity eC, float partialTick) {
        return Utils.interpolate((float)eR.field_70161_v, (float)eR.field_70166_s, partialTick) - Utils.interpolate((float)eC.field_70161_v, (float)eC.field_70166_s, partialTick);
    }

    public static void translateToEntity(Entity client, TileEntity render, float partialTick) {
        GlStateManager.func_179137_b((double)RenderUtils.getEntityXOffset(render, client, partialTick), (double)RenderUtils.getEntityYOffset(render, client, partialTick), (double)RenderUtils.getEntityZOffset(render, client, partialTick));
    }

    public static final double getEntityXOffset(TileEntity eR, Entity eC, float partialTick) {
        return Utils.interpolate((float)eR.func_174877_v().func_177958_n() + 0.5f, (float)eR.func_174877_v().func_177958_n() + 0.5f, partialTick) - Utils.interpolate((float)eC.field_70165_t, (float)eC.field_70169_q, partialTick);
    }

    public static final double getEntityYOffset(TileEntity eR, Entity eC, float partialTick) {
        return Utils.interpolate(eR.func_174877_v().func_177956_o(), eR.func_174877_v().func_177956_o(), partialTick) - Utils.interpolate((float)eC.field_70163_u, (float)eC.field_70167_r, partialTick);
    }

    public static final double getEntityZOffset(TileEntity eR, Entity eC, float partialTick) {
        return Utils.interpolate((float)eR.func_174877_v().func_177952_p() + 0.5f, (float)eR.func_174877_v().func_177952_p() + 0.5f, partialTick) - Utils.interpolate((float)eC.field_70161_v, (float)eC.field_70166_s, partialTick);
    }

    static {
        brightnessBuffer = GLAllocation.func_74529_h((int)4);
        TEXTURE_BRIGHTNESS = new DynamicTexture(16, 16);
        int[] aint = TEXTURE_BRIGHTNESS.func_110565_c();
        for (int i = 0; i < 256; ++i) {
            aint[i] = -1;
        }
        TEXTURE_BRIGHTNESS.func_110564_a();
    }
}

