/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils.render;

import lyon.aom.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;

public class SpecialLayerBipedArmor
extends LayerArmorBase<ModelBiped> {
    private boolean shouldRender = true;
    private RenderLivingBase<?> renderer;

    public SpecialLayerBipedArmor(RenderLivingBase<?> rendererIn) {
        super(rendererIn);
        this.renderer = rendererIn;
    }

    protected void func_177177_a() {
        this.field_177189_c = new ModelBiped(0.5f);
        this.field_177186_d = new ModelBiped(1.0f);
    }

    public ModelBiped getModelLeggings() {
        return (ModelBiped)this.field_177189_c;
    }

    public ModelBiped getModelArmor() {
        return (ModelBiped)this.field_177186_d;
    }

    public void shouldRender(boolean b) {
        this.shouldRender = b;
        ((ModelBiped)this.field_177189_c).field_78115_e.field_78807_k = !b;
        ((ModelBiped)this.field_177189_c).field_78116_c.field_78807_k = !b;
        ((ModelBiped)this.field_177189_c).field_178724_i.field_78807_k = !b;
        ((ModelBiped)this.field_177189_c).field_178722_k.field_78807_k = !b;
        ((ModelBiped)this.field_177189_c).field_178723_h.field_78807_k = !b;
        ((ModelBiped)this.field_177189_c).field_178721_j.field_78807_k = !b;
        ((ModelBiped)this.field_177186_d).field_78115_e.field_78807_k = !b;
        ((ModelBiped)this.field_177186_d).field_78116_c.field_78807_k = !b;
        ((ModelBiped)this.field_177186_d).field_178724_i.field_78807_k = !b;
        ((ModelBiped)this.field_177186_d).field_178722_k.field_78807_k = !b;
        ((ModelBiped)this.field_177186_d).field_178723_h.field_78807_k = !b;
        ((ModelBiped)this.field_177186_d).field_178721_j.field_78807_k = !b;
    }

    public boolean getShouldRender() {
        return this.shouldRender;
    }

    public void render(ModelBiped model, EntityPlayer player, float partialTick) {
        if (this.shouldRender) {
            this.applyRotationAnglesToArmor(model, player, partialTick);
            this.render(model, player, EntityEquipmentSlot.HEAD, partialTick, 0.0625f);
            this.render(model, player, EntityEquipmentSlot.CHEST, partialTick, 0.0625f);
            this.render(model, player, EntityEquipmentSlot.LEGS, partialTick, 0.0625f);
            this.render(model, player, EntityEquipmentSlot.FEET, partialTick, 0.0625f);
        }
    }

    public void render(ModelBiped model, EntityPlayer player, EntityEquipmentSlot slot, float partialTick, float scale) {
        ItemArmor itemArmor;
        ItemStack stack;
        GlStateManager.func_179094_E();
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)(-0.2128f * scale), (float)0.0f);
        }
        if (EntityEquipmentSlot.Type.ARMOR == slot.func_188453_a() && (stack = player.func_184582_a(slot)) != null && stack.func_77973_b() instanceof ItemArmor && (itemArmor = (ItemArmor)stack.func_77973_b()).func_185083_B_() == slot) {
            ModelBiped t = (ModelBiped)this.func_188360_a(slot);
            t = this.getArmorModelHook((EntityLivingBase)player, stack, slot, t);
            t.func_178686_a(this.renderer.func_177087_b());
            this.setModelSlotVisible(t, slot);
            this.renderer.func_110776_a(this.getArmorResource((Entity)player, stack, slot, null));
            if (itemArmor.hasOverlay(stack)) {
                int i = itemArmor.func_82814_b(stack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)(1.0f * f), (float)(1.0f * f1), (float)(1.0f * f2), (float)1.0f);
                this.render(t, scale);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.render(t, scale);
            if (stack.func_77962_s()) {
                this.renderEnchantedGlint(this.renderer, (EntityLivingBase)player, t, partialTick, scale);
            }
        }
        GlStateManager.func_179121_F();
    }

    public void render(ModelBiped model, float scale) {
        model.field_78115_e.func_78785_a(scale);
        model.field_78116_c.func_78785_a(scale);
        model.field_178724_i.func_78785_a(scale);
        model.field_178722_k.func_78785_a(scale);
        model.field_178723_h.func_78785_a(scale);
        model.field_178721_j.func_78785_a(scale);
    }

    public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (this.shouldRender) {
            super.func_177141_a(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    public void applyRotationAnglesToArmor(ModelBiped model, EntityPlayer player, float partialTick) {
        Utils.copyRotationAnglesAndPoints(model, (ModelBiped)this.field_177186_d);
        Utils.copyRotationAnglesAndPoints(model, (ModelBiped)this.field_177189_c);
        ((ModelBiped)this.field_177186_d).field_78116_c.field_78796_g = (float)Math.toRadians(Utils.interpolateAngle(player.field_70759_as, player.field_70758_at, partialTick)) - (float)Math.toRadians(Utils.interpolateAngle(player.field_70761_aq, player.field_70760_ar, partialTick));
        ((ModelBiped)this.field_177189_c).field_78116_c.field_78796_g = (float)Math.toRadians(Utils.interpolateAngle(player.field_70759_as, player.field_70758_at, partialTick)) - (float)Math.toRadians(Utils.interpolateAngle(player.field_70761_aq, player.field_70760_ar, partialTick));
    }

    public void renderEnchantedGlint(RenderLivingBase render, EntityLivingBase entity, ModelBiped model, float partialTick, float scale) {
        float f = (float)entity.field_70173_aa + partialTick;
        render.func_110776_a(field_177188_b);
        Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
        GlStateManager.func_179147_l();
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179132_a((boolean)false);
        float f1 = 0.5f;
        GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        for (int i = 0; i < 2; ++i) {
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            float f2 = 0.76f;
            GlStateManager.func_179131_c((float)0.38f, (float)0.19f, (float)0.608f, (float)1.0f);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            float f3 = 0.33333334f;
            GlStateManager.func_179152_a((float)0.33333334f, (float)0.33333334f, (float)0.33333334f);
            GlStateManager.func_179114_b((float)(30.0f - (float)i * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(f * (0.001f + (float)i * 0.003f) * 20.0f), (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            this.render(model, scale);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
    }

    protected void setModelSlotVisible(ModelBiped p_188359_1_, EntityEquipmentSlot slotIn) {
        this.setModelVisible(p_188359_1_);
        switch (slotIn) {
            case HEAD: {
                p_188359_1_.field_78116_c.field_78806_j = true;
                p_188359_1_.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                p_188359_1_.field_78115_e.field_78806_j = true;
                p_188359_1_.field_178723_h.field_78806_j = true;
                p_188359_1_.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                p_188359_1_.field_78115_e.field_78806_j = true;
                p_188359_1_.field_178721_j.field_78806_j = true;
                p_188359_1_.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                p_188359_1_.field_178721_j.field_78806_j = true;
                p_188359_1_.field_178722_k.field_78806_j = true;
            }
        }
    }

    protected void setModelVisible(ModelBiped model) {
        model.func_178719_a(false);
    }

    protected ModelBiped getArmorModelHook(EntityLivingBase entity, ItemStack itemStack, EntityEquipmentSlot slot, ModelBiped model) {
        return ForgeHooksClient.getArmorModel((EntityLivingBase)entity, (ItemStack)itemStack, (EntityEquipmentSlot)slot, (ModelBiped)model);
    }
}

