/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils.render;

import java.util.ArrayList;
import java.util.List;
import lyon.aom.utils.Utils;
import lyon.aom.utils.render.Face;
import lyon.aom.utils.render.FaceQuad;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;

public class UtilsRender {
    public static void renderCuboid(Tessellator tes, double centerX, double centerY, double centerZ, double width, double depth, double height, float xRot, float yRot, float zRot, int lightmap, ResourceLocation tex) {
        UtilsRender.renderFace(tes, new FaceQuad((float)width, (float)depth, false), new Vec3d(0.0, 0.0, 0.0), centerX, centerY, centerZ, Utils.rotateVector(Orientations.DOWN.getNormVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.DOWN.getXVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.DOWN.getYVec(), xRot, yRot, zRot), height / 2.0, lightmap, tex);
        UtilsRender.renderFace(tes, new FaceQuad((float)width, (float)depth, false), new Vec3d(0.0, 0.0, 0.0), centerX, centerY, centerZ, Utils.rotateVector(Orientations.UP.getNormVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.UP.getXVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.UP.getYVec(), xRot, yRot, zRot), height / 2.0, lightmap, tex);
        UtilsRender.renderFace(tes, new FaceQuad((float)depth, (float)height, false), new Vec3d(0.0, 0.0, 0.0), centerX, centerY, centerZ, Utils.rotateVector(Orientations.NORTH.getNormVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.NORTH.getXVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.NORTH.getYVec(), xRot, yRot, zRot), width / 2.0, lightmap, tex);
        UtilsRender.renderFace(tes, new FaceQuad((float)depth, (float)height, false), new Vec3d(0.0, 0.0, 0.0), centerX, centerY, centerZ, Utils.rotateVector(Orientations.SOUTH.getNormVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.SOUTH.getXVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.SOUTH.getYVec(), xRot, yRot, zRot), width / 2.0, lightmap, tex);
        UtilsRender.renderFace(tes, new FaceQuad((float)width, (float)height, false), new Vec3d(0.0, 0.0, 0.0), centerX, centerY, centerZ, Utils.rotateVector(Orientations.EAST.getNormVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.EAST.getXVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.EAST.getYVec(), xRot, yRot, zRot), depth / 2.0, lightmap, tex);
        UtilsRender.renderFace(tes, new FaceQuad((float)width, (float)height, false), new Vec3d(0.0, 0.0, 0.0), centerX, centerY, centerZ, Utils.rotateVector(Orientations.WEST.getNormVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.WEST.getXVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.WEST.getYVec(), xRot, yRot, zRot), depth / 2.0, lightmap, tex);
    }

    public static void renderQuad(Tessellator tes, EnumFacing facing, double centerX, double centerY, double centerZ, double width, double height, float xRot, float yRot, float zRot, int lightmap, double dist, boolean scale, ResourceLocation tex) {
        UtilsRender.renderFace(tes, new FaceQuad((float)width, (float)height, scale), new Vec3d(0.0, 0.0, 0.0), centerX, centerY, centerZ, Utils.rotateVector(Orientations.getOrientationForFacing(facing).getNormVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.getOrientationForFacing(facing).getXVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.getOrientationForFacing(facing).getYVec(), xRot, yRot, zRot), dist, lightmap, tex);
    }

    public static void renderQuad(Tessellator tes, EnumFacing facing, Vec3d offset, double centerX, double centerY, double centerZ, double width, double height, float xRot, float yRot, float zRot, int lightmap, double dist, boolean scale, ResourceLocation tex) {
        UtilsRender.renderFace(tes, new FaceQuad((float)width, (float)height, scale), Utils.rotateVector(offset, xRot, yRot, zRot), centerX, centerY, centerZ, Utils.rotateVector(Orientations.getOrientationForFacing(facing).getNormVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.getOrientationForFacing(facing).getXVec(), xRot, yRot, zRot), Utils.rotateVector(Orientations.getOrientationForFacing(facing).getYVec(), xRot, yRot, zRot), dist, lightmap, tex);
    }

    public static void renderFace(Tessellator tes, Face face, Vec3d offset, double centerX, double centerY, double centerZ, Vec3d normVec, Vec3d vecX, Vec3d vecY, double dist, int lightmap, ResourceLocation tex) {
        vecX = vecX.func_72432_b();
        vecY = vecY.func_72432_b();
        ArrayList<Vec3d> vertexes = new ArrayList<Vec3d>();
        Vec3d faceMiddle = new Vec3d(centerX, centerY, centerZ).func_178787_e(normVec.func_72432_b().func_186678_a(dist)).func_178787_e(offset);
        if (face.getVertexes() != null && !face.getVertexes().isEmpty()) {
            for (Vec2f vec : face.getVertexes()) {
                vertexes.add(faceMiddle.func_178787_e(vecX.func_186678_a((double)vec.field_189982_i)).func_178787_e(vecY.func_186678_a((double)vec.field_189983_j)));
            }
        }
        UtilsRender.renderVertexes(tes, face, vertexes, normVec, lightmap, tex);
    }

    public static void renderVertexes(Tessellator tes, Face face, List<Vec3d> vertexes, Vec3d normVec, int lightmap, ResourceLocation tex) {
        if (vertexes != null && !vertexes.isEmpty()) {
            int l1 = lightmap >> 16 & 0xFFFF;
            int l2 = lightmap & 0xFFFF;
            int i = 0;
            BufferBuilder buf = tes.func_178180_c();
            buf.func_181668_a(7, DefaultVertexFormats.field_181711_k);
            for (Vec3d vec : vertexes) {
                buf.func_181662_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                buf.func_187315_a((double)face.getTexVertexes().get((int)i).field_189982_i, (double)face.getTexVertexes().get((int)i).field_189983_j);
                buf.func_187314_a(l1, l2);
                buf.func_181666_a(1.0f, 1.0f, 1.0f, 1.0f);
                buf.func_181675_d();
                ++i;
            }
            tes.func_78381_a();
        }
    }

    public static enum Orientations {
        DOWN("down", new Vec3d(0.0, -1.0, 0.0), new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0)),
        UP("up", new Vec3d(0.0, 1.0, 0.0), new Vec3d(-1.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0)),
        NORTH("north", new Vec3d(0.0, 0.0, -1.0), new Vec3d(-1.0, 0.0, 0.0), new Vec3d(0.0, 1.0, 0.0)),
        SOUTH("south", new Vec3d(0.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.0, 1.0, 0.0)),
        WEST("west", new Vec3d(-1.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 1.0, 0.0)),
        EAST("east", new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.0, 0.0, -1.0), new Vec3d(0.0, 1.0, 0.0));

        private String name;
        private Vec3d normVec;
        private Vec3d xVec;
        private Vec3d yVec;

        private Orientations(String name, Vec3d normVec, Vec3d xVec, Vec3d yVec) {
            this.name = name;
            this.normVec = normVec;
            this.xVec = xVec;
            this.yVec = yVec;
        }

        public Vec3d getNormVec() {
            return this.normVec;
        }

        public Vec3d getXVec() {
            return this.xVec;
        }

        public Vec3d getYVec() {
            return this.yVec;
        }

        public String getName() {
            return this.name;
        }

        public static Orientations getOrientationByName(String name) {
            for (int i = 0; i < Orientations.values().length; ++i) {
                if (!Orientations.values()[i].getName().equals(name)) continue;
                return Orientations.values()[i];
            }
            return null;
        }

        public static Orientations getOrientationForFacing(EnumFacing facing) {
            return Orientations.getOrientationByName(facing.func_176742_j());
        }
    }
}

