/*
 * Decompiled with CFR 0.152.
 */
package com.camellias.gulliverreborn;

import com.artemis.artemislib.compatibilities.sizeCap.ISizeCap;
import com.artemis.artemislib.compatibilities.sizeCap.SizeCapPro;
import com.camellias.gulliverreborn.ClimbingHandler;
import com.camellias.gulliverreborn.Config;
import com.camellias.gulliverreborn.MyResizeCommand;
import com.camellias.gulliverreborn.OthersResizeCommand;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockClay;
import net.minecraft.block.BlockConcretePowder;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockRedFlower;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

@Mod(modid="gulliverreborn", name="Gulliver Reborn", version="1.10", acceptedMinecraftVersions="1.12.2", dependencies="required-after:forge@[14.23.5.2795,];required-after:artemislib@[1.0.6,];")
public class GulliverReborn {
    public static final String MODID = "gulliverreborn";
    public static final String NAME = "Gulliver Reborn";
    public static final String VERSION = "1.10";
    public static final String MCVERSION = "1.12.2";
    public static final String DEPENDENCIES = "required-after:forge@[14.23.5.2795,];required-after:artemislib@[1.0.6,];";
    public static final Logger LOGGER = LogManager.getLogger((String)"Gulliver Reborn");
    public static File config;

    public static DamageSource causeCrushingDamage(EntityLivingBase entity) {
        return new EntityDamageSource("gulliverreborn.crushing", (Entity)entity);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.registerConfig(event);
        MinecraftForge.EVENT_BUS.register((Object)new GulliverReborn());
    }

    @Mod.EventHandler
    public void serverRegistries(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new MyResizeCommand());
        event.registerServerCommand((ICommand)new OthersResizeCommand());
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (Config.SCALED_FALL_DAMAGE) {
                event.setDistance(event.getDistance() / (player.field_70131_O * 0.6f));
            }
            if (player.field_70131_O < 0.45f) {
                event.setDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = event.getEntityLiving().field_70170_p;
        for (EntityLivingBase entities : world.func_72872_a(EntityLivingBase.class, entity.func_174813_aQ())) {
            if (entity.func_70093_af() || !Config.GIANTS_CRUSH_ENTITIES || !(entity.field_70131_O / entities.field_70131_O >= 4.0f) || entities.func_184187_bx() == entity) continue;
            entities.func_70097_a(GulliverReborn.causeCrushingDamage(entity), entity.field_70131_O - entities.field_70131_O);
        }
    }

    @SubscribeEvent
    public void onTargetEntity(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityPlayer && event.getEntityLiving() instanceof EntityLiving && Config.SMALL_IS_INVISIBLE_TO_NONCATS_OR_NONSPIDERS) {
            EntityPlayer player = (EntityPlayer)event.getTarget();
            EntityLiving entity = (EntityLiving)event.getEntityLiving();
            if (!(entity instanceof EntitySpider) && !(entity instanceof EntityOcelot) && player.field_70131_O <= 0.45f) {
                entity.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = event.player.field_70170_p;
        player.field_70138_W = player.field_70131_O / 3.0f;
        player.field_70747_aH *= player.field_70131_O / 1.8f;
        if (player.field_70131_O < 0.9f) {
            BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            float ratio = player.field_70131_O / 1.8f / 2.0f;
            if (block instanceof BlockRedFlower || state == Blocks.field_150398_cm.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.ROSE) && Config.ROSES_HURT) {
                player.func_70097_a(DamageSource.field_76367_g, 1.0f);
            }
            if (!player.field_71075_bZ.field_75100_b && Config.PLANTS_SLOW_SMALL_DOWN && block instanceof BlockBush || block instanceof BlockCarpet || block instanceof BlockFlower || block instanceof BlockReed || block instanceof BlockSnow || block instanceof BlockWeb || block instanceof BlockSoulSand) {
                player.field_70159_w *= (double)ratio;
                if (block instanceof BlockWeb) {
                    player.field_70181_x *= (double)ratio;
                }
                player.field_70179_y *= (double)ratio;
            }
        }
        if (player.field_70131_O <= 0.45f) {
            EnumFacing facing = player.func_174811_aO();
            BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            IBlockState state = world.func_180495_p(pos.func_177982_a(0, 0, 0).func_177972_a(facing));
            Block block = state.func_177230_c();
            boolean canPass = block.func_176205_b((IBlockAccess)world, pos.func_177972_a(facing));
            if ((ClimbingHandler.canClimb(player, facing) && Config.CLIMB_SOME_BLOCKS && block instanceof BlockDirt || block instanceof BlockGrass || block instanceof BlockMycelium || block instanceof BlockLeaves || block instanceof BlockSand || block instanceof BlockSoulSand || block instanceof BlockConcretePowder || block instanceof BlockFarmland || block instanceof BlockGrassPath || block instanceof BlockGravel || block instanceof BlockClay) && player.field_70123_F) {
                if (!player.func_70093_af()) {
                    player.field_70181_x = 0.1;
                }
                if (player.func_70093_af()) {
                    player.field_70181_x = 0.0;
                }
            }
            for (ItemStack stack : player.func_184214_aD()) {
                if ((stack.func_77973_b() == Items.field_151123_aH || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_180399_cE) && Config.CLIMB_WITH_SLIME) && ClimbingHandler.canClimb(player, facing) && player.field_70123_F) {
                    if (!player.func_70093_af()) {
                        player.field_70181_x = 0.1;
                    }
                    if (player.func_70093_af()) {
                        player.field_70181_x = 0.0;
                    }
                }
                if (stack.func_77973_b() != Items.field_151121_aF || !Config.GLIDE_WITH_PAPER || player.field_70122_E) continue;
                player.field_70747_aH = 0.035f;
                player.field_70143_R = 0.0f;
                if (player.field_70181_x < 0.0) {
                    player.field_70181_x *= 0.6;
                }
                if (player.func_70093_af()) {
                    player.field_70747_aH *= 3.5f;
                }
                double blockY = player.field_70163_u;
                while (!player.func_70093_af() && (world.func_180495_p(new BlockPos(player.field_70165_t, blockY, player.field_70161_v)).func_177230_c() == Blocks.field_150350_a || world.func_180495_p(new BlockPos(player.field_70165_t, blockY, player.field_70161_v)).func_177230_c() == Blocks.field_150353_l || world.func_180495_p(new BlockPos(player.field_70165_t, blockY, player.field_70161_v)).func_177230_c() == Blocks.field_150480_ab || world.func_180495_p(new BlockPos(player.field_70165_t, blockY, player.field_70161_v)).func_177230_c() == Blocks.field_150470_am || world.func_180495_p(new BlockPos(player.field_70165_t, blockY, player.field_70161_v)).func_177230_c() == Blocks.field_189877_df) && player.field_70163_u - blockY < 25.0) {
                    if (world.func_180495_p(new BlockPos(player.field_70165_t, blockY, player.field_70161_v)).func_177230_c() == Blocks.field_150353_l || world.func_180495_p(new BlockPos(player.field_70165_t, blockY, player.field_70161_v)).func_177230_c() == Blocks.field_150480_ab || world.func_180495_p(new BlockPos(player.field_70165_t, blockY, player.field_70161_v)).func_177230_c() == Blocks.field_150470_am || world.func_180495_p(new BlockPos(player.field_70165_t, blockY, player.field_70161_v)).func_177230_c() == Blocks.field_189877_df && Config.HOT_BLOCKS_GIVE_LIFT) {
                        player.field_70181_x += MathHelper.func_151237_a((double)0.07, (double)Double.MIN_VALUE, (double)0.1);
                    }
                    blockY -= 1.0;
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)event.getTarget();
            EntityPlayer player = event.getEntityPlayer();
            if (target.field_70131_O / 2.0f >= player.field_70131_O && Config.RIDE_BIG_ENTITIES) {
                for (ItemStack stack : player.func_184214_aD()) {
                    if (stack.func_77973_b() != Items.field_151007_F) continue;
                    player.func_184220_m((Entity)target);
                }
            }
            if (target.field_70131_O * 2.0f <= player.field_70131_O && Config.PICKUP_SMALL_ENTITIES) {
                target.func_184220_m((Entity)player);
            }
            if (player.func_184614_ca().func_190926_b() && player.func_184207_aI() && player.func_70093_af()) {
                for (Entity entities : player.func_184188_bt()) {
                    if (!(entities instanceof EntityLivingBase)) continue;
                    entities.func_184210_p();
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && Config.JUMP_MODIFIER) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            float jumpHeight = player.field_70131_O / 1.8f;
            jumpHeight = MathHelper.func_76131_a((float)jumpHeight, (float)0.65f, (float)jumpHeight);
            player.field_70181_x *= (double)jumpHeight;
            if ((player.func_70093_af() || player.func_70051_ag()) && player.field_70131_O < 1.8f) {
                player.field_70181_x = 0.42f;
            }
        }
    }

    @SubscribeEvent
    public void onHarvest(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        if (Config.HARVEST_MODIFIER) {
            event.setNewSpeed(event.getOriginalSpeed() * (player.field_70131_O / 1.8f));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onFOVChange(FOVUpdateEvent event) {
        if (event.getEntity() != null) {
            EntityPlayer player = event.getEntity();
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            PotionEffect speed = player.func_70660_b(MobEffects.field_76424_c);
            float fov = settings.field_74334_X / settings.field_74334_X;
            if (player.func_70051_ag()) {
                event.setNewfov(speed != null ? fov + (0.1f * (float)(speed.func_76458_c() + 1) + 0.15f) : fov + 0.1f);
            } else {
                event.setNewfov(speed != null ? fov + 0.1f * (float)(speed.func_76458_c() + 1) : fov);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float scale = player.field_70131_O / 1.8f;
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1 && player.field_70131_O > 1.8f) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-scale * 2.0f));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 && player.field_70131_O > 1.8f) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(scale * 2.0f));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onEntityRenderPre(RenderLivingEvent.Pre event) {
        float scale;
        ISizeCap cap;
        EntityLivingBase entity;
        if (Config.DO_ADJUSTED_RENDER && (entity = event.getEntity()).hasCapability(SizeCapPro.sizeCapability, null) && (cap = (ISizeCap)entity.getCapability(SizeCapPro.sizeCapability, null)).getTrans() && (scale = entity.field_70131_O / cap.getDefaultHeight()) < 0.4f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)(scale * 2.5f), (float)1.0f, (float)(scale * 2.5f));
            GlStateManager.func_179137_b((double)(event.getX() / (double)scale * 2.5 - event.getX()), (double)(event.getY() / (double)scale * 2.5 - event.getY()), (double)(event.getZ() / (double)scale * 2.5 - event.getZ()));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onLivingRenderPost(RenderLivingEvent.Post event) {
        float scale;
        ISizeCap cap;
        EntityLivingBase entity;
        if (Config.DO_ADJUSTED_RENDER && (entity = event.getEntity()).hasCapability(SizeCapPro.sizeCapability, null) && (cap = (ISizeCap)entity.getCapability(SizeCapPro.sizeCapability, null)).getTrans() && (scale = entity.field_70131_O / cap.getDefaultHeight()) < 0.4f) {
            GlStateManager.func_179121_F();
        }
    }
}

