/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.entities;

import com.yyon.grapplinghook.entities.grappleArrow;
import com.yyon.grapplinghook.grapplemod;
import com.yyon.grapplinghook.vec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class magnetArrow
extends grappleArrow {
    public vec prevpos = null;
    public boolean foundblock = false;
    public boolean wasinair = false;
    public BlockPos magnetblock = null;
    public int repelconf = 0;
    public final int radius = 3;

    public magnetArrow(World worldIn) {
        super(worldIn);
    }

    public magnetArrow(World worldIn, EntityLivingBase shooter, boolean righthand) {
        super(worldIn, shooter, righthand);
    }

    public magnetArrow(World worldIn, EntityLivingBase shooter, boolean righthand, int repelconf) {
        this(worldIn, shooter, righthand);
        this.repelconf = repelconf;
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeInt(this.repelconf);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.repelconf = data.readInt();
    }

    @Override
    public float getVelocity() {
        return 20.0f;
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.shootingEntity == null) {
            return;
        }
        if (!this.foundblock && !this.field_70170_p.field_72995_K) {
            vec playerpos = vec.positionvec(this.shootingEntity);
            vec pos = vec.positionvec((Entity)this);
            if (this.magnetblock == null && this.prevpos != null) {
                HashMap<BlockPos, Boolean> checkedset = new HashMap<BlockPos, Boolean>();
                vec vector = pos.sub(this.prevpos);
                vec normvector = vector.normalize();
                int i = 0;
                while ((double)i < vector.length()) {
                    double dist = this.prevpos.sub(playerpos).length();
                    int radius = (int)dist / 4;
                    BlockPos found = this.check(this.prevpos, checkedset);
                    if (found != null) {
                        if (this.wasinair) {
                            vec distvec = new vec(found.func_177958_n(), found.func_177956_o(), found.func_177952_p());
                            distvec.sub_ip(this.prevpos);
                            if (distvec.length() < (double)radius) {
                                this.func_70634_a(this.prevpos.x, this.prevpos.y, this.prevpos.z);
                                pos = this.prevpos;
                                this.magnetblock = found;
                                break;
                            }
                        }
                    } else {
                        this.wasinair = true;
                    }
                    this.prevpos.add_ip(normvector);
                    ++i;
                }
            }
            if (this.magnetblock != null) {
                IBlockState blockstate = this.field_70170_p.func_180495_p(this.magnetblock);
                AxisAlignedBB BB = blockstate.func_185890_d((IBlockAccess)this.field_70170_p, this.magnetblock);
                vec blockvec = new vec((double)this.magnetblock.func_177958_n() + (BB.field_72336_d + BB.field_72340_a) / 2.0, (double)this.magnetblock.func_177956_o() + (BB.field_72337_e + BB.field_72338_b) / 2.0, (double)this.magnetblock.func_177952_p() + (BB.field_72334_f + BB.field_72339_c) / 2.0);
                vec newvel = blockvec.sub(pos);
                double l = newvel.length();
                newvel.changelen(this.getVelocity());
                this.field_70159_w = newvel.x;
                this.field_70181_x = newvel.y;
                this.field_70179_y = newvel.z;
                if (l < 0.2) {
                    this.serverAttach(this.magnetblock, blockvec, EnumFacing.UP);
                }
            }
            this.prevpos = pos;
        }
    }

    public BlockPos check(vec p, HashMap<BlockPos, Boolean> checkedset) {
        BlockPos closestpos = null;
        double closestdist = 0.0;
        for (int x = (int)p.x - 3; x <= (int)p.x + 3; ++x) {
            for (int y = (int)p.y - 3; y <= (int)p.y + 3; ++y) {
                for (int z = (int)p.z - 3; z <= (int)p.z + 3; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (pos == null || !this.hasblock(pos, checkedset)) continue;
                    vec distvec = new vec(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    distvec.sub_ip(p);
                    double dist = distvec.length();
                    if (closestpos != null && !(dist < closestdist)) continue;
                    closestpos = pos;
                    closestdist = dist;
                }
            }
        }
        return closestpos;
    }

    public boolean hasblock(BlockPos pos, HashMap<BlockPos, Boolean> checkedset) {
        if (!checkedset.containsKey(pos)) {
            AxisAlignedBB BB;
            boolean isblock = false;
            IBlockState blockstate = this.field_70170_p.func_180495_p(pos);
            Block b = blockstate.func_177230_c();
            if (!(!grapplemod.anyblocks && (!grapplemod.removeblocks && !grapplemod.grapplingblocks.contains(b) || grapplemod.removeblocks && grapplemod.grapplingblocks.contains(b)) || b.isAir(blockstate, (IBlockAccess)this.field_70170_p, pos) || (BB = blockstate.func_185890_d((IBlockAccess)this.field_70170_p, pos)) == null)) {
                isblock = true;
            }
            checkedset.put(pos, isblock);
            return isblock;
        }
        return checkedset.get(pos);
    }

    @Override
    protected void func_70184_a(RayTraceResult movingobjectposition) {
        super.func_70184_a(movingobjectposition);
        this.foundblock = true;
    }

    @Override
    public int getControlId() {
        return grapplemod.MAGNETID;
    }
}

