/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.handler;

import com.mojang.util.UUIDTypeAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.morph.api.IApi;
import me.ichun.mods.morph.api.MorphApi;
import me.ichun.mods.morph.api.event.MorphAcquiredEvent;
import me.ichun.mods.morph.api.event.MorphEvent;
import me.ichun.mods.morph.client.morph.MorphInfoClient;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.morph.MorphInfo;
import me.ichun.mods.morph.common.morph.MorphState;
import me.ichun.mods.morph.common.morph.MorphVariant;
import me.ichun.mods.morph.common.packet.PacketAcquireEntity;
import me.ichun.mods.morph.common.packet.PacketUpdateActiveMorphs;
import me.ichun.mods.morph.common.packet.PacketUpdateMorphList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerMorphHandler
implements IApi {
    private static final PlayerMorphHandler INSTANCE = new PlayerMorphHandler();
    public static final ArrayList<Class<? extends EntityLivingBase>> blacklistedEntityClasses = new ArrayList();
    public static final ArrayList<Class<? extends EntityLivingBase>> blackwhiteEntityClasses = new ArrayList();
    public static final ResourceLocation morphSkin = new ResourceLocation("morph", "textures/skin/morphskin.png");
    public static final String MORPH_DATA_NAME = "MorphSave";

    public static PlayerMorphHandler getInstance() {
        return INSTANCE;
    }

    public static void init() {
        MorphApi.setApiImpl(INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    @Override
    public boolean canPlayerMorph(EntityPlayer player) {
        if (Morph.config.listIsBlacklistPlayers == 0) {
            for (String s : Morph.config.blackwhiteListedPlayers) {
                if (!s.equalsIgnoreCase(player.func_70005_c_())) continue;
                return true;
            }
        } else {
            for (String s : Morph.config.blackwhiteListedPlayers) {
                if (!s.equalsIgnoreCase(player.func_70005_c_())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasMorph(String playerName, Side side) {
        return side.isClient() && Morph.eventHandlerClient.morphsActive.containsKey(playerName) || Morph.eventHandlerServer.morphsActive.containsKey(playerName);
    }

    @Override
    public float morphProgress(String playerName, Side side) {
        if (side.isClient() && Morph.eventHandlerClient.morphsActive.containsKey(playerName)) {
            return Morph.eventHandlerClient.morphsActive.get(playerName).getMorphProgress(0.0f);
        }
        if (Morph.eventHandlerServer.morphsActive.containsKey(playerName)) {
            return Morph.eventHandlerServer.morphsActive.get(playerName).getMorphProgress(0.0f);
        }
        return 1.0f;
    }

    @Override
    public float timeToCompleteMorph() {
        return Morph.config.morphTime;
    }

    @Override
    public EntityLivingBase getPrevMorphEntity(World worldInstance, String playerName, Side side) {
        MorphInfo info;
        if (side.isClient() && Morph.eventHandlerClient.morphsActive.containsKey(playerName)) {
            MorphInfo info2 = Morph.eventHandlerClient.morphsActive.get(playerName);
            if (info2 != null && info2.prevState != null) {
                return info2.prevState.getEntInstance(worldInstance);
            }
        } else if (Morph.eventHandlerServer.morphsActive.containsKey(playerName) && (info = Morph.eventHandlerServer.morphsActive.get(playerName)) != null && info.prevState != null) {
            return info.prevState.getEntInstance(worldInstance);
        }
        return null;
    }

    @Override
    public EntityLivingBase getMorphEntity(World worldInstance, String playerName, Side side) {
        MorphInfo info;
        if (side.isClient() && Morph.eventHandlerClient.morphsActive.containsKey(playerName)) {
            MorphInfo info2 = Morph.eventHandlerClient.morphsActive.get(playerName);
            if (info2 != null) {
                return info2.nextState.getEntInstance(worldInstance);
            }
        } else if (Morph.eventHandlerServer.morphsActive.containsKey(playerName) && (info = Morph.eventHandlerServer.morphsActive.get(playerName)) != null) {
            return info.nextState.getEntInstance(worldInstance);
        }
        return null;
    }

    @Override
    public boolean isEntityAMorph(EntityLivingBase entityLivingBase, Side side) {
        HashMap<String, MorphInfo> infos = side.isServer() ? Morph.eventHandlerServer.morphsActive : Morph.eventHandlerClient.morphsActive;
        Iterator<Map.Entry<String, MorphInfo>> iterator = infos.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, MorphInfo> obj;
            Map.Entry<String, MorphInfo> e = obj = iterator.next();
            if ((e.getValue().prevState == null || e.getValue().prevState.getEntInstance(entityLivingBase.func_130014_f_()) != entityLivingBase) && e.getValue().nextState.getEntInstance(entityLivingBase.func_130014_f_()) != entityLivingBase) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityMorphableConfig(EntityLivingBase entity) {
        for (Class<? extends EntityLivingBase> clz : blacklistedEntityClasses) {
            if (!clz.isInstance(entity.getClass())) continue;
            return false;
        }
        if (Morph.config.listIsBlacklistMobs == 0) {
            for (Class<? extends EntityLivingBase> clz : blackwhiteEntityClasses) {
                if (!clz.isInstance(entity.getClass())) continue;
                return true;
            }
        } else {
            for (Class<? extends EntityLivingBase> clz : blackwhiteEntityClasses) {
                if (!clz.isInstance(entity.getClass())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean forceDemorph(EntityPlayerMP player) {
        MorphInfo info = Morph.eventHandlerServer.morphsActive.get(player.func_70005_c_());
        if (info != null) {
            MorphVariant variant = new MorphVariant("PlayerMorph").setPlayer((EntityPlayer)player);
            variant.thisVariant.isFavourite = true;
            MorphInfo newInfo = new MorphInfo((EntityPlayer)player, info.nextState, new MorphState(variant));
            newInfo.morphTime = 0;
            Morph.eventHandlerServer.morphsActive.put(player.func_70005_c_(), newInfo);
            Morph.channel.sendToAll((AbstractPacket)new PacketUpdateActiveMorphs(player.func_70005_c_()));
            EntityHelper.playSoundAtEntity((Entity)player, (SoundEvent)Morph.soundMorph, (SoundCategory)player.func_184176_by(), (float)1.0f, (float)1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean forceMorph(EntityPlayerMP player, EntityLivingBase entityToMorph) {
        if (!PlayerMorphHandler.isEntityMorphableConfig(entityToMorph)) {
            return false;
        }
        MorphVariant variant = MorphVariant.createVariant(entityToMorph);
        if (variant == null) {
            return false;
        }
        return this.morphPlayer((EntityPlayer)player, variant);
    }

    @Override
    public boolean acquireMorph(EntityPlayerMP player, EntityLivingBase entityToAcquire, boolean forceMorph, boolean killEntityClientside) {
        if (Morph.config.childMorphs == 0 && entityToAcquire.func_70631_g_() || Morph.config.playerMorphs == 0 && entityToAcquire instanceof EntityPlayer || Morph.config.bossMorphs == 0 && !entityToAcquire.func_184222_aU()) {
            return false;
        }
        if (!Morph.eventHandlerServer.playerMorphs.containsKey(player.func_70005_c_()) || FakePlayer.class.isAssignableFrom(player.getClass()) || player.field_71135_a == null) {
            return false;
        }
        if (!PlayerMorphHandler.isEntityMorphableConfig(entityToAcquire)) {
            return false;
        }
        if (Morph.eventHandlerServer.morphsActive.containsKey(player.func_70005_c_()) && Morph.eventHandlerServer.morphsActive.get(player.func_70005_c_()).isMorphing()) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new MorphAcquiredEvent((EntityPlayer)player, entityToAcquire))) {
            return false;
        }
        MorphVariant variant = MorphVariant.createVariant(entityToAcquire);
        if (variant == null) {
            return false;
        }
        ArrayList<MorphVariant> morphs = Morph.eventHandlerServer.playerMorphs.get(player.func_70005_c_());
        int variantIndex = -2;
        for (MorphVariant var : morphs) {
            if (variant.entId.equals("PlayerMorph")) {
                if (!var.entId.equals("PlayerMorph") || !variant.playerName.equals(var.playerName)) continue;
                return false;
            }
            if (!variant.entId.equals(var.entId)) continue;
            variantIndex = MorphVariant.combineVariants(var, variant);
            if (variantIndex == -2) {
                return false;
            }
            variant = var.createWithVariant(variantIndex == -1 ? var.thisVariant : var.variants.get(variantIndex));
            Morph.channel.sendTo((AbstractPacket)new PacketUpdateMorphList(false, variant), (EntityPlayer)player);
            break;
        }
        if (variantIndex == -2) {
            morphs.add(variant);
            Morph.channel.sendTo((AbstractPacket)new PacketUpdateMorphList(false, variant), (EntityPlayer)player);
        }
        Collections.sort(morphs);
        if (forceMorph) {
            this.morphPlayer((EntityPlayer)player, variant);
        }
        this.savePlayerData((EntityPlayer)player);
        if (killEntityClientside) {
            Morph.channel.sendToAllAround((AbstractPacket)new PacketAcquireEntity(entityToAcquire.func_145782_y(), player.func_145782_y()), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0));
        }
        return true;
    }

    public boolean morphPlayer(EntityPlayer player, MorphVariant variant) {
        if (Morph.eventHandlerServer.morphsActive.containsKey(player.func_70005_c_()) && Morph.eventHandlerServer.morphsActive.get(player.func_70005_c_()).isMorphing()) {
            return false;
        }
        MorphInfo currentInfo = Morph.eventHandlerServer.morphsActive.get(player.func_70005_c_());
        if (currentInfo == null) {
            currentInfo = new MorphInfo(player, null, new MorphState(MorphVariant.createVariant((EntityLivingBase)player)));
        }
        MorphInfo newInfo = new MorphInfo(player, currentInfo.nextState, new MorphState(variant));
        newInfo.morphTime = 0;
        if (MinecraftForge.EVENT_BUS.post((Event)new MorphEvent(player, newInfo.prevState.getEntInstance(player.func_130014_f_()), newInfo.nextState.getEntInstance(player.func_130014_f_())))) {
            return false;
        }
        Morph.eventHandlerServer.morphsActive.put(player.func_70005_c_(), newInfo);
        Morph.channel.sendToAll((AbstractPacket)new PacketUpdateActiveMorphs(player.func_70005_c_()));
        EntityHelper.playSoundAtEntity((Entity)player, (SoundEvent)Morph.soundMorph, (SoundCategory)player.func_184176_by(), (float)1.0f, (float)1.0f);
        return true;
    }

    @Override
    public ResourceLocation getMorphSkinTexture() {
        return morphSkin;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderArm(EntityPlayer player, boolean isLeftArm) {
        AbstractClientPlayer client;
        String s;
        RenderPlayer rend;
        MorphInfoClient info = Morph.eventHandlerClient.morphsActive.get(player.func_70005_c_());
        if (info != null && player instanceof AbstractClientPlayer && (rend = (RenderPlayer)Minecraft.func_71410_x().func_175598_ae().field_178636_l.get(s = (client = (AbstractClientPlayer)player).func_175154_l())) != null) {
            Morph.eventHandlerClient.renderHandInstance.renderTick = iChunUtil.eventHandlerClient.renderTick;
            Morph.eventHandlerClient.renderHandInstance.parent = rend;
            Morph.eventHandlerClient.renderHandInstance.clientInfo = info;
            if (isLeftArm) {
                Morph.eventHandlerClient.renderHandInstance.func_177139_c((AbstractClientPlayer)player);
            } else {
                Morph.eventHandlerClient.renderHandInstance.func_177138_b((AbstractClientPlayer)player);
            }
            Morph.eventHandlerClient.renderHandInstance.clientInfo = null;
        }
    }

    @Override
    public boolean isMorphApi() {
        return true;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.loadPlayerData(event.player)) {
            Morph.channel.sendToAllExcept((AbstractPacket)new PacketUpdateActiveMorphs(event.player.func_70005_c_()), event.player);
        }
        ArrayList<MorphVariant> morphs = Morph.eventHandlerServer.getPlayerMorphs(event.player);
        Morph.channel.sendTo((AbstractPacket)new PacketUpdateActiveMorphs(null), event.player);
        Morph.channel.sendTo((AbstractPacket)new PacketUpdateMorphList(true, morphs.toArray(new MorphVariant[morphs.size()])), event.player);
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (Morph.eventHandlerServer.morphsActive.containsKey(event.player.func_70005_c_()) || Morph.eventHandlerServer.playerMorphs.containsKey(event.player.func_70005_c_())) {
            this.savePlayerData(event.player);
            Morph.eventHandlerServer.morphsActive.remove(event.player.func_70005_c_());
            Morph.eventHandlerServer.playerMorphs.remove(event.player.func_70005_c_());
        }
    }

    public static void setPlayerSize(EntityPlayer player, MorphInfo info, boolean setSize) {
        if (!info.isMorphing()) {
            EntityLivingBase morphEnt = info.nextState.getEntInstance(player.func_130014_f_());
            double morphWidth = morphEnt.field_70130_N;
            if (Math.abs(player.func_174813_aQ().field_72336_d - player.func_174813_aQ().field_72340_a - morphWidth) > 1.0E-6 || Math.abs(player.func_174813_aQ().field_72337_e - player.func_174813_aQ().field_72338_b - (double)morphEnt.field_70131_O) > 1.0E-6) {
                if (setSize) {
                    player.field_70130_N = morphEnt.field_70130_N;
                    player.field_70131_O = morphEnt.field_70131_O;
                }
                MorphInfo.setPlayerSize(player, info, (float)morphWidth, morphEnt.field_70131_O);
            }
        } else {
            EntityLivingBase prevEnt = info.prevState.getEntInstance(player.func_130014_f_());
            EntityLivingBase nextEnt = info.nextState.getEntInstance(player.func_130014_f_());
            float morphTransition = info.getMorphTransitionProgress(0.0f);
            float newWidth = EntityHelper.interpolateValues((float)prevEnt.field_70130_N, (float)nextEnt.field_70130_N, (float)morphTransition);
            float newHeight = EntityHelper.interpolateValues((float)prevEnt.field_70131_O, (float)nextEnt.field_70131_O, (float)morphTransition);
            if (Math.abs(player.func_174813_aQ().field_72336_d - player.func_174813_aQ().field_72340_a - (double)newWidth) > 1.0E-6 || Math.abs(player.func_174813_aQ().field_72337_e - player.func_174813_aQ().field_72338_b - (double)newHeight) > 1.0E-6) {
                double difference;
                if (setSize) {
                    player.field_70130_N = newWidth;
                    player.field_70131_O = newHeight;
                }
                if ((difference = player.func_174813_aQ().field_72336_d - player.func_174813_aQ().field_72340_a - (double)newWidth) > 0.0) {
                    boolean collidedHorizontally = player.field_70123_F;
                    boolean collidedVertically = player.field_70124_G;
                    boolean onGround = player.field_70122_E;
                    boolean collided = player.field_70132_H;
                    float distanceWalkedModified = player.field_70140_Q;
                    float distanceWalkedOnStepModified = player.field_82151_R;
                    player.func_70091_d(MoverType.SELF, difference, 0.0, difference);
                    player.field_70140_Q = distanceWalkedModified;
                    player.field_82151_R = distanceWalkedOnStepModified;
                    player.field_70123_F = collidedHorizontally || player.field_70123_F;
                    player.field_70124_G = collidedVertically || player.field_70124_G;
                    player.field_70122_E = onGround || player.field_70122_E;
                    player.field_70132_H = collided || player.field_70132_H;
                }
                MorphInfo.setPlayerSize(player, info, newWidth, newHeight);
            }
        }
    }

    public void savePlayerData(EntityPlayer player) {
        int i;
        NBTTagCompound tag = EntityHelper.getPlayerPersistentData((EntityPlayer)player, (String)MORPH_DATA_NAME);
        MorphInfo info = Morph.eventHandlerServer.morphsActive.get(player.func_70005_c_());
        if (info != null && !info.nextState.currentVariant.playerName.equals(player.func_70005_c_())) {
            tag.func_74782_a("currentMorph", (NBTBase)info.write(new NBTTagCompound()));
        } else {
            tag.func_82580_o("currentMorph");
        }
        int oldMorphCount = tag.func_74762_e("variantCount");
        ArrayList<MorphVariant> variants = Morph.eventHandlerServer.getPlayerMorphs(player);
        tag.func_74768_a("variantCount", variants.size());
        for (i = 0; i < variants.size(); ++i) {
            MorphVariant variant = variants.get(i);
            tag.func_74782_a("variant_" + i, (NBTBase)variant.write(new NBTTagCompound()));
        }
        if (oldMorphCount > variants.size()) {
            for (i = variants.size(); i < oldMorphCount; ++i) {
                tag.func_82580_o("variant_" + i);
            }
        }
    }

    public boolean loadPlayerData(EntityPlayer player) {
        NBTTagCompound tag = EntityHelper.getPlayerPersistentData((EntityPlayer)player, (String)MORPH_DATA_NAME);
        boolean update = false;
        if (tag.func_74764_b("currentMorph")) {
            MorphInfo info = new MorphInfo(player, null, null);
            info.read(tag.func_74775_l("currentMorph"));
            if (info.morphTime < Morph.config.morphTime) {
                info.morphTime = Morph.config.morphTime;
            }
            info.setPlayer(player);
            Morph.eventHandlerServer.morphsActive.put(player.func_70005_c_(), info);
            update = true;
        }
        int morphCount = tag.func_74762_e("variantCount");
        ArrayList<MorphVariant> variants = Morph.eventHandlerServer.getPlayerMorphs(player);
        for (int i = 0; i < morphCount; ++i) {
            MorphVariant variant = new MorphVariant("");
            variant.read(tag.func_74775_l("variant_" + i));
            boolean ignore = false;
            if (variant.entId.equals("PlayerMorph")) {
                try {
                    UUID playerUUID = UUIDTypeAdapter.fromString((String)variant.entTag.func_74779_i("UUID"));
                    variant.playerName = playerUUID.equals(player.func_146103_bH().getId()) ? player.func_146103_bH().getName() : EntityHelper.getGameProfile((UUID)playerUUID, (String)variant.playerName).getName();
                }
                catch (IllegalArgumentException ignored) {
                    ignore = true;
                }
            }
            if (variants.contains(variant) || ignore) continue;
            variants.add(variant);
        }
        return update;
    }
}

