/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.morph;

import com.google.common.collect.Ordering;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.handler.NBTHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.RandomStringUtils;

public class MorphVariant
implements Comparable<MorphVariant> {
    public static final int VARIANT_PROTOCOL = 2;
    public static final int IDENTIFIER_LENGTH = 20;
    public static final String PLAYER_MORPH_ID = "PlayerMorph";
    public String entId;
    public String playerName;
    public NBTTagCompound entTag;
    public NBTTagCompound instanceTag;
    public NBTTagCompound morphData;
    public Variant thisVariant;
    public ArrayList<Variant> variants;
    public static HashSet<String> creationBlacklist = new HashSet();

    public MorphVariant(String entId) {
        this.entId = entId;
        this.playerName = "";
        this.entTag = new NBTTagCompound();
        this.instanceTag = new NBTTagCompound();
        this.morphData = new NBTTagCompound();
        this.thisVariant = new Variant();
        this.variants = new ArrayList();
    }

    public MorphVariant setPlayer(EntityPlayer player) {
        this.playerName = player.func_70005_c_();
        this.entTag.func_74778_a("UUID", player.func_146103_bH().getId().toString());
        return this;
    }

    public EntityLivingBase createEntityInstance(World world) {
        if (this.entId.equals(PLAYER_MORPH_ID)) {
            if (!this.playerName.isEmpty()) {
                return world.field_72995_K ? this.createPlayer(world, this.playerName) : new FakePlayer((WorldServer)world, EntityHelper.getGameProfile((String)this.playerName));
            }
            this.thisVariant.invalid = true;
        } else {
            NBTTagCompound instanceCreator = this.instanceTag.func_74737_b();
            instanceCreator.field_74784_a.putAll(this.entTag.field_74784_a);
            instanceCreator.field_74784_a.putAll(this.thisVariant.variantData.field_74784_a);
            this.thisVariant.tagsToRemove.forEach(instanceCreator.field_74784_a::remove);
            Entity ent = EntityList.func_75615_a((NBTTagCompound)instanceCreator, (World)world);
            if (ent instanceof EntityLivingBase) {
                return (EntityLivingBase)ent;
            }
            this.thisVariant.invalid = true;
        }
        EntityPig pig = (EntityPig)EntityList.func_191304_a(EntityPig.class, (World)world);
        NBTTagCompound fakeTag = new NBTTagCompound();
        pig.func_70014_b(fakeTag);
        MorphVariant.clean((EntityLivingBase)pig, fakeTag);
        pig.func_70037_a(fakeTag);
        return pig;
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer createPlayer(World world, String player) {
        GameProfile gp = EntityHelper.getGameProfile((String)player);
        if (Minecraft.func_71410_x().func_147114_u().func_175102_a(gp.getId()) == null) {
            NetworkPlayerInfo info = new NetworkPlayerInfo(gp);
            info.func_178838_a(-100);
            Minecraft.func_71410_x().func_147114_u().field_147310_i.put(gp.getId(), info);
        }
        return new EntityOtherPlayerMP(world, gp);
    }

    public ArrayList<MorphVariant> split() {
        ArrayList<MorphVariant> vars = new ArrayList<MorphVariant>();
        NBTTagCompound tag = this.write(new NBTTagCompound());
        MorphVariant current = new MorphVariant(this.entId);
        current.read(tag);
        current.variants.clear();
        vars.add(current);
        for (Variant var : this.variants) {
            MorphVariant variant = new MorphVariant(this.entId);
            variant.read(tag);
            variant.variants.clear();
            variant.thisVariant = var;
            vars.add(variant);
        }
        return vars;
    }

    public MorphVariant createWithVariant(Variant var) {
        NBTTagCompound tag = this.write(new NBTTagCompound());
        MorphVariant variant = new MorphVariant(this.entId);
        variant.read(tag);
        variant.variants.clear();
        variant.thisVariant = var;
        return variant;
    }

    public void read(NBTTagCompound tag) {
        int varProtocol = tag.func_74762_e("varProtocol");
        this.entId = tag.func_74779_i("entId");
        this.playerName = tag.func_74779_i("playerName");
        this.entTag = tag.func_74775_l("entTag");
        this.instanceTag = tag.func_74775_l("instanceTag");
        this.morphData = tag.func_74775_l("morphData");
        this.thisVariant.read(tag.func_74775_l("thisVariant"));
        int variantSize = tag.func_74762_e("variantCount");
        for (int i = 0; i < variantSize; ++i) {
            Variant variant = new Variant();
            variant.read(tag.func_74775_l("variant_" + i));
            if (variant.identifier.isEmpty() || variant.invalid) continue;
            this.variants.add(variant);
        }
        this.repair(varProtocol);
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        tag.func_74768_a("varProtocol", 2);
        tag.func_74778_a("entId", this.entId);
        tag.func_74778_a("playerName", this.playerName);
        tag.func_74782_a("entTag", (NBTBase)this.entTag);
        tag.func_74782_a("instanceTag", (NBTBase)this.instanceTag);
        tag.func_74782_a("morphData", (NBTBase)this.morphData);
        NBTTagCompound thisVarTag = new NBTTagCompound();
        this.thisVariant.write(thisVarTag);
        tag.func_74782_a("thisVariant", (NBTBase)thisVarTag);
        tag.func_74768_a("variantCount", this.variants.size());
        for (int i = 0; i < this.variants.size(); ++i) {
            Variant variant = this.variants.get(i);
            NBTTagCompound varTag = new NBTTagCompound();
            variant.write(varTag);
            tag.func_74782_a("variant_" + i, (NBTBase)varTag);
        }
        return tag;
    }

    public void repair(int varProtocol) {
        if (varProtocol <= 1 && this.entTag.func_74764_b("CanPickUpLoot")) {
            this.entTag.func_74757_a("CanPickUpLoot", false);
        }
    }

    public Variant getVariantByIdentifier(String ident) {
        if (this.thisVariant.identifier.equals(ident)) {
            return this.thisVariant;
        }
        for (Variant variant : this.variants) {
            if (!variant.identifier.equals(ident)) continue;
            return variant;
        }
        return null;
    }

    public boolean deleteVariant(Variant var) {
        if (var.identifier.equals(this.thisVariant.identifier)) {
            if (this.variants.isEmpty()) {
                return true;
            }
            this.thisVariant = this.variants.get(0);
            this.variants.remove(0);
            return false;
        }
        for (int i = this.variants.size() - 1; i >= 0; --i) {
            Variant var1 = this.variants.get(i);
            if (!var.identifier.equals(var1.identifier)) continue;
            this.variants.remove(i);
            break;
        }
        return false;
    }

    public NBTTagCompound getVariantTag() {
        NBTTagCompound tag = this.entTag.func_74737_b();
        tag.field_74784_a.putAll(this.thisVariant.variantData.field_74784_a);
        this.thisVariant.tagsToRemove.forEach(tag.field_74784_a::remove);
        return tag;
    }

    public static MorphVariant createVariant(EntityLivingBase living) {
        if (living instanceof EntityPlayer) {
            return new MorphVariant(PLAYER_MORPH_ID).setPlayer((EntityPlayer)living);
        }
        try {
            NBTTagCompound saveData = new NBTTagCompound();
            if (living instanceof EntityHorse) {
                EntityHorse horse = (EntityHorse)living;
                horse.func_110235_q((horse.func_110202_bQ() & 0xFF) % 7);
            }
            if (!living.func_70039_c(saveData)) {
                return null;
            }
            MorphVariant variant = new MorphVariant(saveData.func_74779_i("id"));
            variant.instanceTag = saveData;
            MorphVariant.clean(living, variant.instanceTag);
            living.func_70014_b(variant.entTag);
            MorphVariant.clean(living, variant.entTag);
            variant.entTag.func_74780_a("Morph_HealthBalancing", MathHelper.func_151237_a((double)living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e(), (double)1.0, (double)Morph.config.maxMorphHealth));
            if (variant.instanceTag.field_74784_a.containsKey("ForgeData")) {
                variant.entTag.field_74784_a.put("ForgeData", variant.instanceTag.field_74784_a.get("ForgeData"));
            }
            if (living.func_145818_k_() && living.func_95999_t().length() > 0) {
                variant.entTag.func_74778_a("CustomName", living.func_95999_t());
                variant.entTag.func_74757_a("CustomNameVisible", living.func_174833_aM());
            }
            variant.instanceTag.func_82580_o("ForgeData");
            variant.instanceTag.func_82580_o("CustomName");
            variant.instanceTag.func_82580_o("CustomNameVisible");
            return variant;
        }
        catch (ReportedException e) {
            if (!creationBlacklist.contains(living.getClass().getName())) {
                creationBlacklist.add(living.getClass().getName());
                Morph.LOGGER.warn((Object)("Error creating Morph variant for " + living.getClass().getName()));
                e.printStackTrace();
            }
            return null;
        }
    }

    public static void clean(EntityLivingBase living, NBTTagCompound tag) {
        NBTHandler.modifyNBT(living.getClass(), tag);
        tag.func_74776_a("HealF", 32767.0f);
        tag.func_74777_a("Health", (short)Short.MAX_VALUE);
        tag.func_74768_a("Age", living.func_70631_g_() ? -24000 : 0);
        if (living instanceof EntityLiving) {
            tag.func_74757_a("CanPickUpLoot", false);
            tag.func_74757_a("PersistenceRequired", true);
            tag.func_74757_a("NoAI", true);
        }
        tag.field_74784_a.entrySet().removeIf(e -> ((NBTBase)e.getValue()).func_82582_d());
    }

    public boolean equals(Object o) {
        if (o instanceof MorphVariant) {
            MorphVariant var = (MorphVariant)o;
            if (this.entId.equals(PLAYER_MORPH_ID)) {
                return PLAYER_MORPH_ID.equals(var.entId) && this.playerName.equals(var.playerName);
            }
            return this.entId.equals(var.entId) && this.playerName.equals(var.playerName) && this.entTag.equals((Object)var.entTag) && this.thisVariant.identifier.equals(var.thisVariant.identifier);
        }
        return false;
    }

    public static int combineVariants(MorphVariant source, MorphVariant variantToMerge) {
        String key;
        Map.Entry e;
        if (source.entId.equals(PLAYER_MORPH_ID) || variantToMerge.entId.equals(PLAYER_MORPH_ID) || !source.entId.equals(variantToMerge.entId)) {
            return -2;
        }
        NBTTagCompound tagCopy = source.entTag.func_74737_b();
        double sourceHealth = tagCopy.func_74769_h("Morph_HealthBalancing");
        double variantHealth = variantToMerge.entTag.func_74769_h("Morph_HealthBalancing");
        tagCopy.func_82580_o("Morph_HealthBalancing");
        variantToMerge.entTag.func_82580_o("Morph_HealthBalancing");
        if (tagCopy.equals((Object)variantToMerge.entTag)) {
            if (variantHealth > sourceHealth) {
                source.entTag.func_74780_a("Morph_HealthBalancing", variantHealth);
                for (Variant variant : source.variants) {
                    if (variant.variantData.func_74769_h("Morph_HealthBalancing") == variantHealth) {
                        variant.variantData.func_82580_o("Morph_HealthBalancing");
                        continue;
                    }
                    if (variant.variantData.func_74764_b("Morph_HealthBalancing")) continue;
                    variant.variantData.func_74780_a("Morph_HealthBalancing", sourceHealth);
                }
                source.thisVariant.isFavourite = variantToMerge.thisVariant.isFavourite;
                return -1;
            }
            return -2;
        }
        ArrayList<Variant> variants1 = source.variants;
        for (int i = 0; i < variants1.size(); ++i) {
            Variant variant = variants1.get(i);
            NBTTagCompound tagCopyCopy = tagCopy.func_74737_b();
            tagCopyCopy.field_74784_a.putAll(variant.variantData.field_74784_a);
            variant.tagsToRemove.forEach(tagCopyCopy.field_74784_a::remove);
            sourceHealth = tagCopyCopy.func_74769_h("Morph_HealthBalancing");
            tagCopyCopy.func_82580_o("Morph_HealthBalancing");
            if (!tagCopyCopy.equals((Object)variantToMerge.entTag)) continue;
            if (variantHealth > sourceHealth && sourceHealth > 0.0) {
                variant.variantData.func_74780_a("Morph_HealthBalancing", variantHealth);
                variant.isFavourite = variantToMerge.thisVariant.isFavourite;
                return i;
            }
            return -2;
        }
        variantToMerge.entTag.func_74780_a("Morph_HealthBalancing", variantHealth);
        Variant variant = new Variant();
        for (Map.Entry obj : source.entTag.field_74784_a.entrySet()) {
            e = obj;
            key = (String)e.getKey();
            if (variantToMerge.entTag.field_74784_a.containsKey(key)) continue;
            variant.tagsToRemove.add(key);
        }
        for (Map.Entry obj : variantToMerge.entTag.field_74784_a.entrySet()) {
            e = obj;
            key = (String)e.getKey();
            if (source.entTag.field_74784_a.containsKey(key) && ((NBTBase)source.entTag.field_74784_a.get(key)).equals(e.getValue())) continue;
            variant.variantData.field_74784_a.put(key, e.getValue());
        }
        variant.isFavourite = variantToMerge.thisVariant.isFavourite;
        source.variants.add(variant);
        return source.variants.size() - 1;
    }

    public String toString() {
        return this.entId + "_" + this.playerName + "_" + this.thisVariant.identifier + "_" + this.entTag.toString();
    }

    @Override
    public int compareTo(MorphVariant var) {
        if (this.entId.equals(PLAYER_MORPH_ID) && var.entId.equals(PLAYER_MORPH_ID)) {
            return this.playerName.compareTo(var.playerName);
        }
        if (this.entId.equals(var.entId)) {
            TreeMap map = new TreeMap(Ordering.natural());
            TreeMap varmap = new TreeMap(Ordering.natural());
            NBTTagCompound tag = this.getVariantTag();
            NBTTagCompound vartag = var.getVariantTag();
            map.putAll(tag.field_74784_a);
            varmap.putAll(vartag.field_74784_a);
            map.remove("Morph_HealthBalancing");
            varmap.remove("Morph_HealthBalancing");
            if (map.size() == varmap.size()) {
                Iterator ite = map.entrySet().iterator();
                Iterator varite = varmap.entrySet().iterator();
                while (ite.hasNext()) {
                    Map.Entry e = ite.next();
                    Map.Entry vare = varite.next();
                    if (((String)e.getKey()).equals(vare.getKey())) {
                        if (((NBTBase)e.getValue()).toString().equals(((NBTBase)vare.getValue()).toString())) continue;
                        return ((NBTBase)e.getValue()).toString().compareTo(((NBTBase)vare.getValue()).toString());
                    }
                    return ((String)e.getKey()).compareTo((String)vare.getKey());
                }
            }
            return Integer.compare(map.size(), varmap.size());
        }
        return this.entId.compareTo(var.entId);
    }

    public static class Variant {
        public String identifier = RandomStringUtils.randomAscii((int)20);
        public NBTTagCompound variantData = new NBTTagCompound();
        public ArrayList<String> tagsToRemove = new ArrayList();
        public boolean isFavourite = false;
        public boolean invalid = false;

        public void read(NBTTagCompound tag) {
            this.identifier = tag.func_74779_i("ident");
            this.variantData = tag.func_74775_l("entData");
            int tagsToRemoveSize = tag.func_74762_e("tagsToRemove");
            for (int i = 0; i < tagsToRemoveSize; ++i) {
                this.tagsToRemove.add(tag.func_74779_i("tagToRemove_" + i));
            }
            this.isFavourite = tag.func_74767_n("isFavourite");
            this.invalid = tag.func_74767_n("invalid");
        }

        public void write(NBTTagCompound tag) {
            tag.func_74778_a("ident", this.identifier);
            tag.func_74782_a("entData", (NBTBase)this.variantData);
            tag.func_74768_a("tagsToRemove", this.tagsToRemove.size());
            for (int i = 0; i < this.tagsToRemove.size(); ++i) {
                tag.func_74778_a("tagToRemove_" + i, this.tagsToRemove.get(i));
            }
            tag.func_74757_a("isFavourite", this.isFavourite);
            tag.func_74757_a("invalid", this.invalid);
        }
    }
}

