/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.thread;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.ichun.mods.ichunutil.common.core.util.ResourceHelper;
import me.ichun.mods.morph.api.ability.Ability;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.handler.AbilityHandler;
import me.ichun.mods.morph.common.handler.NBTHandler;
import net.minecraft.entity.EntityLivingBase;

public class ThreadGetResources
extends Thread {
    public String sitePrefix = "https://raw.github.com/iChun/Morph/1.12.2/src/main/resources/assets/morph/mod/";

    public ThreadGetResources(String prefix) {
        if (!prefix.isEmpty()) {
            this.sitePrefix = prefix;
        }
        this.setName("Morph Resource Thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        HashMap json = (HashMap)this.getResource("nbt_modifiers.json", new TypeToken<HashMap<String, HashMap<String, String>>>(){}.getType());
        int mcNBTModifiers = 0;
        NBTHandler.nbtModifiers.clear();
        for (Map.Entry e : json.entrySet()) {
            try {
                if (((String)e.getKey()).startsWith("example.class.")) continue;
                Class<?> clz = Class.forName((String)e.getKey());
                NBTHandler.TagModifier tagModifier = new NBTHandler.TagModifier();
                HashMap map = (HashMap)e.getValue();
                for (Map.Entry modifier : map.entrySet()) {
                    String value = (String)modifier.getValue();
                    NBTHandler.handleModifier(tagModifier, (String)modifier.getKey(), value);
                }
                if (tagModifier.modifiers.isEmpty() || !EntityLivingBase.class.isAssignableFrom(clz)) continue;
                NBTHandler.nbtModifiers.put(clz, tagModifier);
                if (clz.getName().startsWith("net.minecraft")) {
                    ++mcNBTModifiers;
                    continue;
                }
                Morph.LOGGER.info((Object)("Adding NBT modifiers for morphs for class: " + clz.getName()));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (mcNBTModifiers > 0) {
            Morph.LOGGER.info((Object)("Loaded NBT modifiers for presumably " + mcNBTModifiers + " Minecraft mobs"));
        } else {
            Morph.LOGGER.warn((Object)"No NBT modifiers for Minecraft mobs? This might be an issue!");
        }
        HashMap abilitiesJson = (HashMap)this.getResource("ability_support.json", new TypeToken<HashMap<String, String[]>>(){}.getType());
        int mcMappings = 0;
        for (Map.Entry e : abilitiesJson.entrySet()) {
            try {
                Class<?> entityClass;
                Class.forName((String)e.getKey());
                ArrayList<Ability> abilities = new ArrayList<Ability>();
                for (String ability : (String[])e.getValue()) {
                    boolean hasArgs;
                    block27: {
                        hasArgs = false;
                        if (ability == null) continue;
                        if (ability.contains("|")) {
                            ArrayList<String> argVars = new ArrayList<String>();
                            hasArgs = true;
                            String args = ability.split("\\|")[1];
                            ability = ability.split("\\|")[0];
                            if (args.contains(",")) {
                                for (String arg : args.split(",")) {
                                    argVars.add(arg.trim());
                                }
                            } else {
                                argVars.add(args.trim());
                            }
                            try {
                                AbilityHandler.getInstance();
                                Class<? extends Ability> abilityClass = AbilityHandler.STRING_TO_CLASS_MAP.get(ability);
                                if (abilityClass != null) {
                                    Ability ab = abilityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                                    try {
                                        ab.parse(argVars.toArray(new String[0]));
                                    }
                                    catch (Exception e2) {
                                        Morph.LOGGER.warn((Object)("Mappings are erroring! These mappings are probably invalid or outdated: " + abilityClass.getName() + ", " + ability + ", args: " + args));
                                    }
                                    abilities.add(ab);
                                    break block27;
                                }
                                Morph.LOGGER.warn((Object)("Ability \"" + ability + "\" does not exist for: " + (String)e.getKey() + ", args: " + args));
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    if (ability.isEmpty() || hasArgs) continue;
                    AbilityHandler.getInstance();
                    Class<? extends Ability> abilityClass = AbilityHandler.STRING_TO_CLASS_MAP.get(ability);
                    if (abilityClass != null) {
                        try {
                            abilities.add(abilityClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        continue;
                    }
                    Morph.LOGGER.warn((Object)("Ability \"" + ability + "\" does not exist for: " + (String)e.getKey()));
                }
                if (abilities.size() <= 0 || (entityClass = Class.forName((String)e.getKey())) == null) continue;
                AbilityHandler.getInstance();
                if (AbilityHandler.ABILITY_MAP.containsKey(entityClass)) {
                    Morph.LOGGER.warn((Object)("Ignoring ability mapping for " + (String)e.getKey() + "! Already has abilities mapped!"));
                    continue;
                }
                if (entityClass.getName().startsWith("net.minecraft")) {
                    ++mcMappings;
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Adding ability mappings ");
                    for (int i = 0; i < abilities.size(); ++i) {
                        Ability a = (Ability)abilities.get(i);
                        sb.append(a.getType());
                        if (i == abilities.size() - 1) continue;
                        sb.append(", ");
                    }
                    sb.append(" to ");
                    sb.append(entityClass);
                    Morph.LOGGER.info((Object)sb.toString());
                }
                AbilityHandler.getInstance().mapAbilities(entityClass, abilities.toArray(new Ability[0]));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        Morph.LOGGER.info((Object)("Found and mapped ability mappings for " + mcMappings + " presumably Minecraft mobs."));
    }

    public <T> T getResource(String name, Type mapType) {
        Object objectType;
        Gson gson = new Gson();
        try {
            if (Morph.config.useLocalResources == 1) {
                FileInputStream con = new FileInputStream(new File(ResourceHelper.getConfigFolder(), name));
                String data = new String(ByteStreams.toByteArray((InputStream)con));
                ((InputStream)con).close();
                objectType = gson.fromJson(data, mapType);
            } else {
                InputStreamReader fileIn = new InputStreamReader(new URL(this.sitePrefix + name).openStream());
                objectType = gson.fromJson((Reader)fileIn, mapType);
                ((Reader)fileIn).close();
            }
        }
        catch (Throwable e) {
            if (Morph.config.useLocalResources == 1) {
                Morph.LOGGER.warn((Object)("Failed to retrieve local resource: " + name));
            } else {
                Morph.LOGGER.warn((Object)("Failed to retrieve " + name + " from " + (Morph.config.customPatchLink.isEmpty() ? "GitHub!" : this.sitePrefix)));
            }
            e.printStackTrace();
            InputStreamReader fileIn = new InputStreamReader(Morph.class.getResourceAsStream("/assets/morph/mod/" + name));
            objectType = gson.fromJson((Reader)fileIn, mapType);
            try {
                ((Reader)fileIn).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return (T)objectType;
    }
}

