/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.mob;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;

public class ModelBipedCustom
extends ModelBiped {
    protected WavefrontObject model;
    protected List<GroupObject> parts;
    protected Map<String, float[]> partCenters = new HashMap<String, float[]>();
    public ModelRenderer LEFT_ARM;
    public ModelRenderer RIGHT_ARM;
    public ModelRenderer LEFT_LEG;
    public ModelRenderer RIGHT_LEG;
    public ModelRenderer HEAD;
    public ModelRenderer BODY;

    public ModelBipedCustom(WavefrontObject model) {
        this.model = model;
        this.parts = model.groupObjects;
        this.LEFT_ARM = this.field_78113_g;
        this.RIGHT_ARM = this.field_78112_f;
        this.LEFT_LEG = this.field_78124_i;
        this.RIGHT_LEG = this.field_78123_h;
        this.HEAD = this.field_78116_c;
        this.BODY = this.field_78115_e;
    }

    public void setPartCenter(String partName, float x, float y, float z) {
        this.partCenters.put(partName.toLowerCase(), new float[]{x, y, z});
    }

    public float[] getPartCenter(String partName) {
        float[] center = this.partCenters.get(partName.toLowerCase());
        if (center == null) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return center;
    }

    protected void applyModelRendererTransform(ModelRenderer renderer) {
        if (renderer == null) {
            return;
        }
        GL11.glTranslatef((float)(renderer.field_78800_c / 16.0f), (float)(renderer.field_78797_d / 16.0f), (float)(renderer.field_78798_e / 16.0f));
        if (renderer.field_78808_h != 0.0f) {
            GL11.glRotatef((float)((float)Math.toDegrees(renderer.field_78808_h)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (renderer.field_78796_g != 0.0f) {
            GL11.glRotatef((float)((float)Math.toDegrees(renderer.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (renderer.field_78795_f != 0.0f) {
            GL11.glRotatef((float)((float)Math.toDegrees(renderer.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)(-renderer.field_78800_c / 16.0f), (float)(-renderer.field_78797_d / 16.0f), (float)(-renderer.field_78798_e / 16.0f));
    }

    protected ModelRenderer getModelRendererByName(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.toLowerCase()).contains("head")) {
            return this.HEAD;
        }
        if (name.contains("armright") || name.contains("rightarm") || name.equals("right_arm")) {
            return this.RIGHT_ARM;
        }
        if (name.contains("armleft") || name.contains("leftarm") || name.equals("left_arm")) {
            return this.LEFT_ARM;
        }
        if (name.contains("legright") || name.contains("rightleg") || name.equals("right_leg")) {
            return this.RIGHT_LEG;
        }
        if (name.contains("legleft") || name.contains("leftleg") || name.equals("left_leg")) {
            return this.LEFT_LEG;
        }
        if (name.contains("body") || name.contains("torso")) {
            return this.BODY;
        }
        return null;
    }

    public void func_78088_a(Entity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        this.func_78087_a(time, distance, loop, lookY, lookX, scale, entity);
        for (GroupObject part : this.parts) {
            ModelRenderer renderer;
            if (part.name == null || (renderer = this.getModelRendererByName(part.name)) == null) continue;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            this.applyModelRendererTransform(renderer);
            float[] center = this.getPartCenter(part.name);
            GL11.glTranslatef((float)center[0], (float)center[1], (float)center[2]);
            part.render();
            GL11.glPopMatrix();
        }
    }

    public void rotate(float rotX, float rotY, float rotZ) {
        GL11.glRotatef((float)rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotY, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public void rotate(float rotation, float angleX, float angleY, float angleZ) {
        GL11.glRotatef((float)rotation, (float)angleX, (float)angleY, (float)angleZ);
    }

    public void func_78087_a(float time, float distance, float loop, float lookY, float lookX, float scale, Entity entity) {
        super.func_78087_a(time, distance, loop, lookY, lookX, scale, entity);
    }
}

