/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.events;

import com.DarknessCrow.events.ItemRenderConfig;
import com.DarknessCrow.items.CrowItem;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class ChainRenderer {
    private static final ResourceLocation CHAIN_TEXTURE = new ResourceLocation("crow:textures/particles/black_chain.png");
    private static final ResourceLocation SPHERE_TEXTURE = new ResourceLocation("crow:textures/particles/chainSphere.png");
    private final Random rand = new Random();
    private final double MAX_DIST = 6.0;
    private final double SEGMENT_LENGTH = 0.5;

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        this.renderChainsWorld(event.partialTicks);
    }

    private void renderChainsWorld(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71451_h == null) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack held = player.func_70694_bm();
        if (held == null || !(held.func_77973_b() instanceof CrowItem)) {
            return;
        }
        String itemName = held.func_77977_a();
        ItemRenderConfig.Transform transform = ItemRenderConfig.getTransformForItemName(itemName);
        if (transform == null) {
            return;
        }
        if (!"blackChains".equalsIgnoreCase(transform.eff)) {
            return;
        }
        double renderPosX = RenderManager.field_78727_a.field_78730_l;
        double renderPosY = RenderManager.field_78727_a.field_78731_m;
        double renderPosZ = RenderManager.field_78727_a.field_78728_n;
        double originX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double originY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks + (double)player.func_70047_e() * 0.5;
        double originZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        double ax = originX - renderPosX;
        double ay = (originY += 2.0) - renderPosY;
        double az = originZ - renderPosZ;
        GL11.glPushMatrix();
        GL11.glEnable((int)3553);
        mc.func_110434_K().func_110577_a(CHAIN_TEXTURE);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        Tessellator t = Tessellator.field_78398_a;
        List list = mc.field_71441_e.field_72996_f;
        for (Entity e : list) {
            double bzWorld;
            double dzw;
            double byWorld;
            double dyw;
            double bxWorld;
            double dxw;
            double dist;
            if (!(e instanceof EntityLivingBase) || e == player || (dist = Math.sqrt((dxw = (bxWorld = e.field_70169_q + (e.field_70165_t - e.field_70169_q) * (double)partialTicks) - originX) * dxw + (dyw = (byWorld = e.field_70167_r + (e.field_70163_u - e.field_70167_r) * (double)partialTicks + (double)e.field_70131_O * 0.5) - originY) * dyw + (dzw = (bzWorld = e.field_70166_s + (e.field_70161_v - e.field_70166_s) * (double)partialTicks) - originZ) * dzw)) > 6.0) continue;
            double bx = bxWorld - renderPosX;
            double by = byWorld - renderPosY;
            double bz = bzWorld - renderPosZ;
            int segments = Math.max(1, (int)(dist / 0.5));
            for (int i = 0; i < segments; ++i) {
                double t0 = (double)i / (double)segments;
                double t1 = (double)(i + 1) / (double)segments;
                double sx0 = ax + (bx - ax) * t0;
                double sy0 = ay + (by - ay) * t0;
                double sz0 = az + (bz - az) * t0;
                double sx1 = ax + (bx - ax) * t1;
                double sy1 = ay + (by - ay) * t1;
                double sz1 = az + (bz - az) * t1;
                this.drawCrossChain(t, sx0, sy0, sz0, sx1, sy1, sz1, 0.2, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
        this.renderSphere(mc, ax, ay, az, 1.0f);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private void drawCrossChain(Tessellator t, double ax, double ay, double az, double bx, double by, double bz, double thickness, float u1, float v1, float u2, float v2) {
        double dx = bx - ax;
        double dy = by - ay;
        double dz = bz - az;
        double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (len < 1.0E-4) {
            return;
        }
        double px = -dz / len * thickness;
        double py = 0.0;
        double pz = dx / len * thickness;
        double px2 = 0.0;
        double py2 = thickness;
        double pz2 = 0.0;
        t.func_78382_b();
        t.func_78369_a(0.0f, 0.0f, 0.0f, 0.9f);
        t.func_78374_a(ax - px, ay - py, az - pz, (double)u1, (double)v1);
        t.func_78374_a(bx - px, by - py, bz - pz, (double)u1, (double)v2);
        t.func_78374_a(bx + px, by + py, bz + pz, (double)u2, (double)v2);
        t.func_78374_a(ax + px, ay + py, az + pz, (double)u2, (double)v1);
        t.func_78381_a();
        t.func_78382_b();
        t.func_78369_a(0.0f, 0.0f, 0.0f, 0.9f);
        t.func_78374_a(ax - px2, ay - py2, az - pz2, (double)u1, (double)v1);
        t.func_78374_a(bx - px2, by - py2, bz - pz2, (double)u1, (double)v2);
        t.func_78374_a(bx + px2, by + py2, bz + pz2, (double)u2, (double)v2);
        t.func_78374_a(ax + px2, ay + py2, az + pz2, (double)u2, (double)v1);
        t.func_78381_a();
    }

    private void renderSphere(Minecraft mc, double x, double y, double z, float size) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)(-mc.field_71451_h.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)mc.field_71451_h.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        mc.func_110434_K().func_110577_a(SPHERE_TEXTURE);
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78369_a(1.0f, 1.0f, 1.0f, 0.9f);
        t.func_78374_a((double)(-size), (double)(-size), 0.0, 0.0, 0.0);
        t.func_78374_a((double)size, (double)(-size), 0.0, 1.0, 0.0);
        t.func_78374_a((double)size, (double)size, 0.0, 1.0, 1.0);
        t.func_78374_a((double)(-size), (double)size, 0.0, 0.0, 1.0);
        t.func_78381_a();
        GL11.glPopMatrix();
    }
}

