/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.events;

import com.DarknessCrow.items.CrowItem;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

public class ScytheReaping {
    public static float offsetX = 0.4f;
    public static float offsetY = 0.7f;
    public static float offsetZ = -0.5f;
    private static final ResourceLocation SOUL_TEXTURE = new ResourceLocation("crow:textures/particles/soul.png");
    private static final int MAX_SOULS_RENDER = 30;
    private static final int TOTAL_FRAMES = 4;
    private static final int FRAME_SIZE = 64;
    private static final int TEXTURE_HEIGHT = 256;

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Specials.Post event) {
        this.renderSoulsForPlayer(event.entityPlayer, event.renderer.field_77109_a, event.partialRenderTick, true);
    }

    private void renderSoulsForPlayer(EntityPlayer player, ModelBiped model, float partialTicks, boolean useModelTransform) {
        NBTTagCompound tag;
        ItemStack held = player.func_70694_bm();
        if (held == null || !(held.func_77973_b() instanceof CrowItem)) {
            return;
        }
        int souls = 0;
        if (held.func_77942_o() && (tag = held.func_77978_p()).func_74764_b("souls")) {
            souls = tag.func_74762_e("souls");
        }
        if (souls <= 0) {
            return;
        }
        if (souls > 30) {
            souls = 30;
        }
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        mc.func_110434_K().func_110577_a(SOUL_TEXTURE);
        double time = (float)mc.field_71439_g.field_70173_aa + partialTicks;
        for (int i = 0; i < souls; ++i) {
            this.renderSingleSoul(player, i, souls, time, mc);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void renderSingleSoul(EntityPlayer player, int index, int total, double time, Minecraft mc) {
        Tessellator tess = Tessellator.field_78398_a;
        long seed = (long)player.func_145782_y() * 1337L + (long)index * 997L;
        Random r = new Random(seed);
        double baseAngle = r.nextDouble() * Math.PI * 2.0;
        double baseRadius = 0.2 + r.nextDouble() * 0.6;
        double baseHeight = -0.2 + r.nextDouble() * 1.2;
        double wobbleX = (r.nextDouble() - 0.5) * 0.15;
        double wobbleZ = (r.nextDouble() - 0.5) * 0.15;
        double speed = 0.03 + (double)(index % 3) * 0.01 + r.nextDouble() * 0.02;
        double angle = baseAngle + time * speed;
        double px = Math.cos(angle) * baseRadius + wobbleX * Math.sin(time * 0.1 * (double)(index + 1));
        double pz = Math.sin(angle) * baseRadius + wobbleZ * Math.cos(time * 0.11 * (double)(index + 1));
        double py = baseHeight + Math.sin(time * 0.05 + (double)index) * 0.03;
        float size = 0.25f + (float)(r.nextDouble() * (double)0.1f);
        int frame = (int)((time / 8.0 * 10.0 + (double)index) % 4.0);
        float vMin = (float)frame * 64.0f / 256.0f;
        float vMax = vMin + 0.25f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)px), (float)((float)py), (float)((float)pz));
        GL11.glRotatef((float)(180.0f - RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)((float)((time * 5.0 + (double)(index * 13)) % 360.0)), (float)0.0f, (float)0.0f, (float)1.0f);
        float half = size / 2.0f;
        tess.func_78382_b();
        tess.func_78369_a(1.0f, 1.0f, 1.0f, 0.9f);
        tess.func_78374_a((double)(-half), (double)(-half), 0.0, 0.0, (double)vMax);
        tess.func_78374_a((double)half, (double)(-half), 0.0, 1.0, (double)vMax);
        tess.func_78374_a((double)half, (double)half, 0.0, 1.0, (double)vMin);
        tess.func_78374_a((double)(-half), (double)half, 0.0, 0.0, (double)vMin);
        tess.func_78381_a();
        GL11.glPopMatrix();
    }
}

