/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.mob.MannyCalavera;

import com.DarknessCrow.mob.AssetManager;
import com.DarknessCrow.mob.ModelCustomObj;
import com.DarknessCrow.mob.anim.AnimationData;
import com.DarknessCrow.mob.anim.AnimationLoader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.model.obj.WavefrontObject;

public class MannyCalavera
extends ModelCustomObj {
    private final AnimationData animIdle;
    private final AnimationData animWalk;
    private final AnimationData[] comboAttacks;
    private final Map<Integer, EntityAnimState> animStates = new HashMap<Integer, EntityAnimState>();
    private final int BLEND_DURATION = 5;

    public MannyCalavera(float shadowSize) {
        this.model = (WavefrontObject)AssetManager.getObjModel("MannyCalavera", "crow:outros/models/mob/MannyCalavera.obj");
        this.parts = this.model.groupObjects;
        this.setPartCenter("head", 0.0f, 1.97052f, 0.025085f);
        this.setPartCenter("armleft", 0.384745f, 1.46319f, -0.08756f);
        this.setPartCenter("armright", -0.384745f, 1.46319f, -0.08756f);
        this.setPartCenter("legleft", 0.152969f, 0.615914f, 0.007726f);
        this.setPartCenter("legright", -0.152969f, 0.615914f, 0.007726f);
        this.animIdle = AnimationLoader.load("crow:outros/animations/MannyCalavera_idle.json");
        this.animWalk = AnimationLoader.load("crow:outros/animations/MannyCalavera_walk.json");
        this.comboAttacks = new AnimationData[]{AnimationLoader.load("crow:outros/animations/MannyCalavera_attack1.json"), AnimationLoader.load("crow:outros/animations/MannyCalavera_attack2.json"), AnimationLoader.load("crow:outros/animations/MannyCalavera_attack3.json")};
        int[] cooldowns = new int[]{10, 15, 20};
        for (EntityAnimState st : this.animStates.values()) {
            st.comboCooldowns = cooldowns;
        }
    }

    private EntityAnimState getAnimState(Entity entity) {
        return this.animStates.computeIfAbsent(entity.func_145782_y(), id -> {
            EntityAnimState st = new EntityAnimState();
            st.currentAnim = this.animIdle;
            st.prevAnim = this.animIdle;
            st.comboCooldowns = new int[]{10, 15, 20};
            return st;
        });
    }

    private int getAnimationDuration(AnimationData anim) {
        int duration = 0;
        for (AnimationData.Frame f : anim.Frames) {
            duration += f.Duration;
        }
        return duration;
    }

    @Override
    public void animatePart(String partName, Entity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        AnimationData targetAnim;
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        if (!(entity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase living = (EntityLivingBase)entity;
        EntityAnimState state = this.getAnimState(entity);
        if (state.comboCooldown > 0) {
            --state.comboCooldown;
        }
        if (living.field_82175_bq) {
            if (state.attackTimer <= 0 && state.comboCooldown <= 0) {
                state.prevAnim = state.currentAnim;
                state.currentAnim = this.comboAttacks[state.comboStage];
                state.frameIndex = 0;
                state.frameProgress = 0.0f;
                state.blendTicks = 5;
                state.attackTimer = this.getAnimationDuration(state.currentAnim);
                state.comboCooldown = state.comboCooldowns[state.comboStage];
            } else {
                state.comboQueued = true;
            }
        }
        if (state.attackTimer > 0) {
            --state.attackTimer;
            if (state.attackTimer <= 0) {
                if (state.comboQueued) {
                    state.comboStage = (state.comboStage + 1) % this.comboAttacks.length;
                    state.prevAnim = state.currentAnim;
                    state.currentAnim = this.comboAttacks[state.comboStage];
                    state.frameIndex = 0;
                    state.frameProgress = 0.0f;
                    state.blendTicks = 5;
                    state.attackTimer = this.getAnimationDuration(state.currentAnim);
                    state.comboCooldown = state.comboCooldowns[state.comboStage];
                    state.comboQueued = false;
                } else {
                    state.comboStage = 0;
                }
            }
        }
        if ((targetAnim = state.attackTimer > 0 ? state.currentAnim : (living.func_70051_ag() || distance > 0.05f ? this.animWalk : this.animIdle)) == null || targetAnim.Frames.isEmpty()) {
            return;
        }
        AnimationData.Frame frameA = targetAnim.Frames.get(state.frameIndex);
        AnimationData.Frame frameB = targetAnim.Frames.get((state.frameIndex + 1) % targetAnim.Frames.size());
        float tFrame = state.frameProgress / (float)frameA.Duration;
        AnimationData.Frame prevFrame = state.prevAnim.Frames.get(Math.min(state.prevAnim.Frames.size() - 1, state.frameIndex));
        float tBlend = state.blendTicks > 0 ? 1.0f - (float)state.blendTicks / 5.0f : 1.0f;
        for (int i = 0; i < frameA.FrameParts.size(); ++i) {
            AnimationData.FramePart partA = frameA.FrameParts.get(i);
            AnimationData.FramePart partB = frameB.FrameParts.get(i);
            if (!partA.Part.equalsIgnoreCase(partName)) continue;
            float rot0 = partA.Rotation0 + (partB.Rotation0 - partA.Rotation0) * tFrame;
            float rot1 = partA.Rotation1 + (partB.Rotation1 - partA.Rotation1) * tFrame;
            float rot2 = partA.Rotation2 + (partB.Rotation2 - partA.Rotation2) * tFrame;
            float pivot0 = partA.Pivot0 + (partB.Pivot0 - partA.Pivot0) * tFrame;
            float pivot1 = partA.Pivot1 + (partB.Pivot1 - partA.Pivot1) * tFrame;
            float pivot2 = partA.Pivot2 + (partB.Pivot2 - partA.Pivot2) * tFrame;
            if (tBlend < 1.0f) {
                AnimationData.FramePart pPrev = prevFrame.FrameParts.get(i);
                rot0 = pPrev.Rotation0 + (rot0 - pPrev.Rotation0) * tBlend;
                rot1 = pPrev.Rotation1 + (rot1 - pPrev.Rotation1) * tBlend;
                rot2 = pPrev.Rotation2 + (rot2 - pPrev.Rotation2) * tBlend;
                pivot0 = pPrev.Pivot0 + (pivot0 - pPrev.Pivot0) * tBlend;
                pivot1 = pPrev.Pivot1 + (pivot1 - pPrev.Pivot1) * tBlend;
                pivot2 = pPrev.Pivot2 + (pivot2 - pPrev.Pivot2) * tBlend;
            }
            this.rotate(rot0, rot1, rot2);
            this.translate(pivot0, pivot1, pivot2);
        }
        float speed = targetAnim.Speed > 0.0f ? targetAnim.Speed : 1.0f;
        state.frameProgress += speed;
        while (state.frameProgress >= (float)frameA.Duration) {
            state.frameProgress -= (float)frameA.Duration;
            state.frameIndex = (state.frameIndex + 1) % targetAnim.Frames.size();
        }
        if (state.blendTicks > 0) {
            --state.blendTicks;
        }
    }

    private static class EntityAnimState {
        AnimationData currentAnim;
        AnimationData prevAnim;
        int frameIndex = 0;
        float frameProgress = 0.0f;
        int attackTimer = 0;
        int blendTicks = 0;
        int comboStage = 0;
        boolean comboQueued = false;
        int[] comboCooldowns;
        int comboCooldown = 0;

        private EntityAnimState() {
        }
    }
}

