/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrowJM.network.packets;

import com.google.common.base.Charsets;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import journeymap.client.model.Waypoint;
import journeymap.client.waypoint.WaypointStore;

public class CrowPacket
implements IMessage {
    private String operation;
    private String waypointName;
    private int cordX;
    private int cordY;
    private int cordZ;
    private int mundo;
    private String cor;

    public CrowPacket() {
    }

    public CrowPacket(String operation, String waypointName, int cordX, int cordY, int cordZ, int mundo, String cor) {
        this.operation = operation;
        this.waypointName = waypointName;
        this.cordX = cordX;
        this.cordY = cordY;
        this.cordZ = cordZ;
        this.mundo = mundo;
        this.cor = cor;
    }

    public void toBytes(ByteBuf buf) {
        CrowPacket.writeString(buf, this.operation);
        CrowPacket.writeString(buf, this.waypointName);
        buf.writeInt(this.cordX);
        buf.writeInt(this.cordY);
        buf.writeInt(this.cordZ);
        buf.writeInt(this.mundo);
        CrowPacket.writeString(buf, this.cor);
    }

    public void fromBytes(ByteBuf buf) {
        this.operation = CrowPacket.readString(buf);
        this.waypointName = CrowPacket.readString(buf);
        this.cordX = buf.readInt();
        this.cordY = buf.readInt();
        this.cordZ = buf.readInt();
        this.mundo = buf.readInt();
        this.cor = CrowPacket.readString(buf);
    }

    public static void writeString(ByteBuf buffer, String s) {
        byte[] bytes = s.getBytes(Charsets.UTF_8);
        buffer.writeShort((int)((short)bytes.length));
        buffer.writeBytes(bytes);
    }

    public static String readString(ByteBuf buffer) {
        try {
            byte[] bytes = new byte[buffer.readShort()];
            buffer.readBytes(bytes);
            return new String(bytes, Charsets.UTF_8);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public static class Handler
    implements IMessageHandler<CrowPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(CrowPacket message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                this.processMessage(message, ctx);
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void processMessage(CrowPacket message, MessageContext ctx) {
            String operation = message.operation;
            String waypointName = message.waypointName;
            int cordX = message.cordX;
            int cordY = message.cordY;
            int cordZ = message.cordZ;
            int mundo = message.mundo;
            String cor = message.cor;
            if (operation.equals("add")) {
                if (cor.equals("nope")) {
                    Waypoint ponto = new Waypoint(waypointName, cordX, cordY, cordZ, Color.white, Waypoint.Type.Normal, Integer.valueOf(mundo));
                    ponto.setRandomColor();
                    WaypointStore.instance().save(ponto);
                } else {
                    Waypoint ponto = new Waypoint(waypointName, cordX, cordY, cordZ, Color.white, Waypoint.Type.Normal, Integer.valueOf(mundo));
                    int valorCor = Integer.parseInt(cor, 16);
                    ponto.setColor(Integer.valueOf(valorCor));
                    WaypointStore.instance().save(ponto);
                }
            } else if (operation.equals("remove")) {
                this.removeByName(waypointName);
            }
        }

        public void removeByName(String waypointName) {
            for (Waypoint waypoint : WaypointStore.instance().getAll()) {
                if (!waypoint.getName().equals(waypointName)) continue;
                WaypointStore.instance().remove(waypoint);
                return;
            }
        }
    }
}

