/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.gui.hud;

import kamkeel.npcdbc.client.utils.Color;
import kamkeel.npcdbc.config.ConfigDBCClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;

public abstract class WheelSegment
extends Gui {
    private static final int HOVER_TIME = 200;
    public static ResourceLocation variant1 = new ResourceLocation("npcdbc:textures/gui/hud/formwheel/GuiWheelVariant1.png");
    public static ResourceLocation variant2 = new ResourceLocation("npcdbc:textures/gui/hud/formwheel/GuiWheelVariant2.png");
    public static Color HOVERED = new Color(11393254, 0.65f);
    public static Color NOT_HOVERED = new Color(0xFFFFFF, 0.35f);
    public static double width = 124.0;
    public static double height = 124.0;
    public static double f = 0.16666666666666666;
    public static int variant = 0;
    public Color currentColor;
    public int posX;
    public int posY;
    public int index;
    public boolean selected;
    public boolean isHovered = false;
    public long startHoverTime = 0L;
    public long stopHoverTime = 0L;
    public float hoverScale = 0.0f;

    public double easeInSine(float x) {
        return (double)x < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0f * x, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0)) + 1.0) / 2.0;
    }

    public WheelSegment(int index) {
        this(0, 0, index);
    }

    public WheelSegment(int posX, int posY, int index) {
        this.posX = posX;
        this.posY = posY;
        this.index = index;
    }

    public void setHoveredState(boolean newHoverState) {
        if (!this.isHovered && newHoverState) {
            this.startHoverTime = (long)((float)Minecraft.func_71386_F() - Math.max(this.hoverScale - 1.0f, 0.0f) * 200.0f);
        }
        if (this.isHovered && !newHoverState) {
            this.stopHoverTime = (long)((float)Minecraft.func_71386_F() - (1.0f - this.hoverScale) * 200.0f);
        }
        this.isHovered = newHoverState;
    }

    public float getSegmentScale() {
        if (this.isHovered) {
            float updateTime = (float)(Minecraft.func_71386_F() - this.startHoverTime) / 200.0f;
            updateTime = Math.min(updateTime, 1.0f);
            this.hoverScale = (float)this.easeInSine(updateTime);
        } else {
            float updateTime = (float)(Minecraft.func_71386_F() - this.stopHoverTime) / 200.0f;
            updateTime = Math.min(updateTime, 1.0f);
            this.hoverScale = (float)this.easeInSine(1.0f - updateTime);
        }
        this.hoverScale = Math.min(1.0f, Math.max(this.hoverScale, 0.0f));
        return this.hoverScale;
    }

    public void draw(FontRenderer fontRenderer) {
        this.currentColor = Color.lerpRGBA(NOT_HOVERED, HOVERED, this.hoverScale);
        this.currentColor.glColor();
        this.drawIndexedTexture();
        this.drawWheelItem(fontRenderer);
    }

    protected abstract void drawWheelItem(FontRenderer var1);

    private void drawIndexedTexture() {
        if (!ConfigDBCClient.AlteranteSelectionWheelTexture) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(variant1);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(variant2);
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)this.posX - width / 2.0, (double)this.posY + height / 2.0, (double)this.field_73735_i + 1.0, (double)this.index * f, 1.0);
        tessellator.func_78374_a((double)this.posX + width / 2.0, (double)this.posY + height / 2.0, (double)this.field_73735_i + 1.0, (double)(this.index + 1) * f, 1.0);
        tessellator.func_78374_a((double)this.posX + width / 2.0, (double)this.posY - height / 2.0, (double)this.field_73735_i + 1.0, (double)(this.index + 1) * f, 0.0);
        tessellator.func_78374_a((double)this.posX - width / 2.0, (double)this.posY - height / 2.0, (double)this.field_73735_i + 1.0, (double)this.index * f, 0.0);
        tessellator.func_78381_a();
    }
}

