/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.player.form;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.NetworkUtility;
import kamkeel.npcdbc.network.PacketChannel;
import kamkeel.npcdbc.network.packets.EnumPacketPlayer;
import kamkeel.npcs.network.packets.data.large.GuiDataPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public final class DBCRequestForm
extends AbstractPacket {
    public static final String packetName = "NPC|RequestForm";
    private int formID;
    private boolean onlyPlayers;
    private boolean menuName;

    public DBCRequestForm(int formID, boolean players, boolean menuName) {
        this.formID = formID;
        this.onlyPlayers = players;
        this.menuName = menuName;
    }

    public DBCRequestForm() {
    }

    @Override
    public Enum getType() {
        return EnumPacketPlayer.FormList;
    }

    @Override
    public PacketChannel getChannel() {
        return DBCPacketHandler.PLAYER_PACKETS;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        out.writeInt(this.formID);
        out.writeBoolean(this.onlyPlayers);
        out.writeBoolean(this.menuName);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        this.formID = in.readInt();
        this.onlyPlayers = in.readBoolean();
        this.menuName = in.readBoolean();
        if (this.formID != -1) {
            Form customForm = (Form)FormController.getInstance().get(this.formID);
            if (customForm != null) {
                NBTTagCompound compound = customForm.writeToNBT();
                compound.func_74778_a("PACKETTYPE", "Form");
                GuiDataPacket.sendGuiData((EntityPlayerMP)((EntityPlayerMP)player), (NBTTagCompound)compound);
            }
        } else if (this.onlyPlayers) {
            NetworkUtility.sendPlayersForms(player, this.menuName);
        } else {
            NetworkUtility.sendCustomFormDataAll((EntityPlayerMP)player);
        }
    }
}

