/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client;

import kamkeel.npcdbc.config.ConfigDBCClient;
import noppes.npcs.util.ValueUtil;
import org.lwjgl.opengl.GL11;

public class ColorMode {
    public static int DARKMODE_TEXT = 0x7C7C7C;
    public static int DARKMODE_TEXT_ALTERNATE = 0xB2B2B2;
    public static int LIGHTMODE_TEXT = 0x2F2F2F;
    public static int LIGHTMODE_TEXT_ALTERNATE = 0x181818;

    public static int textColor() {
        if (ConfigDBCClient.DarkMode) {
            return DARKMODE_TEXT;
        }
        return LIGHTMODE_TEXT;
    }

    public static int textAlt() {
        if (ConfigDBCClient.DarkMode) {
            return DARKMODE_TEXT_ALTERNATE;
        }
        return LIGHTMODE_TEXT_ALTERNATE;
    }

    public static String skimColors(String input) {
        if (ConfigDBCClient.DarkMode) {
            return input.replace("\u00a70", "").replace("\u00a78", "\u00a77").replace("&0", "");
        }
        return input.replace("\u00a7f", "").replace("\u00a77", "\u00a78").replace("&f", "");
    }

    public static void glColorInt(int color, float alpha) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)alpha);
    }

    public static int mixColors(int color1, int color2, float alpha) {
        alpha = ValueUtil.clamp((float)alpha, (float)0.0f, (float)1.0f);
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((1.0f - alpha) * (float)r1 + alpha * (float)r2);
        int g = (int)((1.0f - alpha) * (float)g1 + alpha * (float)g2);
        int b = (int)((1.0f - alpha) * (float)b1 + alpha * (float)b2);
        return r << 16 | g << 8 | b;
    }

    public static int mixColors(int color1, int color2, int color3, float alpha1, float alpha2) {
        alpha1 = ValueUtil.clamp((float)alpha1, (float)0.0f, (float)1.0f);
        alpha2 = ValueUtil.clamp((float)alpha2, (float)0.0f, (float)1.0f);
        float remainingAlpha = ValueUtil.clamp((float)(1.0f - alpha1 - alpha2), (float)0.0f, (float)1.0f);
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r3 = color3 >> 16 & 0xFF;
        int g3 = color3 >> 8 & 0xFF;
        int b3 = color3 & 0xFF;
        int r = (int)(remainingAlpha * (float)r1 + alpha1 * (float)r2 + alpha2 * (float)r3);
        int g = (int)(remainingAlpha * (float)g1 + alpha1 * (float)g2 + alpha2 * (float)g3);
        int b = (int)(remainingAlpha * (float)b1 + alpha1 * (float)b2 + alpha2 * (float)b3);
        return r << 16 | g << 8 | b;
    }

    public static void applyModelColor(int color, boolean isHurt) {
        ColorMode.applyModelColor(color, 1.0f, isHurt);
    }

    public static void applyModelColor(int color, float alpha, boolean isHurt) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        if (isHurt) {
            red = (float)Math.min((double)red + 0.2, 1.0);
            green = (float)Math.max((double)green - 0.2, 0.0);
            blue = (float)Math.max((double)blue - 0.2, 0.0);
        }
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
    }
}

