/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.gui.dbc;

import JinRyuu.JRMCore.JRMCoreH;
import kamkeel.npcdbc.client.gui.component.GuiRenderPlayer;
import kamkeel.npcdbc.client.gui.dbc.AbstractJRMCGui;
import kamkeel.npcdbc.client.gui.dbc.JRMCoreLabel;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.data.form.FormDisplay;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.packets.player.SaveFormCustomization;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.SubGuiColorSelector;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.SubGuiInterface;

public class GuiFormCustomizer
extends AbstractJRMCGui
implements ISubGuiListener {
    private static final String[] COLOR_TYPES = new String[]{"bodycm", "bodyc1", "bodyc2", "bodyc3", "fur", "hair", "eye"};
    private static final String[] COLOR_NAMES = new String[]{"model.body", "display.bodyc1", "display.bodyc2", "display.bodyc3", "display.bodyFur", "display.hair", "display.eye"};
    private final int dbcRace;
    private final Form form;
    private final FormDisplay.BodyColor colors;
    private GuiRenderPlayer playerRenderer;
    private int lastClickedID;

    public GuiFormCustomizer(Form currentForm) {
        super(-1);
        this.form = currentForm;
        DBCData dataClient = DBCData.getClient();
        this.colors = dataClient.currentCustomizedColors;
        this.dbcRace = dataClient.Race;
    }

    @Override
    public void func_73866_w_() {
        this.addDefaultButtons = false;
        super.func_73866_w_();
        this.addCloseButton();
        this.playerRenderer = new GuiRenderPlayer(this, this.guiWidthOffset + 4, this.guiHeightOffset + 4, this.menuImageWidth / 2 - 6, this.menuImageHeight - 8, this.colors);
        this.playerRenderer.customFormID = this.form.id;
        JRMCoreLabel formLabel = new JRMCoreLabel("%1s's colors", null, 0, this.guiHeightOffset - 12);
        formLabel.updateDisplay(this.form.menuName);
        formLabel.xPosition = this.guiWidthOffset + 4 + (this.menuImageWidth - 6 - this.field_146289_q.func_78256_a(formLabel.display)) / 2;
        this.hoverableStaticLabels.add(formLabel);
        int y = this.guiHeightOffset + 12;
        int x = this.guiWidthOffset + 4 + this.menuImageWidth / 2 - 5;
        for (int i = 0; i < COLOR_TYPES.length; ++i) {
            if (!FormDisplay.BodyColor.canBeCustomized(COLOR_TYPES[i], this.dbcRace, this.form)) continue;
            JRMCoreLabel label = new JRMCoreLabel(null, null, x, y);
            label.setDisplay(JRMCoreH.trl((String)COLOR_NAMES[i]));
            this.hoverableStaticLabels.add(label);
            int color = this.getColor(COLOR_TYPES[i]);
            GuiNpcButton removeButton = new GuiNpcButton(200 + i, this.guiWidthOffset + this.menuImageWidth - 5 - 20, y - 5, 20, 20, "X");
            this.field_146292_n.add(removeButton);
            GuiNpcButton button = new GuiNpcButton(100 + i, removeButton.field_146128_h - 55, y - 5, 55, 20, color != -1 ? "#" + Integer.toString(color, 16) : "NONE");
            button.packedFGColour = color;
            this.field_146292_n.add(button);
            y += 22;
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        int id = button.field_146127_k;
        if (id >= 200) {
            int action = id - 200;
            this.colors.setColor(COLOR_TYPES[action], -1);
            this.func_73866_w_();
            return;
        }
        if (id >= 100) {
            int action;
            this.lastClickedID = action = id - 100;
            this.openSubGui((SubGuiInterface)new SubGuiColorSelector(this.getColor(COLOR_TYPES[action])){

                public void close() {
                    if (this.parent instanceof ISubGuiListener) {
                        ((ISubGuiListener)this.parent).subGuiClosed((SubGuiInterface)this);
                    }
                }
            });
            this.func_73866_w_();
            return;
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.playerRenderer.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_146281_b() {
        this.save();
    }

    private void save() {
        DBCPacketHandler.Instance.sendToServer(new SaveFormCustomization(this.form, this.colors));
    }

    public void subGuiClosed(SubGuiInterface subGuiInterface) {
        if (subGuiInterface instanceof SubGuiColorSelector) {
            this.handleColorSelection((SubGuiColorSelector)subGuiInterface, this.lastClickedID);
        }
        NoppesUtil.openGUI((EntityPlayer)this.field_146297_k.field_71439_g, (Object)((Object)this));
        this.lastClickedID = -1;
    }

    private void handleColorSelection(SubGuiColorSelector subGuiInterface, int colorID) {
        this.colors.setColor(COLOR_TYPES[colorID], subGuiInterface.color);
    }

    public void openSubGui(SubGuiInterface subGuiInterface) {
        subGuiInterface.parent = this;
        subGuiInterface.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        this.field_146297_k.field_71462_r = subGuiInterface;
    }

    public int getColor(String type) {
        return this.colors.getProperColor(this.form.display, type);
    }
}

