/*
 * Decompiled with CFR 0.152.
 */
package com.crow.mob;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;

public class AssetManager {
    public static Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
    public static Map<String, IIcon> icons = new HashMap<String, IIcon>();
    public static Map<String, IIcon[]> iconGroups = new HashMap<String, IIcon[]>();
    public static Map<String, String> sounds = new HashMap<String, String>();
    public static Map<String, ModelBase> models = new HashMap<String, ModelBase>();
    public static Map<String, IModelCustom> objModels = new HashMap<String, IModelCustom>();

    public static void addTexture(String name, String path) {
        name = name.toLowerCase();
        textures.put(name, new ResourceLocation("asd", path));
    }

    public static void addIcon(String name, IIcon icon) {
        name = name.toLowerCase();
        icons.put(name, icon);
    }

    public static void addSound(String name, String path) {
        name = name.toLowerCase();
        sounds.put(name, name + ":" + path);
    }

    public static void addModel(String name, ModelBase model) {
        name = name.toLowerCase();
        models.put(name, model);
    }

    public static void addObjModel(String name, String path) {
        name = name.toLowerCase();
        objModels.put(name, AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation(path)));
    }

    public static ResourceLocation getTexture(String name) {
        if (!textures.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return textures.get(name);
    }

    public static IIcon getIcon(String name) {
        if (!icons.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return icons.get(name);
    }

    public static IIcon[] getIconGroup(String name) {
        if (!iconGroups.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return iconGroups.get(name);
    }

    public static String getSound(String name) {
        if (!sounds.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return sounds.get(name);
    }

    public static ModelBase getModel(String name) {
        if (!models.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return models.get(name);
    }

    public static IModelCustom getObjModel(String name) {
        if (!objModels.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return objModels.get(name);
    }

    public static IModelCustom getObjModel(String name, String path) {
        if (!objModels.containsKey(name = name.toLowerCase())) {
            AssetManager.addObjModel(name, path);
        }
        return objModels.get(name);
    }
}

