/*
 * Decompiled with CFR 0.152.
 */
package com.crow.mob;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelCustomObj
extends ModelBase {
    public static float modelXRotOffset = 180.0f;
    public static float modelYPosOffset = -1.5f;
    public WavefrontObject model;
    public ArrayList<GroupObject> parts;
    public Map<String, float[]> partCenters = new HashMap<String, float[]>();
    public Map<String, float[]> partSubCenters = new HashMap<String, float[]>();
    public Map<String, float[]> offsets = new HashMap<String, float[]>();
    public boolean lockHeadX = false;
    public boolean lockHeadY = false;
    public boolean bodyIsTrophy = true;
    public float trophyScale = 1.0f;
    public float[] trophyOffset = new float[0];
    public float[] trophyMouthOffset = new float[0];
    public boolean dontColor = false;

    public ModelCustomObj() {
        this(1.0f);
    }

    public ModelCustomObj(float shadowSize) {
    }

    public void func_78088_a(Entity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        boolean trophyModel = false;
        if (scale < 0.0f) {
            trophyModel = true;
            scale = -scale;
        } else {
            scale *= 16.0f;
        }
        for (GroupObject part : this.parts) {
            if (part.name == null) continue;
            boolean isTrophyPart = this.isTrophyPart(part);
            if (this.bodyIsTrophy && part.name.toLowerCase().contains("body")) {
                isTrophyPart = true;
            }
            if (trophyModel && !isTrophyPart) continue;
            GL11.glPushMatrix();
            this.rotate(modelXRotOffset, 1.0f, 0.0f, 0.0f);
            this.translate(0.0f, modelYPosOffset, 0.0f);
            this.scale(scale, scale, scale);
            if (trophyModel) {
                this.scale(this.trophyScale, this.trophyScale, this.trophyScale);
            }
            this.centerPart(part.name.toLowerCase());
            this.animatePart(part.name.toLowerCase(), (EntityLiving)entity, time, distance, loop, -lookY, lookX, scale);
            if (trophyModel) {
                if (!part.name.toLowerCase().contains("head") && !part.name.toLowerCase().contains("body")) {
                    float[] mouthOffset = this.comparePartCenters(this.bodyIsTrophy ? "body" : "head", part.name.toLowerCase());
                    this.translate(mouthOffset[0], mouthOffset[1], mouthOffset[2]);
                    if (this.trophyMouthOffset.length >= 3) {
                        this.translate(this.trophyMouthOffset[0], this.trophyMouthOffset[1], this.trophyMouthOffset[2]);
                    }
                }
                if (part.name.toLowerCase().contains("head")) {
                    if (!part.name.toLowerCase().contains("left")) {
                        this.translate(-0.3f, 0.0f, 0.0f);
                        this.rotate(5.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (!part.name.toLowerCase().contains("right")) {
                        this.translate(0.3f, 0.0f, 0.0f);
                        this.rotate(-5.0f, 0.0f, 1.0f, 0.0f);
                    }
                }
                this.uncenterPart(part.name.toLowerCase());
                if (this.trophyOffset.length >= 3) {
                    this.translate(this.trophyOffset[0], this.trophyOffset[1], this.trophyOffset[2]);
                }
            }
            this.uncenterPart(part.name.toLowerCase());
            part.render();
            GL11.glPopMatrix();
        }
    }

    public boolean isTrophyPart(String partName) {
        if (partName == null) {
            return false;
        }
        return (partName = partName.toLowerCase()).contains("head") || partName.contains("mouth") || partName.contains("eye");
    }

    public boolean isTrophyPart(GroupObject part) {
        return part != null && this.isTrophyPart(part.name.toLowerCase());
    }

    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.toLowerCase().contains("head")) {
            if (!this.lockHeadX) {
                rotX += (float)Math.toDegrees(lookX / 57.295776f);
            }
            if (!this.lockHeadY) {
                rotY += (float)Math.toDegrees(lookY / 57.295776f);
            }
        }
        this.rotate(0.0f, 0.0f, 0.0f, 0.0f);
        this.rotate(rotX, rotY, 0.0f);
        this.translate(0.0f, 0.0f, 0.0f);
    }

    public void childScale(String partName) {
        this.scale(0.5f, 0.5f, 0.5f);
    }

    public void rotate(float rotX, float rotY, float rotZ) {
        GL11.glRotatef((float)rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotY, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public void rotate(float rotation, float angleX, float angleY, float angleZ) {
        GL11.glRotatef((float)rotation, (float)angleX, (float)angleY, (float)angleZ);
    }

    public void translate(float posX, float posY, float posZ) {
        GL11.glTranslatef((float)posX, (float)posY, (float)posZ);
    }

    public void scale(float scaleX, float scaleY, float scaleZ) {
        GL11.glScalef((float)scaleX, (float)scaleY, (float)scaleZ);
    }

    public void setPartCenter(String partName, float centerX, float centerY, float centerZ) {
        if (this.isTrophyPart(partName)) {
            this.bodyIsTrophy = false;
        }
        this.partCenters.put(partName, new float[]{centerX, centerY, centerZ});
    }

    public void setPartCenters(float centerX, float centerY, float centerZ, String ... partNames) {
        for (String partName : partNames) {
            this.setPartCenter(partName, centerX, centerY, centerZ);
        }
    }

    public float[] getPartCenter(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.partCenters.get(partName);
    }

    public void centerPart(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return;
        }
        float[] partCenter = this.partCenters.get(partName);
        this.translate(partCenter[0], partCenter[1], partCenter[2]);
    }

    public void uncenterPart(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return;
        }
        float[] partCenter = this.partCenters.get(partName);
        this.translate(-partCenter[0], -partCenter[1], -partCenter[2]);
    }

    public void centerPartToPart(String part, String targetPart) {
        this.uncenterPart(part);
        float[] partCenter = this.partCenters.get(targetPart);
        if (partCenter != null) {
            this.translate(partCenter[0], partCenter[1], partCenter[2]);
        }
    }

    public void uncenterPartToPart(String part, String targetPart) {
        float[] partCenter = this.partCenters.get(targetPart);
        if (partCenter != null) {
            this.translate(-partCenter[0], -partCenter[1], -partCenter[2]);
        }
        this.centerPart(part);
    }

    public float[] comparePartCenters(String centerPartName, String targetPartName) {
        float[] centerPart = this.getPartCenter(centerPartName);
        float[] targetPart = this.getPartCenter(targetPartName);
        float[] partDifference = new float[3];
        if (targetPart == null) {
            return partDifference;
        }
        for (int i = 0; i < 3; ++i) {
            partDifference[i] = targetPart[i] - centerPart[i];
        }
        return partDifference;
    }

    public void setPartSubCenter(String partName, float centerX, float centerY, float centerZ) {
        this.partSubCenters.put(partName, new float[]{centerX, centerY, centerZ});
    }

    public void setPartSubCenters(float centerX, float centerY, float centerZ, String ... partNames) {
        for (String partName : partNames) {
            this.setPartSubCenter(partName, centerX, centerY, centerZ);
        }
    }

    public void subCenterPart(String partName) {
        float[] offset = this.getSubCenterOffset(partName);
        if (offset == null) {
            return;
        }
        this.translate(offset[0], offset[1], offset[2]);
    }

    public void unsubCenterPart(String partName) {
        float[] offset = this.getSubCenterOffset(partName);
        if (offset == null) {
            return;
        }
        this.translate(-offset[0], -offset[1], -offset[2]);
    }

    public float[] getSubCenterOffset(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return null;
        }
        if (!this.partSubCenters.containsKey(partName)) {
            return null;
        }
        float[] partCenter = this.partCenters.get(partName);
        float[] partSubCenter = this.partSubCenters.get(partName);
        float[] offset = new float[3];
        for (int coord = 0; coord < 3; ++coord) {
            offset[coord] = partSubCenter[coord] - partCenter[coord];
        }
        return offset;
    }

    public void setOffset(String offsetName, float[] offset) {
        this.offsets.put(offsetName, offset);
    }

    public float[] getOffset(String offsetName) {
        if (!this.offsets.containsKey(offsetName)) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.offsets.get(offsetName);
    }

    public double rotateToPoint(double aTarget, double bTarget) {
        return this.rotateToPoint(0.0, 0.0, aTarget, bTarget);
    }

    public double rotateToPoint(double aCenter, double bCenter, double aTarget, double bTarget) {
        if (aTarget - aCenter == 0.0) {
            if (aTarget > aCenter) {
                return 0.0;
            }
            if (aTarget < aCenter) {
                return 180.0;
            }
        }
        if (bTarget - bCenter == 0.0) {
            if (bTarget > bCenter) {
                return 90.0;
            }
            if (bTarget < bCenter) {
                return -90.0;
            }
        }
        if (aTarget - aCenter == 0.0 && bTarget - bCenter == 0.0) {
            return 0.0;
        }
        return Math.toDegrees(Math.atan2(aCenter - aTarget, bCenter - bTarget) - 1.5707963267948966);
    }

    public double[] rotateToPoint(double xCenter, double yCenter, double zCenter, double xTarget, double yTarget, double zTarget) {
        double[] rotations = new double[]{this.rotateToPoint(yCenter, -zCenter, yTarget, -zTarget), this.rotateToPoint(-zCenter, xCenter, -zTarget, xTarget), this.rotateToPoint(yCenter, xCenter, yTarget, xTarget)};
        return rotations;
    }
}

