/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultkeys.localconfig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.defaultkeys.localconfig.LocalConfigEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleConfigHandler {
    private static final Logger logger = LogManager.getLogger();

    public static void backup(PrintWriter writer, List<LocalConfigEntry> entries, File configFile) {
        boolean[] foundProperty = new boolean[entries.size()];
        ArrayList<LocalConfigEntry> notEntries = new ArrayList<LocalConfigEntry>();
        for (LocalConfigEntry entry : entries) {
            if (!entry.not) continue;
            notEntries.add(entry);
        }
        ArrayList<String> categoryPath = new ArrayList<String>();
        boolean isInQuotes = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            int i;
            String line;
            StringBuilder buffer = new StringBuilder();
            block19: while ((line = reader.readLine()) != null) {
                block20: for (i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (isInQuotes) {
                        if (c == '\"') {
                            isInQuotes = false;
                        }
                        buffer.append(c);
                        continue;
                    }
                    switch (c) {
                        case '#': {
                            continue block19;
                        }
                        case '\"': {
                            isInQuotes = true;
                            buffer.append(c);
                            continue block20;
                        }
                        case '{': {
                            categoryPath.add(buffer.toString().trim());
                            buffer = new StringBuilder();
                            continue block20;
                        }
                        case '}': {
                            categoryPath.remove(categoryPath.size() - 1);
                            continue block20;
                        }
                        case '=': {
                            String category = StringUtils.join(categoryPath, (String)".");
                            String name = buffer.toString().trim();
                            buffer = new StringBuilder();
                            String value = line.substring(i + 1);
                            for (int j = 0; j < entries.size(); ++j) {
                                LocalConfigEntry entry = entries.get(j);
                                if (!entry.passesProperty(category, name, "*")) continue;
                                foundProperty[j] = true;
                                if (entry.containsWildcard()) {
                                    for (LocalConfigEntry notEntry : notEntries) {
                                        if (!notEntry.passesProperty(category, name, "*")) continue;
                                        continue block19;
                                    }
                                }
                                writer.println(entry.getIdentifier(entry.file, category, "*", name) + "=" + value);
                                continue block19;
                            }
                            continue block19;
                        }
                        default: {
                            buffer.append(c);
                        }
                    }
                }
            }
            for (i = 0; i < foundProperty.length; ++i) {
                if (foundProperty[i] || entries.get((int)i).not) continue;
                logger.warn("Failed to backup local value {}: property not found", new Object[]{entries.get(i).getIdentifier()});
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void restore(List<LocalConfigEntry> entries, File configFile) {
        boolean[] foundProperty = new boolean[entries.size()];
        ArrayList<LocalConfigEntry> notEntries = new ArrayList<LocalConfigEntry>();
        for (LocalConfigEntry entry : entries) {
            if (!entry.not) continue;
            notEntries.add(entry);
        }
        File backupFile = new File(configFile.getParentFile(), configFile.getName() + ".bak");
        try {
            FileUtils.copyFile((File)configFile, (File)backupFile);
        }
        catch (IOException e) {
            logger.error("Could not create backup file {}: {}", new Object[]{backupFile, e});
        }
        try {
            List lines = FileUtils.readLines((File)configFile);
            try (PrintWriter writer = new PrintWriter(configFile);){
                ArrayList<String> categoryPath = new ArrayList<String>();
                boolean isInQuotes = false;
                StringBuilder buffer = new StringBuilder();
                for (String line : lines) {
                    block24: for (int i = 0; i < line.length(); ++i) {
                        char c = line.charAt(i);
                        if (isInQuotes) {
                            if (c == '\"') {
                                isInQuotes = false;
                            }
                            buffer.append(c);
                            continue;
                        }
                        switch (c) {
                            case '#': {
                                break block24;
                            }
                            case '\"': {
                                isInQuotes = true;
                                buffer.append(c);
                                continue block24;
                            }
                            case '{': {
                                categoryPath.add(buffer.toString().trim());
                                buffer = new StringBuilder();
                                continue block24;
                            }
                            case '}': {
                                categoryPath.remove(categoryPath.size() - 1);
                                continue block24;
                            }
                            case '=': {
                                String category = StringUtils.join(categoryPath, (String)".");
                                String name = buffer.toString().trim();
                                buffer = new StringBuilder();
                                for (int j = 0; j < entries.size(); ++j) {
                                    LocalConfigEntry entry = entries.get(j);
                                    if (!entry.passesProperty(category, name, "*")) continue;
                                    foundProperty[j] = true;
                                    if (entry.containsWildcard()) {
                                        for (LocalConfigEntry notEntry : notEntries) {
                                            if (!notEntry.passesProperty(category, name, "*")) continue;
                                            break block24;
                                        }
                                    }
                                    line = line.substring(0, i) + "=" + entry.value;
                                    break block24;
                                }
                                break block24;
                            }
                            default: {
                                buffer.append(c);
                            }
                        }
                    }
                    writer.println(line);
                }
            }
            for (int i = 0; i < foundProperty.length; ++i) {
                if (foundProperty[i] || entries.get((int)i).not) continue;
                logger.warn("Failed to restore local value {}: property not found", new Object[]{entries.get(i).getIdentifier()});
            }
        }
        catch (IOException e) {
            logger.error("Failed to restore local values in {}: {}", new Object[]{configFile, e});
            try {
                FileUtils.copyFile((File)backupFile, (File)configFile);
            }
            catch (IOException e2) {
                logger.error("Could not restore config file {} from backup: {}", new Object[]{configFile, e2});
            }
        }
    }
}

