/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.api.playertab;

import io.github.cruciblemc.necrotempus.api.playertab.PlayerTabManager;
import io.github.cruciblemc.necrotempus.api.playertab.TabCell;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class PlayerTab {
    private static PlayerTabManager playerTabManager = PlayerTabManager.commonInstance();
    private List<TabCell> cellList;
    private boolean drawPlayerHeads;
    private IChatComponent header;
    private IChatComponent footer;

    public NBTTagCompound toNbt() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        NBTTagList cellListTag = new NBTTagList();
        for (TabCell cell : this.cellList) {
            cellListTag.func_74742_a((NBTBase)cell.toNbt());
        }
        nbtTagCompound.func_74782_a("cellList", (NBTBase)cellListTag);
        nbtTagCompound.func_74757_a("drawPlayerHeads", this.drawPlayerHeads);
        if (this.header != null) {
            nbtTagCompound.func_74778_a("header", this.header.func_150260_c());
        }
        if (this.footer != null) {
            nbtTagCompound.func_74778_a("footer", this.footer.func_150260_c());
        }
        return nbtTagCompound;
    }

    public static PlayerTab fromCompound(NBTTagCompound compound) {
        ArrayList<TabCell> cells = new ArrayList<TabCell>();
        if (compound.func_150297_b("cellList", 10)) {
            NBTTagList tagList = compound.func_150295_c("cellList", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                cells.add(TabCell.fromNBT(tagList.func_150305_b(i)));
            }
        }
        ChatComponentText header = null;
        if (compound.func_74764_b("header")) {
            header = new ChatComponentText(compound.func_74779_i("header"));
        }
        ChatComponentText footer = null;
        if (compound.func_74764_b("footer")) {
            footer = new ChatComponentText(compound.func_74779_i("footer"));
        }
        return new PlayerTab(cells, compound.func_74767_n("drawPlayerHeads"), (IChatComponent)header, (IChatComponent)footer);
    }

    public List<TabCell> getCellList() {
        return this.cellList;
    }

    public boolean isDrawPlayerHeads() {
        return this.drawPlayerHeads;
    }

    public IChatComponent getHeader() {
        return this.header;
    }

    public IChatComponent getFooter() {
        return this.footer;
    }

    public void setCellList(List<TabCell> cellList) {
        this.cellList = cellList;
    }

    public void setDrawPlayerHeads(boolean drawPlayerHeads) {
        this.drawPlayerHeads = drawPlayerHeads;
    }

    public void setHeader(IChatComponent header) {
        this.header = header;
    }

    public void setFooter(IChatComponent footer) {
        this.footer = footer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerTab)) {
            return false;
        }
        PlayerTab other = (PlayerTab)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDrawPlayerHeads() != other.isDrawPlayerHeads()) {
            return false;
        }
        List<TabCell> this$cellList = this.getCellList();
        List<TabCell> other$cellList = other.getCellList();
        if (this$cellList == null ? other$cellList != null : !((Object)this$cellList).equals(other$cellList)) {
            return false;
        }
        IChatComponent this$header = this.getHeader();
        IChatComponent other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        IChatComponent this$footer = this.getFooter();
        IChatComponent other$footer = other.getFooter();
        return !(this$footer == null ? other$footer != null : !this$footer.equals(other$footer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerTab;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDrawPlayerHeads() ? 79 : 97);
        List<TabCell> $cellList = this.getCellList();
        result = result * 59 + ($cellList == null ? 43 : ((Object)$cellList).hashCode());
        IChatComponent $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        IChatComponent $footer = this.getFooter();
        result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
        return result;
    }

    public String toString() {
        return "PlayerTab(cellList=" + this.getCellList() + ", drawPlayerHeads=" + this.isDrawPlayerHeads() + ", header=" + this.getHeader() + ", footer=" + this.getFooter() + ")";
    }

    public PlayerTab(List<TabCell> cellList, boolean drawPlayerHeads, IChatComponent header, IChatComponent footer) {
        this.cellList = cellList;
        this.drawPlayerHeads = drawPlayerHeads;
        this.header = header;
        this.footer = footer;
    }

    public PlayerTab() {
    }

    public static PlayerTabManager getPlayerTabManager() {
        return playerTabManager;
    }

    public static void setPlayerTabManager(PlayerTabManager playerTabManager) {
        PlayerTab.playerTabManager = playerTabManager;
    }
}

