/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.glyphs.compat.crafttweaker;

import cpw.mods.fml.common.FMLCommonHandler;
import io.github.cruciblemc.necrotempus.modules.features.glyphs.CustomGlyphs;
import io.github.cruciblemc.necrotempus.modules.features.glyphs.GlyphsRegistry;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="necrotempus.crafttweaker.Glyph")
@ModOnly(value={"necrotempus"})
public class Glyphs {
    @ZenMethod
    public static void register(String target, String resource, int horizontalPadding, int verticalPadding, int width, int height) {
        MineTweakerAPI.apply((IUndoableAction)new GlyphCustomizeAddAction(target.charAt(0), new ResourceLocation(resource), horizontalPadding, verticalPadding, width, height));
    }

    @ZenMethod
    public static void register(String target, String resource, int horizontalPadding, int verticalPadding, int width, int height, String fitMode) {
        MineTweakerAPI.apply((IUndoableAction)new GlyphCustomizeAddAction(target.charAt(0), new ResourceLocation(resource), horizontalPadding, verticalPadding, width, height, fitMode, -1));
    }

    @ZenMethod
    public static void register(String target, String resource, int horizontalPadding, int verticalPadding, int width, int height, String fitMode, int charWidth) {
        MineTweakerAPI.apply((IUndoableAction)new GlyphCustomizeAddAction(target.charAt(0), new ResourceLocation(resource), horizontalPadding, verticalPadding, width, height, fitMode, charWidth));
    }

    @ZenMethod
    public static void unregister(String target) {
        MineTweakerAPI.apply((IUndoableAction)new GlyphCustomizeRemoveAction(Character.valueOf(target.charAt(0))));
    }

    public static class GlyphCustomizeAddAction
    implements IUndoableAction {
        private final char target;
        private final ResourceLocation resource;
        private final int horizontalPadding;
        private final int verticalPadding;
        private final int width;
        private final int height;
        private CustomGlyphs.FitMode fitMode = CustomGlyphs.FitMode.NONE;
        private int charWidth = -1;

        public GlyphCustomizeAddAction(char target, ResourceLocation resource, int horizontalPadding, int verticalPadding, int width, int height) {
            this.target = target;
            this.resource = resource;
            this.horizontalPadding = horizontalPadding;
            this.verticalPadding = verticalPadding;
            this.width = width;
            this.height = height;
        }

        public GlyphCustomizeAddAction(char target, ResourceLocation resource, int horizontalPadding, int verticalPadding, int width, int height, String fitMode, int charWidth) {
            this.target = target;
            this.resource = resource;
            this.horizontalPadding = horizontalPadding;
            this.verticalPadding = verticalPadding;
            this.width = width;
            this.height = height;
            this.charWidth = charWidth;
            this.fitMode = CustomGlyphs.FitMode.parse(fitMode);
        }

        public boolean canUndo() {
            return true;
        }

        public void apply() {
            if (FMLCommonHandler.instance().getSide().isClient()) {
                CustomGlyphs customGlyphs = new CustomGlyphs(this.target, this.resource, this.horizontalPadding, this.verticalPadding, this.width, this.height);
                customGlyphs.setFitMode(this.fitMode);
                customGlyphs.setCharWidth(this.charWidth);
                GlyphsRegistry.register(customGlyphs);
            }
        }

        public void undo() {
            if (FMLCommonHandler.instance().getSide().isClient()) {
                GlyphsRegistry.unregister(Character.valueOf(this.target));
            }
        }

        public String describe() {
            return String.format("Registering Custom Glyph for character %s. (Width: %d, Height: %d, HPadding: %d, VPadding: %d, FitMode: %s, CharWidth: %d)", new Object[]{Character.valueOf(this.target), this.width, this.height, this.horizontalPadding, this.verticalPadding, this.fitMode, this.charWidth});
        }

        public String describeUndo() {
            return String.format("Removing Custom Glyph for character %s. (Width: %d, Height: %d, HPadding: %d, VPadding: %d, FitMode: %s, CharWidth: %d)", new Object[]{Character.valueOf(this.target), this.width, this.height, this.horizontalPadding, this.verticalPadding, this.fitMode, this.charWidth});
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    public static class GlyphCustomizeRemoveAction
    implements IUndoableAction {
        private final Character target;
        private CustomGlyphs customGlyphs;

        public GlyphCustomizeRemoveAction(Character target) {
            this.target = target;
        }

        public void apply() {
            if (FMLCommonHandler.instance().getSide().isClient()) {
                this.customGlyphs = GlyphsRegistry.getCandidate(this.target.charValue());
                if (this.customGlyphs != null) {
                    GlyphsRegistry.unregister(this.customGlyphs);
                }
            }
        }

        public boolean canUndo() {
            return FMLCommonHandler.instance().getSide().isClient() && this.customGlyphs != null;
        }

        public void undo() {
            if (FMLCommonHandler.instance().getSide().isClient()) {
                GlyphsRegistry.register(this.customGlyphs);
            }
        }

        public String describe() {
            return String.format("Removing Custom Glyph for character %s.", this.target);
        }

        public String describeUndo() {
            return String.format("Registering Custom Glyph for character %s. (Width: %d, Height: %d, HPadding: %d, VPadding: %d, FitMode: %s, CharWidth: %d)", new Object[]{Character.valueOf(this.customGlyphs.getTarget()), this.customGlyphs.getWidth(), this.customGlyphs.getHeight(), this.customGlyphs.getHorizontalPadding(), this.customGlyphs.getVerticalPadding(), this.customGlyphs.getFitMode(), this.customGlyphs.getCharWidth()});
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

