/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.gui.dbc;

import java.util.List;
import kamkeel.npcdbc.client.ColorMode;
import kamkeel.npcdbc.client.gui.dbc.HoverableLabel;
import kamkeel.npcdbc.config.ConfigDBCClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class JRMCoreLabel
extends Gui
implements HoverableLabel {
    protected static final ResourceLocation background = new ResourceLocation("jinryuumodscore:allw.png");
    protected String displayFormat;
    protected String tooltipFormat;
    protected String display;
    protected String tooltip;
    protected int xPosition;
    protected int yPosition;
    protected int hoverableAreaWidth;
    protected int hoverableAreaHeight;
    protected int tooltipWidth;
    protected int tooltipHeight;

    public JRMCoreLabel(String displayFormat, String tooltipFormat, int x, int y) {
        this.displayFormat = displayFormat;
        this.tooltipFormat = tooltipFormat;
        this.xPosition = x;
        this.yPosition = y;
    }

    public JRMCoreLabel(GuiButton button, String name) {
        this.xPosition = button.field_146128_h;
        this.yPosition = button.field_146129_i;
        this.hoverableAreaWidth = button.field_146120_f;
        this.hoverableAreaHeight = button.field_146121_g;
        this.setTooltip(name);
    }

    public JRMCoreLabel(GuiButton button, String displayFormat, String name) {
        this(button, displayFormat, null, name);
    }

    public JRMCoreLabel(GuiButton button, String displayFormat, String tooltipFormat, String name) {
        this.xPosition = button.field_146128_h;
        this.yPosition = button.field_146129_i;
        this.hoverableAreaWidth = button.field_146120_f;
        this.hoverableAreaHeight = button.field_146121_g;
        this.displayFormat = displayFormat;
        this.tooltipFormat = tooltipFormat;
        if (this.tooltipFormat != null) {
            this.tooltipFormat = tooltipFormat.replaceAll("/n", "\n");
        }
        this.setTooltip(name);
    }

    public JRMCoreLabel(String displayText, String tooltipText, int x, int y, int hoverableAreaWidth, int hoverableAreaHeight) {
        this.setTooltip(tooltipText);
        this.setDisplay(displayText);
        this.xPosition = x;
        this.yPosition = y;
        this.hoverableAreaWidth = hoverableAreaWidth;
        this.hoverableAreaHeight = hoverableAreaHeight;
    }

    protected JRMCoreLabel() {
    }

    public JRMCoreLabel updateDisplay(Object ... arguments) {
        this.setDisplay(String.format(this.displayFormat, arguments));
        return this;
    }

    public JRMCoreLabel updateTooltip(Object ... arguments) {
        this.setTooltip(String.format(this.tooltipFormat, arguments));
        return this;
    }

    public JRMCoreLabel setTooltip(String text) {
        this.tooltip = text != null ? text.replaceAll("/n", "\n") : null;
        this.tooltipWidth = 0;
        this.tooltipHeight = 0;
        return this;
    }

    public JRMCoreLabel setDisplay(String text) {
        this.display = text;
        this.hoverableAreaWidth = 0;
        this.hoverableAreaHeight = 0;
        return this;
    }

    public void drawLabel(Minecraft client, int mouseX, int mouseY) {
        client.field_71466_p.func_85187_a(this.display, this.xPosition, this.yPosition, ColorMode.textColor(), ConfigDBCClient.DarkMode);
    }

    protected boolean isHovered(int mouseX, int mouseY) {
        return this.xPosition <= mouseX && this.xPosition + this.hoverableAreaWidth > mouseX && this.yPosition - 1 <= mouseY && this.yPosition + this.hoverableAreaHeight > mouseY;
    }

    @Override
    public void hover(Minecraft client, int mouseX, int mouseY) {
        if (this.tooltip == null) {
            return;
        }
        if (this.display != null && (this.hoverableAreaHeight <= 0 || this.hoverableAreaWidth <= 0)) {
            this.hoverableAreaWidth = client.field_71466_p.func_78256_a(this.display);
            this.hoverableAreaHeight = 8;
        }
        if (this.isHovered(mouseX, mouseY)) {
            client.func_110434_K().func_110577_a(background);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            if (this.tooltipWidth <= 0) {
                String[] lines;
                int maxLineWidth = 0;
                for (String line : lines = this.tooltip.split("\n")) {
                    int lineWidth = client.field_71466_p.func_78256_a(line);
                    maxLineWidth = Math.max(maxLineWidth, lineWidth);
                }
                this.tooltipWidth = Math.min(maxLineWidth, 200);
            }
            List toolTipSplit = client.field_71466_p.func_78271_c(this.tooltip, this.tooltipWidth);
            if (this.tooltipHeight <= 0) {
                this.tooltipHeight = toolTipSplit.size() * 10;
            }
            int tooltipY = mouseY + 10;
            this.func_73729_b(mouseX, tooltipY, 0, 0, this.tooltipWidth + 10, this.tooltipHeight + 10);
            int linesWritten = 0;
            for (String text : toolTipSplit) {
                client.field_71466_p.func_78276_b(text, mouseX + 5, tooltipY + 5 + linesWritten * 10, 0);
                ++linesWritten;
            }
        }
    }
}

