/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.IPos;
import noppes.npcs.api.ITimers;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.entity.data.IPixelmonPlayerData;
import noppes.npcs.api.entity.data.IPlayerMail;
import noppes.npcs.api.gui.ICustomGui;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.overlay.IOverlay;
import noppes.npcs.api.wrapper.ContainerWrapper;
import noppes.npcs.api.wrapper.EntityLivingBaseWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerDialogData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.PlayerSkinData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketAchievement;
import noppes.npcs.packets.client.PacketChat;
import noppes.npcs.packets.client.PacketGuiClose;
import noppes.npcs.packets.client.PacketGuiData;
import noppes.npcs.packets.client.PacketHideAllOverlays;
import noppes.npcs.packets.client.PacketOverlayHide;
import noppes.npcs.packets.client.PacketOverlayShow;
import noppes.npcs.packets.client.PacketPlayMusic;
import noppes.npcs.packets.client.PacketPlaySound;
import noppes.npcs.packets.server.SPacketDimensionTeleport;
import noppes.npcs.shared.client.util.NoppesStringUtils;
import noppes.npcs.util.ValueUtil;

public class PlayerWrapper<T extends ServerPlayerEntity>
extends EntityLivingBaseWrapper<T>
implements IPlayer {
    private IContainer inventory;
    private Object pixelmonPartyStorage;
    private Object pixelmonPCStorage;
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            CompoundNBT compound = this.getStoredCompound();
            if (value instanceof Number) {
                compound.func_74780_a(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.func_74778_a(key, (String)value);
            }
        }

        @Override
        public Object get(String key) {
            CompoundNBT compound = this.getStoredCompound();
            if (!compound.func_74764_b(key)) {
                return null;
            }
            INBT base = compound.func_74781_a(key);
            if (base instanceof NumberNBT) {
                return ((NumberNBT)base).func_150286_g();
            }
            return base.func_150285_a_();
        }

        @Override
        public void remove(String key) {
            CompoundNBT compound = this.getStoredCompound();
            compound.func_82580_o(key);
        }

        @Override
        public boolean has(String key) {
            return this.getStoredCompound().func_74764_b(key);
        }

        @Override
        public void clear() {
            PlayerData data = PlayerData.get((PlayerEntity)PlayerWrapper.this.entity);
            data.scriptStoreddata = new CompoundNBT();
        }

        private CompoundNBT getStoredCompound() {
            PlayerData data = PlayerData.get((PlayerEntity)PlayerWrapper.this.entity);
            return data.scriptStoreddata;
        }

        @Override
        public String[] getKeys() {
            CompoundNBT compound = this.getStoredCompound();
            return compound.func_150296_c().toArray(new String[compound.func_150296_c().size()]);
        }
    };
    private PlayerData data;

    public PlayerWrapper(T player) {
        super(player);
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public String getName() {
        return ((ServerPlayerEntity)this.entity).func_200200_C_().getString();
    }

    @Override
    public String getDisplayName() {
        return ((ServerPlayerEntity)this.entity).func_145748_c_().getString();
    }

    @Override
    public int getHunger() {
        return ((ServerPlayerEntity)this.entity).func_71024_bL().func_75116_a();
    }

    @Override
    public void setHunger(int level) {
        ((ServerPlayerEntity)this.entity).func_71024_bL().func_75114_a(level);
    }

    @Override
    public boolean hasFinishedQuest(int id) {
        PlayerQuestData data = this.getData().questData;
        return data.finishedQuests.containsKey(id);
    }

    @Override
    public boolean hasActiveQuest(int id) {
        PlayerQuestData data = this.getData().questData;
        return data.activeQuests.containsKey(id);
    }

    @Override
    public IQuest[] getActiveQuests() {
        PlayerQuestData data = this.getData().questData;
        ArrayList<IQuest> quests = new ArrayList<IQuest>();
        for (int id : data.activeQuests.keySet()) {
            IQuest quest = QuestController.instance.quests.get(id);
            if (quest == null) continue;
            quests.add(quest);
        }
        return quests.toArray(new IQuest[quests.size()]);
    }

    @Override
    public IQuest[] getFinishedQuests() {
        PlayerQuestData data = this.getData().questData;
        ArrayList<IQuest> quests = new ArrayList<IQuest>();
        for (int id : data.finishedQuests.keySet()) {
            IQuest quest = QuestController.instance.quests.get(id);
            if (quest == null) continue;
            quests.add(quest);
        }
        return quests.toArray(new IQuest[quests.size()]);
    }

    @Override
    public void startQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        QuestData questdata = new QuestData(quest);
        PlayerData data = this.getData();
        data.questData.activeQuests.put(id, questdata);
        Packets.send((ServerPlayerEntity)this.entity, new PacketAchievement((ITextComponent)new TranslationTextComponent("quest.newquest"), (ITextComponent)new TranslationTextComponent(quest.title), 2));
        IFormattableTextComponent text = new TranslationTextComponent("quest.newquest").func_240702_b_(":").func_230529_a_((ITextComponent)new TranslationTextComponent(quest.title));
        Packets.send((ServerPlayerEntity)this.entity, new PacketChat((ITextComponent)text));
        data.updateClient = true;
    }

    @Override
    public void sendNotification(String title, String msg, int type) {
        if (type < 0 || type > 3) {
            throw new CustomNPCsException("Wrong type value given " + type, new Object[0]);
        }
        Packets.send((ServerPlayerEntity)this.entity, new PacketAchievement((ITextComponent)new TranslationTextComponent(title), (ITextComponent)new TranslationTextComponent(msg), type));
    }

    @Override
    public void finishQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = this.getData();
        data.questData.finishedQuests.put(id, System.currentTimeMillis());
        data.updateClient = true;
    }

    @Override
    public void stopQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = this.getData();
        data.questData.activeQuests.remove(id);
        data.updateClient = true;
    }

    @Override
    public void removeQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = this.getData();
        data.questData.activeQuests.remove(id);
        data.questData.finishedQuests.remove(id);
        data.updateClient = true;
    }

    @Override
    public boolean hasReadDialog(int id) {
        PlayerDialogData data = this.getData().dialogData;
        return data.dialogsRead.contains(id);
    }

    @Override
    public void showDialog(int id, String name) {
        Dialog dialog = DialogController.instance.dialogs.get(id);
        if (dialog == null) {
            throw new CustomNPCsException("Unknown Dialog id: " + id, new Object[0]);
        }
        if (!dialog.availability.isAvailable((PlayerEntity)this.entity)) {
            return;
        }
        EntityDialogNpc npc = new EntityDialogNpc((World)this.getWorld().getMCWorld());
        npc.display.setName(name);
        EntityUtil.Copy((LivingEntity)this.entity, (LivingEntity)npc);
        DialogOption option = new DialogOption();
        option.dialogId = id;
        option.title = dialog.title;
        npc.dialogs.put(0, option);
        NoppesUtilServer.openDialog((PlayerEntity)this.entity, npc, dialog);
    }

    public void showDialog(int id, ICustomNpc npc) {
        Dialog dialog = DialogController.instance.dialogs.get(id);
        if (dialog == null) {
            throw new CustomNPCsException("Unknown Dialog id: " + id, new Object[0]);
        }
        if (dialog.availability.isAvailable((PlayerEntity)this.entity)) {
            DialogOption option = new DialogOption();
            option.dialogId = id;
            option.title = dialog.title;
            NoppesUtilServer.openDialog((PlayerEntity)this.entity, (EntityNPCInterface)((Object)npc.getMCEntity()), dialog);
        }
    }

    @Override
    public void addFactionPoints(int faction, int points) {
        PlayerData data = this.getData();
        data.factionData.increasePoints((PlayerEntity)this.entity, faction, points);
        data.updateClient = true;
    }

    @Override
    public int getFactionPoints(int faction) {
        return this.getData().factionData.getFactionPoints((PlayerEntity)this.entity, faction);
    }

    @Override
    public float getRotation() {
        return ((ServerPlayerEntity)this.entity).field_70177_z;
    }

    @Override
    public void setRotation(float rotation) {
        ((ServerPlayerEntity)this.entity).field_70177_z = rotation;
    }

    @Override
    public void message(String message) {
        ((ServerPlayerEntity)this.entity).func_145747_a((ITextComponent)new TranslationTextComponent(NoppesStringUtils.formatText(message, this.entity)), Util.field_240973_b_);
    }

    @Override
    public int getGamemode() {
        return ((ServerPlayerEntity)this.entity).field_71134_c.func_73081_b().func_77148_a();
    }

    @Override
    public void setGamemode(int type) {
        ((ServerPlayerEntity)this.entity).func_71033_a(GameType.func_77146_a((int)type));
    }

    @Override
    public int inventoryItemCount(IItemStack item) {
        int count = 0;
        for (int i = 0; i < ((ServerPlayerEntity)this.entity).field_71071_by.func_70302_i_(); ++i) {
            ItemStack is = ((ServerPlayerEntity)this.entity).field_71071_by.func_70301_a(i);
            if (!this.isItemEqual(item.getMCItemStack(), is)) continue;
            count += is.func_190916_E();
        }
        return count;
    }

    private boolean isItemEqual(ItemStack stack, ItemStack other) {
        return !other.func_190926_b() && stack.func_77973_b() == other.func_77973_b();
    }

    @Override
    public int inventoryItemCount(String id) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
        if (item == null) {
            throw new CustomNPCsException("Unknown item id: " + id, new Object[0]);
        }
        return this.inventoryItemCount(NpcAPI.Instance().getIItemStack(new ItemStack((IItemProvider)item, 1)));
    }

    @Override
    public IContainer getInventory() {
        if (this.inventory == null) {
            this.inventory = new ContainerWrapper((IInventory)((ServerPlayerEntity)this.entity).field_71071_by);
        }
        return this.inventory;
    }

    @Override
    public IItemStack getInventoryHeldItem() {
        return NpcAPI.Instance().getIItemStack(((ServerPlayerEntity)this.entity).field_71071_by.func_70445_o());
    }

    @Override
    public boolean removeItem(IItemStack item, int amount) {
        int count = this.inventoryItemCount(item);
        if (amount > count) {
            return false;
        }
        if (count == amount) {
            this.removeAllItems(item);
        } else {
            for (int i = 0; i < ((ServerPlayerEntity)this.entity).field_71071_by.func_70302_i_(); ++i) {
                ItemStack is = ((ServerPlayerEntity)this.entity).field_71071_by.func_70301_a(i);
                if (!this.isItemEqual(item.getMCItemStack(), is)) continue;
                if (amount < is.func_190916_E()) {
                    is.func_77979_a(amount);
                    break;
                }
                ((ServerPlayerEntity)this.entity).field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                amount -= is.func_190916_E();
            }
        }
        this.updatePlayerInventory();
        return true;
    }

    @Override
    public boolean removeItem(String id, int amount) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
        if (item == null) {
            throw new CustomNPCsException("Unknown item id: " + id, new Object[0]);
        }
        return this.removeItem(NpcAPI.Instance().getIItemStack(new ItemStack((IItemProvider)item, 1)), amount);
    }

    @Override
    public boolean giveItem(IItemStack item) {
        ItemStack mcItem = item.getMCItemStack();
        if (mcItem.func_190926_b()) {
            return false;
        }
        boolean bo = ((ServerPlayerEntity)this.entity).field_71071_by.func_70441_a(mcItem.func_77946_l());
        if (bo) {
            NoppesUtilServer.playSound((LivingEntity)this.entity, SoundEvents.field_187638_cR, 0.2f, ((((ServerPlayerEntity)this.entity).func_70681_au().nextFloat() - ((ServerPlayerEntity)this.entity).func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.updatePlayerInventory();
        }
        return bo;
    }

    @Override
    public boolean giveItem(String id, int amount) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
        if (item == null) {
            return false;
        }
        ItemStack mcStack = new ItemStack((IItemProvider)item);
        IItemStack itemStack = NpcAPI.Instance().getIItemStack(mcStack);
        itemStack.setStackSize(amount);
        return this.giveItem(itemStack);
    }

    @Override
    public void updatePlayerInventory() {
        ((ServerPlayerEntity)this.entity).field_71069_bz.func_75142_b();
        ((ServerPlayerEntity)this.entity).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-2, ((ServerPlayerEntity)this.entity).field_71071_by.field_70461_c, ((ServerPlayerEntity)this.entity).field_71071_by.func_70301_a(((ServerPlayerEntity)this.entity).field_71071_by.field_70461_c)));
        PlayerQuestData playerdata = this.getData().questData;
        playerdata.checkQuestCompletion((PlayerEntity)this.entity, 0);
    }

    @Override
    public IBlock getSpawnPoint() {
        BlockPos pos = ((ServerPlayerEntity)this.entity).func_213374_dv().orElse(null);
        if (pos == null) {
            return this.getWorld().getSpawnPoint();
        }
        return NpcAPI.Instance().getIBlock(((ServerPlayerEntity)this.entity).field_70170_p, pos);
    }

    @Override
    public void setSpawnPoint(IBlock block) {
        this.setSpawnpoint(block.getX(), block.getY(), block.getZ());
    }

    @Override
    public void setSpawnpoint(int x, int y, int z) {
        x = ValueUtil.CorrectInt(x, -30000000, 30000000);
        z = ValueUtil.CorrectInt(z, -30000000, 30000000);
        y = ValueUtil.CorrectInt(y, 0, 256);
        ((ServerPlayerEntity)this.entity).func_242111_a(this.getWorld().getMCWorld().func_234923_W_(), new BlockPos(x, y, z), 0.0f, true, false);
    }

    @Override
    public void resetSpawnpoint() {
        ((ServerPlayerEntity)this.entity).func_242111_a(this.getWorld().getMCWorld().func_234923_W_(), null, 0.0f, true, false);
    }

    @Override
    public void removeAllItems(IItemStack item) {
        for (int i = 0; i < ((ServerPlayerEntity)this.entity).field_71071_by.func_70302_i_(); ++i) {
            ItemStack is = ((ServerPlayerEntity)this.entity).field_71071_by.func_70301_a(i);
            if (!is.func_77969_a(item.getMCItemStack())) continue;
            ((ServerPlayerEntity)this.entity).field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    @Override
    public boolean hasAdvancement(String achievement) {
        Advancement advancement = ((ServerPlayerEntity)this.entity).func_184102_h().func_191949_aK().func_192778_a(new ResourceLocation(achievement));
        if (advancement == null) {
            throw new CustomNPCsException("Advancement doesnt exist", new Object[0]);
        }
        AdvancementProgress progress = ((ServerPlayerEntity)this.entity).func_184102_h().func_184103_al().func_192054_h((ServerPlayerEntity)this.entity).func_192747_a(advancement);
        return progress.func_192105_a();
    }

    @Override
    public int getExpLevel() {
        return ((ServerPlayerEntity)this.entity).field_71068_ca;
    }

    @Override
    public void setExpLevel(int level) {
        ((ServerPlayerEntity)this.entity).func_82242_a(level - ((ServerPlayerEntity)this.entity).field_71068_ca);
    }

    @Override
    public void setPosition(double x, double y, double z) {
        SPacketDimensionTeleport.teleportPlayer((ServerPlayerEntity)this.entity, x, y, z, (RegistryKey<World>)((ServerPlayerEntity)this.entity).field_70170_p.func_234923_W_());
    }

    @Override
    public void setPos(IPos pos) {
        SPacketDimensionTeleport.teleportPlayer((ServerPlayerEntity)this.entity, pos.getX(), pos.getY(), pos.getZ(), (RegistryKey<World>)((ServerPlayerEntity)this.entity).field_70170_p.func_234923_W_());
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 1 || super.typeOf(type);
    }

    @Override
    public boolean hasPermission(String permission) {
        return CustomNpcsPermissions.hasPermissionString((PlayerEntity)this.entity, permission);
    }

    @Override
    public IPixelmonPlayerData getPixelmonData() {
        if (!PixelmonHelper.Enabled) {
            throw new CustomNPCsException("Pixelmon isnt installed", new Object[0]);
        }
        return new IPixelmonPlayerData(){

            @Override
            public Object getParty() {
                if (PlayerWrapper.this.pixelmonPartyStorage == null) {
                    PlayerWrapper.this.pixelmonPartyStorage = PixelmonHelper.getParty((PlayerEntity)PlayerWrapper.this.entity);
                }
                return PlayerWrapper.this.pixelmonPartyStorage;
            }

            @Override
            public Object getPC() {
                if (PlayerWrapper.this.pixelmonPCStorage == null) {
                    PlayerWrapper.this.pixelmonPCStorage = PixelmonHelper.getPc((PlayerEntity)PlayerWrapper.this.entity);
                }
                return PlayerWrapper.this.pixelmonPCStorage;
            }
        };
    }

    private PlayerData getData() {
        if (this.data == null) {
            this.data = PlayerData.get((PlayerEntity)this.entity);
        }
        return this.data;
    }

    @Override
    public ITimers getTimers() {
        return this.getData().timers;
    }

    @Override
    public void removeDialog(int id) {
        PlayerData data = this.getData();
        data.dialogData.dialogsRead.remove(id);
        data.updateClient = true;
    }

    @Override
    public void addDialog(int id) {
        PlayerData data = this.getData();
        data.dialogData.dialogsRead.add(id);
        data.updateClient = true;
    }

    @Override
    public void closeGui() {
        ((ServerPlayerEntity)this.entity).func_71053_j();
        Packets.send((ServerPlayerEntity)this.entity, new PacketGuiClose(new CompoundNBT()));
    }

    @Override
    public int factionStatus(int factionId) {
        Faction faction = FactionController.instance.getFaction(factionId);
        if (faction == null) {
            throw new CustomNPCsException("Unknown faction: " + factionId, new Object[0]);
        }
        return faction.playerStatus(this);
    }

    @Override
    public void kick(String message) {
        ((ServerPlayerEntity)this.entity).field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent(message));
    }

    @Override
    public boolean canQuestBeAccepted(int questId) {
        return PlayerQuestController.canQuestBeAccepted((PlayerEntity)this.entity, questId);
    }

    @Override
    public void showCustomGui(ICustomGui gui) {
        NoppesUtilServer.openContainerGui((ServerPlayerEntity)this.getMCEntity(), EnumGuiType.CustomGui, buf -> buf.writeInt(gui.getSlots().size()));
        ((ContainerCustomGui)((ServerPlayerEntity)this.getMCEntity()).field_71070_bA).setGui((CustomGuiWrapper)gui, (PlayerEntity)this.entity);
        Packets.sendDelayed((ServerPlayerEntity)this.getMCEntity(), new PacketGuiData(((CustomGuiWrapper)gui).toNBT()), 100);
    }

    @Override
    public ICustomGui getCustomGui() {
        if (((ServerPlayerEntity)this.entity).field_71070_bA instanceof ContainerCustomGui) {
            return ((ContainerCustomGui)((ServerPlayerEntity)this.entity).field_71070_bA).customGui;
        }
        return null;
    }

    @Override
    public void clearData() {
        PlayerData data = this.getData();
        data.setNBT(new CompoundNBT());
        data.save(true);
    }

    @Override
    public IContainer getOpenContainer() {
        return NpcAPI.Instance().getIContainer(((ServerPlayerEntity)this.entity).field_71070_bA);
    }

    @Override
    public void playSound(String sound, float volume, float pitch) {
        BlockPos pos = ((ServerPlayerEntity)this.entity).func_233580_cy_();
        Packets.send((ServerPlayerEntity)this.entity, new PacketPlaySound(sound, pos, volume, pitch));
    }

    @Override
    public void playMusic(String sound, boolean background, boolean loops) {
        Packets.send((ServerPlayerEntity)this.entity, new PacketPlayMusic(sound, !background, loops));
    }

    @Override
    public void sendMail(IPlayerMail mail) {
        PlayerData data = this.getData();
        data.mailData.playermail.add(((PlayerMail)mail).copy());
        data.save(false);
    }

    @Override
    public void trigger(int id, Object ... arguments) {
        EventHooks.onScriptTriggerEvent(PlayerData.get((PlayerEntity)((PlayerEntity)this.entity)).scriptData, id, this.getWorld(), this.getPos(), null, arguments);
    }

    @Override
    public void showOverlay(IOverlay overlay) {
        Packets.send((ServerPlayerEntity)this.entity, new PacketOverlayShow(overlay.toNbt()));
    }

    @Override
    public void hideOverlay(int id) {
        Packets.send((ServerPlayerEntity)this.entity, new PacketOverlayHide(id));
    }

    @Override
    public void hideAllOverlays() {
        Packets.send((ServerPlayerEntity)this.entity, new PacketHideAllOverlays(true));
    }

    public PlayerSkinData getSkin() {
        return PlayerData.get((PlayerEntity)((PlayerEntity)this.entity)).skinData;
    }
}

