/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import noppes.npcs.CustomBlocks;
import noppes.npcs.blocks.BlockBorder;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.controllers.data.Availability;

public class TileBorder
extends TileNpcEntity
implements com.google.common.base.Predicate,
ITickableTileEntity {
    public Availability availability = new Availability();
    public AxisAlignedBB boundingbox;
    public int rotation = 0;
    public int height = 10;
    public String message = "availability.areaNotAvailble";

    public TileBorder() {
        super(CustomBlocks.tile_border);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.readExtraNBT(compound);
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)CustomBlocks.border.func_176223_P().func_206870_a((Property)BlockBorder.ROTATION, (Comparable)Integer.valueOf(this.rotation)));
        }
    }

    public void readExtraNBT(CompoundNBT compound) {
        this.availability.load(compound.func_74775_l("BorderAvailability"));
        this.rotation = compound.func_74762_e("BorderRotation");
        this.height = compound.func_74762_e("BorderHeight");
        this.message = compound.func_74779_i("BorderMessage");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeExtraNBT(compound);
        return super.func_189515_b(compound);
    }

    public void writeExtraNBT(CompoundNBT compound) {
        compound.func_218657_a("BorderAvailability", (INBT)this.availability.save(new CompoundNBT()));
        compound.func_74768_a("BorderRotation", this.rotation);
        compound.func_74768_a("BorderHeight", this.height);
        compound.func_74778_a("BorderMessage", this.message);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        AxisAlignedBB box = new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + this.height + 1), (double)(this.field_174879_c.func_177952_p() + 1));
        List list = this.field_145850_b.func_175647_a(Entity.class, box, (Predicate)((Object)this));
        for (Entity entity : list) {
            if (entity instanceof EnderPearlEntity) {
                EnderPearlEntity pearl = (EnderPearlEntity)entity;
                if (!(pearl.func_234616_v_() instanceof PlayerEntity) || this.availability.isAvailable((PlayerEntity)pearl.func_234616_v_())) continue;
                entity.field_70128_L = true;
                continue;
            }
            PlayerEntity player = (PlayerEntity)entity;
            if (this.availability.isAvailable(player)) continue;
            BlockPos pos2 = new BlockPos((Vector3i)this.field_174879_c);
            if (this.rotation == 2) {
                pos2 = pos2.func_177968_d();
            } else if (this.rotation == 0) {
                pos2 = pos2.func_177978_c();
            } else if (this.rotation == 1) {
                pos2 = pos2.func_177974_f();
            } else if (this.rotation == 3) {
                pos2 = pos2.func_177976_e();
            }
            while (!this.field_145850_b.func_175623_d(pos2)) {
                pos2 = pos2.func_177984_a();
            }
            player.func_70634_a((double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o(), (double)pos2.func_177952_p() + 0.5);
            if (this.message.isEmpty()) continue;
            player.func_146105_b((ITextComponent)new TranslationTextComponent(this.message), true);
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT compound) {
        this.rotation = compound.func_74762_e("Rotation");
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("x", this.field_174879_c.func_177958_n());
        compound.func_74768_a("y", this.field_174879_c.func_177956_o());
        compound.func_74768_a("z", this.field_174879_c.func_177952_p());
        compound.func_74768_a("Rotation", this.rotation);
        return compound;
    }

    public boolean isEntityApplicable(Entity var1) {
        return var1 instanceof ServerPlayerEntity || var1 instanceof EnderPearlEntity;
    }

    public boolean apply(Object ob) {
        return this.isEntityApplicable((Entity)ob);
    }
}

