/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class FontImpl {
    private final FontRenderer font;
    private final float scale;
    private final float lineHeight;

    public FontImpl(Object impl, float size) {
        this.font = (FontRenderer)impl;
        this.scale = size / 9.0f;
        Objects.requireNonNull(this.font);
        this.lineHeight = this._i2f(9);
    }

    protected static FontRenderer defaultFont() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public float lineHeight() {
        return this.lineHeight;
    }

    public FontRenderer impl() {
        return this.font;
    }

    public float _getScale() {
        return this.scale;
    }

    public float _getTextWidth(IReorderingProcessor value) {
        return this._i2f(this.font.func_243245_a(value));
    }

    public String _getTextByWidth(String text, float width) {
        return this._getTextByWidth(text, width, false);
    }

    public String _getTextByWidth(String text, float width, boolean bl) {
        return this.font.func_238413_a_(text, this._f2i(width), bl);
    }

    public Style _getStyleByWidth(IReorderingProcessor value, float width) {
        return this.font.func_238420_b_().func_243239_a(value, this._f2i(width));
    }

    public <T> List<T> _splitLines(String value, float maxWidth, boolean bl, SliceTransform<T> transformer) {
        ArrayList results = new ArrayList();
        this.font.func_238420_b_().func_238353_a_(value, this._f2i(maxWidth), Style.field_240709_b_, bl, (style, bi, ei) -> results.add(transformer.accept(value.substring(bi, ei), bi, ei)));
        return results;
    }

    public <T> List<T> _splitLines(ITextComponent value, float maxWidth, boolean bl, Function<IReorderingProcessor, T> transformer) {
        ArrayList<T> results = new ArrayList<T>();
        for (IReorderingProcessor seq : this.font.func_238425_b_((ITextProperties)value, this._f2i(maxWidth))) {
            results.add(transformer.apply(seq));
        }
        return results;
    }

    private float _i2f(int size) {
        return (float)size * this.scale;
    }

    private int _f2i(float size) {
        return (int)(size / this.scale);
    }

    public static interface SliceTransform<T> {
        public T accept(String var1, int var2, int var3);
    }
}

