/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.impl.AppearanceImpl;
import com.apple.library.impl.DelegateImpl;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIMenuControllerDelegate;
import com.apple.library.uikit.UIMenuItem;
import com.apple.library.uikit.UIMenuPopoverView;
import com.apple.library.uikit.UIScrollView;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import moe.plushie.armourers_workshop.init.ModTextures;

public class UIMenuController {
    private static final UIMenuController INSTANCE = new UIMenuController();
    private UIMenuPopoverView popoverView;
    private CGAffineTransform transform = CGAffineTransform.IDENTITY;
    private Collection<UIMenuItem> menuItems;
    protected final DelegateImpl<UIMenuControllerDelegate> delegate = DelegateImpl.of(new UIMenuControllerDelegate(){});

    public static UIMenuController getInstance() {
        return INSTANCE;
    }

    public void showMenu(UIView fromView, CGPoint fromPoint) {
        UIWindow window = fromView.window();
        if (window == null) {
            return;
        }
        MenuListView listView = new MenuListView(this, this.menuItems());
        CGSize size = listView.sizeThatFits(window.bounds().size());
        listView.setBounds(new CGRect(CGPoint.ZERO, size));
        listView.setAutoresizingMask(36);
        listView.setContents(UIImage.of(ModTextures.MENUS).uv(0.0f, 0.0f).fixed(44.0f, 44.0f).clip(4.0f, 4.0f, 4.0f, 4.0f).build());
        listView.setTransform(this.transform());
        CGSize size1 = size.applying(this.transform());
        CGPoint center = fromView.convertPointToView(fromPoint, window).copy();
        if (center.x + size1.width > window.bounds().getMaxX()) {
            center.x -= size1.width;
        }
        center.x += size1.width / 2.0f;
        center.y += size1.height / 2.0f;
        listView.setCenter(center);
        this.popoverView = new UIMenuPopoverView();
        this.popoverView.setBackgroundColor(null);
        this.popoverView.setContentView(listView);
        this.popoverView.showInView(fromView);
        this.delegate.invoker().menuControllerDidShow(this);
    }

    public void dismissMenu() {
        this.delegate.invoker().menuControllerDidDismiss(this);
        if (this.popoverView != null) {
            this.popoverView.dismiss();
        }
    }

    public UIMenuControllerDelegate delegate() {
        return this.delegate.get();
    }

    public void setDelegate(UIMenuControllerDelegate delegate) {
        this.delegate.set(delegate);
    }

    public Collection<UIMenuItem> menuItems() {
        return this.menuItems;
    }

    public void setMenuItems(Collection<UIMenuItem> menuItems) {
        this.menuItems = menuItems;
    }

    public CGAffineTransform transform() {
        return this.transform;
    }

    public void setTransform(CGAffineTransform transform) {
        this.transform = transform;
    }

    protected void selectAction(UIMenuItem menuItem, UIEvent event) {
        if (this.delegate.invoker().menuControllerShouldSelectItem(this, menuItem)) {
            menuItem.perform(event);
            this.delegate.invoker().menuControllerDidSelectItem(this, menuItem);
            this.dismissMenu();
        }
    }

    protected static class MenuListView
    extends UIScrollView {
        private final UIMenuController menuController;
        private final AtomicInteger lastGroup = new AtomicInteger();
        private final ArrayList<UIView> contentCells = new ArrayList();

        public MenuListView(UIMenuController menuController, Collection<UIMenuItem> menuItems) {
            super(CGRect.ZERO);
            this.menuController = menuController;
            this.setContentInsets(new UIEdgeInsets(4.0f, 4.0f, 4.0f, 4.0f));
            menuItems.stream().sorted(Comparator.comparingInt(UIMenuItem::group)).forEachOrdered(menuItem -> {
                if (!this.contentCells.isEmpty() && this.lastGroup.get() != menuItem.group()) {
                    MenuSeparatorView separatorView = new MenuSeparatorView();
                    this.addSubview(separatorView);
                    this.contentCells.add(separatorView);
                }
                MenuCell cell = new MenuCell(menuController, (UIMenuItem)menuItem);
                this.addSubview(cell);
                this.contentCells.add(cell);
                this.lastGroup.set(menuItem.group());
            });
        }

        @Override
        public void mouseUp(UIEvent event) {
        }

        @Override
        public void mouseMoved(UIEvent event) {
        }

        @Override
        public void mouseDown(UIEvent event) {
        }

        @Override
        public void sizeToFit() {
            UIEdgeInsets edg = this.contentInsets();
            float x = edg.left;
            float y = edg.top;
            float maxWidth = 0.0f;
            for (UIView cell : this.contentCells) {
                cell.sizeToFit();
                CGSize size = cell.bounds().size();
                cell.setFrame(new CGRect(x, y, size.width, size.height));
                y += size.height;
                maxWidth = Math.max(maxWidth, size.width);
            }
            for (UIView cell : this.contentCells) {
                CGRect frame = cell.frame();
                cell.setFrame(new CGRect(frame.x, frame.y, maxWidth, frame.height));
            }
            this.setBounds(new CGRect(0.0f, 0.0f, x += maxWidth + edg.right, y += edg.bottom));
            this.setContentSize(new CGSize(x, y));
        }

        @Override
        public CGSize sizeThatFits(CGSize size) {
            this.sizeToFit();
            return this.contentSize();
        }
    }

    protected static class MenuSeparatorView
    extends UIView {
        public MenuSeparatorView() {
            super(new CGRect(0.0f, 0.0f, 16.0f, 7.0f));
            UIView lineView = new UIView(this.bounds().insetBy(3.0f, 5.0f, 3.5f, 5.0f));
            lineView.setBackgroundColor(AppearanceImpl.MENU_SEPARATOR_COLOR);
            lineView.setAutoresizingMask(34);
            this.addSubview(lineView);
        }

        @Override
        public CGSize sizeThatFits(CGSize size) {
            return new CGSize(16.0f, 7.0f);
        }
    }

    protected static class MenuCell
    extends UIButton {
        private final UIMenuController menuController;
        private final UIMenuItem menuItem;

        public MenuCell(UIMenuController menuController, UIMenuItem menuItem) {
            super(CGRect.ZERO);
            this.menuController = menuController;
            this.menuItem = menuItem;
            this.titleView().setShadowColor(null);
            this.setTitle(menuItem.title(), 7);
            this.setTitleColor(AppearanceImpl.MENU_NORMAL_TEXT_COLOR, 0);
            this.setTitleColor(AppearanceImpl.MENU_HIGHLIGHTED_TEXT_COLOR, 1);
            this.setTitleColor(AppearanceImpl.MENU_DISABLED_TEXT_COLOR, 4);
            this.setBackgroundImage(UIImage.of(ModTextures.MENUS).uv(0.0f, 44.0f).fixed(44.0f, 22.0f).clip(4.0f, 4.0f, 4.0f, 4.0f).build(), 1);
            this.setHorizontalAlignment(NSTextAlignment.Horizontal.LEFT);
            this.setContentEdgeInsets(new UIEdgeInsets(4.0f, 8.0f, 4.0f, 8.0f));
            this.setEnabled(menuItem.isEnabled());
        }

        @Override
        public void mouseDown(UIEvent event) {
            super.mouseDown(event);
            if (this.menuItem != null && this.menuItem.isEnabled()) {
                this.menuController.selectAction(this.menuItem, event);
            }
        }
    }
}

