/*
 * Decompiled with CFR 0.152.
 */
package extensions.net.minecraft.client.renderer.entity.EntityRenderDispatcher;

import manifold.ext.rt.api.Extension;
import manifold.ext.rt.api.ThisClass;
import moe.plushie.armourers_workshop.compatibility.client.AbstractEntityRendererLayerProvider;
import moe.plushie.armourers_workshop.compatibility.client.AbstractEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;

@Extension
public class EntityLayerProvider {
    public static <E extends LivingEntity, Q extends EntityModel<E>> AbstractEntityRendererLayerProvider createLayerProvider(@ThisClass Class<?> clazz, final LivingRenderer<E, Q> renderer) {
        return new AbstractEntityRendererLayerProvider(){

            @Override
            public <T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>> LayerRenderer<T, M> createHumanoidArmorLayer(AbstractEntityRendererProviderImpl.Context context, A innerModel, A outerModel) {
                return new BipedArmorLayer((IEntityRenderer)ObjectUtils.unsafeCast(renderer), innerModel, outerModel);
            }

            @Override
            public <T extends LivingEntity, M extends EntityModel<T>> LayerRenderer<T, M> createItemInHandLayer(AbstractEntityRendererProviderImpl.Context context) {
                return new HeldItemLayer((IEntityRenderer)ObjectUtils.unsafeCast(renderer));
            }

            @Override
            public <T extends LivingEntity, M extends EntityModel<T>> LayerRenderer<T, M> createElytraLayer(AbstractEntityRendererProviderImpl.Context context) {
                return new ElytraLayer((IEntityRenderer)ObjectUtils.unsafeCast(renderer));
            }

            @Override
            public <T extends LivingEntity, M extends EntityModel<T>> LayerRenderer<T, M> createCustomHeadLayer(AbstractEntityRendererProviderImpl.Context context) {
                return new HeadLayer((IEntityRenderer)ObjectUtils.unsafeCast(renderer));
            }
        };
    }
}

