/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UIView;
import com.google.common.base.Objects;
import moe.plushie.armourers_workshop.api.data.IDataProperty;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentConnector;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentEditor;
import moe.plushie.armourers_workshop.builder.data.properties.DataProperty;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentSettings;
import moe.plushie.armourers_workshop.utils.ObjectUtils;

public class AdvancedLeftCardPanel
extends UIView {
    private DocumentConnector connector;
    private final UITextField nameTextField = new UITextField(new CGRect(10.0f, 28.0f, 180.0f, 16.0f));
    private final UITextField flavourTextField = new UITextField(new CGRect(10.0f, 60.0f, 180.0f, 16.0f));

    public AdvancedLeftCardPanel(DocumentEditor editor, CGRect frame) {
        super(frame);
        this.connector = editor.getConnector();
        this.setup();
    }

    private void setup() {
        this.setupLabel(10, 18, "armourer.main.label.itemName");
        this.setupLabel(10, 50, "armourer.main.label.flavour");
        this.setupTextField(this.nameTextField, "", "outfit-maker.skinName");
        this.setupTextField(this.flavourTextField, "", "outfit-maker.skinFlavour");
        this.nameTextField.addTarget(this.connector.itemName, UIControl.Event.EDITING_DID_BEGIN, (it, ctr) -> it.beginEditing());
        this.nameTextField.addTarget(this.connector.itemName, UIControl.Event.EDITING_DID_END, (it, ctr) -> it.endEditing());
        this.nameTextField.addTarget(this.connector.itemName, UIControl.Event.VALUE_CHANGED, (it, ctr) -> {
            UITextField textField = (UITextField)ctr;
            it.set(textField.text());
        });
        this.flavourTextField.addTarget(this.connector.itemFlavour, UIControl.Event.EDITING_DID_BEGIN, (it, ctr) -> it.beginEditing());
        this.flavourTextField.addTarget(this.connector.itemFlavour, UIControl.Event.EDITING_DID_END, (it, ctr) -> it.endEditing());
        this.flavourTextField.addTarget(this.connector.itemFlavour, UIControl.Event.VALUE_CHANGED, (it, ctr) -> {
            UITextField textField = (UITextField)ctr;
            it.set(textField.text());
        });
        float height = this.bounds().height;
        float width = this.bounds().width;
        this.setupCheckBox(10.0f, height - 30.0f, width - 20.0f, "armourer.displaySettings.showOrigin", this.connector.registerSettings(DataProperty::new, SkinDocumentSettings::showsOrigin, SkinDocumentSettings::setShowsOrigin));
        this.setupCheckBox(10.0f, height - 20.0f, width - 20.0f, "armourer.displaySettings.showHelper", this.connector.registerSettings(DataProperty::new, SkinDocumentSettings::showsHelperModel, SkinDocumentSettings::setShowsHelperModel));
        this.connector.itemName.addObserver(newValue -> {
            String oldValue = this.nameTextField.text();
            if (!Objects.equal((Object)oldValue, (Object)newValue)) {
                this.nameTextField.setText((String)newValue);
            }
        });
        this.connector.itemFlavour.addObserver(newValue -> {
            String oldValue = this.flavourTextField.text();
            if (!Objects.equal((Object)oldValue, (Object)newValue)) {
                this.flavourTextField.setText((String)newValue);
            }
        });
    }

    private void setupLabel(int x, int y, String key) {
        UILabel label = new UILabel(new CGRect(x, y, this.bounds().getWidth(), 9.0f));
        label.setText(NSString.localizedString(key, new Object[0]));
        label.setTextColor(UIColor.WHITE);
        this.addSubview(label);
    }

    private void setupTextField(UITextField textField, String value, String placeholderKey) {
        textField.setMaxLength(40);
        textField.setText(value);
        textField.setPlaceholder(NSString.localizedString(placeholderKey, new Object[0]));
        this.addSubview(textField);
    }

    private void setupCheckBox(float x, float y, float width, String key, IDataProperty<Boolean> property) {
        UICheckBox checkBox = new UICheckBox(new CGRect(x, y, width, 10.0f));
        checkBox.setTitle(NSString.localizedString(key, new Object[0]));
        checkBox.setTitleColor(UIColor.WHITE);
        checkBox.setAutoresizingMask(10);
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> {
            UICheckBox checkBox1 = (UICheckBox)ObjectUtils.unsafeCast(c);
            property.set(checkBox1.isSelected());
        });
        this.addSubview(checkBox);
        property.addObserver(checkBox::setSelected);
    }
}

