/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.painting.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.builder.item.AbstractColoredToolItem;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.init.ModSounds;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;

public class BurnToolItem
extends AbstractColoredToolItem
implements IBlockPaintViewer {
    public BurnToolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.FULL_BLOCK_MODE);
        builder.accept(PaintingToolOptions.INTENSITY);
    }

    @Override
    public IPaintToolAction createPaintToolAction(ItemUseContext context) {
        int intensity = (Integer)PaintingToolOptions.INTENSITY.get(context.func_195996_i());
        return new CubePaintingEvent.BrightnessAction(-intensity);
    }

    @Override
    public void appendSettingHoverText(ItemStack itemStack, List<ITextComponent> tooltips) {
        int intensity = (Integer)PaintingToolOptions.INTENSITY.get(itemStack);
        tooltips.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.intensity", intensity));
        super.appendSettingHoverText(itemStack, tooltips);
    }

    @Override
    public IRegistryKey<SoundEvent> getItemSoundEvent(ItemUseContext context) {
        return ModSounds.BURN;
    }
}

