/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.init.client.EpicFlightWardrobeHandler;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.FirstPersonRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@Pseudo
@Mixin(value={PatchedLivingEntityRenderer.class})
public abstract class ForgeEpicFightRendererMixin {
    private static final FloatBuffer AW_MAT_BUFFER3 = ObjectUtils.createFloatBuffer(16);
    private static final FloatBuffer AW_MAT_BUFFER4 = ObjectUtils.createFloatBuffer(16);
    private Armature lastApplyArmature;

    @Inject(method={"mulPoseStack"}, at={@At(value="HEAD")}, remap=false)
    public void aw$mulPoseStack(MatrixStack poseStack, Armature armature, LivingEntity entityIn, LivingEntityPatch<?> entityPatch, float partialTicks, CallbackInfo callbackInfo) {
        this.lastApplyArmature = armature;
    }

    @Inject(method={"renderLayer"}, at={@At(value="HEAD")}, remap=false)
    public void aw$renderLayerPre(LivingRenderer<?, ?> renderer, LivingEntityPatch<?> entityPatch, LivingEntity entityIn, OpenMatrix4f[] poses, IRenderTypeBuffer buffers, MatrixStack poseStack, int packedLightIn, float partialTicks, CallbackInfo callbackInfo) {
        Armature armature = this.lastApplyArmature;
        if (armature == null) {
            return;
        }
        boolean isFirstPersonRenderer = ObjectUtils.safeCast(this, FirstPersonRenderer.class) != null;
        EpicFlightWardrobeHandler.onRenderLivingPre(entityIn, partialTicks, packedLightIn, poseStack, buffers, renderer, isFirstPersonRenderer, name -> {
            Joint joint = armature.searchJointByName(name);
            if (joint == null) {
                return IJointTransform.NONE;
            }
            OpenMatrix4f jointMatrix = poses[joint.getId()];
            OpenMatrix4f jointNormalMatrix = jointMatrix.removeTranslation();
            return poseStack1 -> {
                jointMatrix.store(AW_MAT_BUFFER4);
                jointNormalMatrix.store(AW_MAT_BUFFER3);
                AW_MAT_BUFFER3.position(0);
                AW_MAT_BUFFER4.position(0);
                poseStack1.multiply(EpicFlightWardrobeHandler.convertPoseMatrix(AW_MAT_BUFFER4));
                poseStack1.multiply(EpicFlightWardrobeHandler.convertNormalMatrix(AW_MAT_BUFFER3));
            };
        });
    }

    @Inject(method={"renderLayer"}, at={@At(value="RETURN")}, remap=false)
    public void aw$renderLayerPost(LivingRenderer<?, ?> renderer, LivingEntityPatch<?> entityPatch, LivingEntity entityIn, OpenMatrix4f[] poses, IRenderTypeBuffer buffers, MatrixStack poseStack, int packedLightIn, float partialTicks, CallbackInfo callbackInfo) {
        EpicFlightWardrobeHandler.onRenderLivingPost(entityIn, partialTicks, packedLightIn, poseStack, buffers, renderer);
    }

    @Inject(method={"getRenderType"}, at={@At(value="RETURN")}, remap=false, cancellable=true)
    public void aw$getRenderType(LivingEntity entityIn, LivingEntityPatch<?> entityPatch, LivingRenderer<?, ?> renderer, boolean isVisible, boolean isVisibleToPlayer, boolean isGlowing, CallbackInfoReturnable<RenderType> callbackInfo) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entityIn);
        if (renderData != null && renderData.getOverriddenManager().overrideAnyModel()) {
            callbackInfo.setReturnValue(null);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    public void aw$init(CallbackInfo callbackInfo) {
        EpicFlightWardrobeHandler.onSetup();
    }
}

