/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.core.armature.ArmatureBuilder;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;

public abstract class ArmatureManager {
    private final HashMap<ResourceLocation, ArmatureBuilder> pendingBuilders = new HashMap();
    private final ArrayList<ArmatureBuilder> defaultBuilders = new ArrayList();
    private final HashMap<String, ArrayList<ArmatureBuilder>> modelBuilders = new HashMap();
    private final HashMap<IEntityTypeProvider<?>, ArmatureBuilder> entityBuilders = new HashMap();
    private int version = 0;

    protected abstract ArmatureBuilder createBuilder(ResourceLocation var1);

    public void clear() {
        this.pendingBuilders.clear();
    }

    public void append(IDataPackObject object, ResourceLocation location) {
        ArmatureBuilder builder = this.createBuilder(location);
        this.pendingBuilders.put(location, builder);
        builder.load(object);
    }

    public void freeze() {
        HashMap<ResourceLocation, ArmatureBuilder> builders1 = new HashMap<ResourceLocation, ArmatureBuilder>();
        this.pendingBuilders.forEach((name, builder) -> {
            ArmatureBuilder parent;
            ArrayList<ArmatureBuilder> chain = new ArrayList<ArmatureBuilder>();
            chain.add((ArmatureBuilder)builder);
            while (builder.getParent() != null && (parent = this.pendingBuilders.get(builder.getParent())) != null) {
                chain.add(0, parent);
                builder = parent;
            }
            if (chain.size() > 1) {
                ArmatureBuilder builder1 = this.createBuilder((ResourceLocation)name);
                builder1.load(chain);
                builder = builder1;
            }
            builders1.put((ResourceLocation)name, (ArmatureBuilder)builder);
        });
        this.pendingBuilders.clear();
        builders1.forEach((name, builder) -> {
            ArrayList<String> models;
            int used = 0;
            List<IEntityTypeProvider<?>> entities = builder.getEntities();
            if (!entities.isEmpty()) {
                entities.forEach(entityType -> this.entityBuilders.put((IEntityTypeProvider<?>)entityType, (ArmatureBuilder)builder));
                ++used;
            }
            if (!(models = builder.getModels()).isEmpty()) {
                models.forEach(model -> this.modelBuilders.computeIfAbsent((String)model, k -> new ArrayList()).add(builder));
                ++used;
            }
            if (used == 0) {
                this.defaultBuilders.add((ArmatureBuilder)builder);
            }
        });
        ++this.version;
    }

    public IJointTransform[] getTransforms(EntityType<?> entityType, IModel model) {
        ArmatureBuilder builder = ObjectUtils.find(this.entityBuilders, entityType, Supplier::get);
        if (builder == null) {
            builder = this.getDefaultBuilder("*");
        }
        if (builder != null) {
            return builder.build(model);
        }
        return null;
    }

    public int getVersion() {
        return this.version;
    }

    private ArmatureBuilder getDefaultBuilder(String model) {
        ArrayList<ArmatureBuilder> builders = this.modelBuilders.get(model);
        if (builders == null) {
            builders = this.defaultBuilders;
        }
        if (builders.size() != 0) {
            return builders.get(builders.size() - 1);
        }
        return null;
    }
}

