/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.Objects;
import java.util.Optional;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.texture.SkinPaintData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class SkinDynamicTexture
extends DynamicTexture {
    private final TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    private SkinPaintData paintData;
    private NativeImage downloadedImage;
    private ResourceLocation refer;
    private Texture referTexture;
    private boolean needsUpdate = true;

    public SkinDynamicTexture() {
        super(64, 64, true);
    }

    public ResourceLocation getRefer() {
        return this.refer;
    }

    public void setRefer(ResourceLocation refer) {
        if (!Objects.equals(this.refer, refer)) {
            this.refer = refer;
            this.referTexture = Optional.ofNullable(refer).map(arg_0 -> ((TextureManager)this.textureManager).func_229267_b_(arg_0)).orElse(null);
            this.downloadedImage = null;
            this.setNeedsUpdate();
        }
    }

    public SkinPaintData getPaintData() {
        return this.paintData;
    }

    public void setPaintData(SkinPaintData paintData) {
        if (this.paintData != paintData) {
            this.paintData = paintData;
            this.setNeedsUpdate();
        }
    }

    public void func_110564_a() {
        NativeImage downloadedImage = this.getDownloadedImage();
        NativeImage mergedImage = this.func_195414_e();
        if (mergedImage == null || downloadedImage == null) {
            return;
        }
        mergedImage.func_195703_a(downloadedImage);
        if (this.paintData != null) {
            this.applyPaintColor(mergedImage);
        }
        super.func_110564_a();
    }

    private void setNeedsUpdate() {
        this.needsUpdate = true;
        RenderSystem.recordRenderCall(() -> {
            if (this.needsUpdate) {
                this.needsUpdate = false;
                this.func_110564_a();
            }
        });
    }

    private void applyPaintColor(NativeImage mergedImage) {
        for (int iy = 0; iy < this.paintData.getHeight(); ++iy) {
            for (int ix = 0; ix < this.paintData.getWidth(); ++ix) {
                int color = this.paintData.getColor(ix, iy);
                if (!PaintColor.isOpaque(color)) continue;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                int fixed = b << 16 | g << 8 | r;
                mergedImage.func_195700_a(ix, iy, 0xFF000000 | fixed);
            }
        }
    }

    private NativeImage getDownloadedImage() {
        if (this.downloadedImage != null) {
            return this.downloadedImage;
        }
        if (this.referTexture != null) {
            GL11.glBindTexture((int)3553, (int)this.referTexture.func_110552_b());
            this.downloadedImage = new NativeImage(64, 64, true);
            this.downloadedImage.func_195717_a(0, false);
        }
        return this.downloadedImage;
    }

    protected void finalize() throws Throwable {
        this.func_147631_c();
        super.finalize();
    }
}

