/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;

public class SkinBlockPlaceContext
extends BlockItemUseContext {
    private Vector3f rotations = Vector3f.ZERO;
    private SkinDescriptor skin = SkinDescriptor.EMPTY;
    private ArrayList<Part> parts = new ArrayList();
    private SkinProperties properties;

    public SkinBlockPlaceContext(ItemUseContext context) {
        super(context);
        this.loadElements(SkinLoader.getInstance()::loadSkin);
    }

    public SkinBlockPlaceContext(PlayerEntity player, Hand hand, ItemStack itemStack, BlockRayTraceResult traceResult) {
        super(PropertyProvider.getLevel((Entity)player), player, hand, itemStack, traceResult);
        this.loadElements(SkinLoader.getInstance()::getSkin);
    }

    public static SkinBlockPlaceContext of(BlockPos pos) {
        if (pos instanceof AttachedBlockPos) {
            return ((AttachedBlockPos)pos).context;
        }
        return null;
    }

    protected void transform(Vector3f r) {
        for (Part part : this.parts) {
            part.transform(r);
        }
    }

    protected void loadElements(Function<String, Skin> provider) {
        ItemStack itemStack = this.func_195996_i();
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            return;
        }
        Skin skin = provider.apply(descriptor.getIdentifier());
        if (skin == null) {
            return;
        }
        ArrayList parts = new ArrayList();
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        skin.getBlockBounds().forEach((pos, shape) -> {
            if (pos.equals((Object)BlockPos.field_177992_a)) {
                parts.add(new ParentPart((BlockPos)pos, (Rectangle3i)shape, (Collection<BlockPos>)blockPosList, descriptor, skin));
            } else {
                parts.add(new Part((BlockPos)pos, (Rectangle3i)shape));
            }
        });
        this.skin = descriptor;
        this.parts = parts;
        this.properties = skin.getProperties();
        BlockState state = ((Block)ModBlocks.SKINNABLE.get()).func_196258_a((BlockItemUseContext)this);
        if (state != null) {
            this.rotations = SkinnableBlockEntity.getRotations(state);
            this.transform(this.rotations);
        }
        for (Part part : parts) {
            blockPosList.add(part.getOffset());
        }
    }

    public <V> V getProperty(SkinProperty<V> property) {
        if (this.properties != null && !this.properties.isEmpty()) {
            return this.properties.get(property);
        }
        return property.getDefaultValue();
    }

    public boolean canPlace(Part part) {
        if (this.skin.isEmpty()) {
            return false;
        }
        if (this.skin.getType() != SkinTypes.BLOCK) {
            return false;
        }
        BlockPos pos = super.func_195995_a().func_177971_a((Vector3i)part.getOffset());
        return this.func_195991_k().func_180495_p(pos).func_196953_a((BlockItemUseContext)this);
    }

    public boolean func_196011_b() {
        return this.parts != null && this.parts.stream().allMatch(this::canPlace) && super.func_196011_b();
    }

    public BlockPos func_195995_a() {
        return new AttachedBlockPos(this, super.func_195995_a());
    }

    public SkinDescriptor getSkin() {
        return this.skin;
    }

    public ArrayList<Part> getParts() {
        return this.parts;
    }

    public static class AttachedBlockPos
    extends BlockPos {
        protected final SkinBlockPlaceContext context;

        public AttachedBlockPos(SkinBlockPlaceContext context, BlockPos pos) {
            super((Vector3i)pos);
            this.context = context;
        }
    }

    public static class Part {
        private BlockPos offset;
        private Rectangle3i shape;

        public Part() {
            this(BlockPos.field_177992_a, Rectangle3i.ZERO);
        }

        public Part(BlockPos offset, Rectangle3i shape) {
            this.offset = offset;
            this.shape = shape;
        }

        public CompoundNBT writeToNBT(CompoundNBT tag) {
            OptionalAPI.putOptionalBlockPos(tag, "Refer", this.offset, null);
            OptionalAPI.putOptionalRectangle3i(tag, "Shape", this.shape, null);
            return tag;
        }

        public void transform(Vector3f r) {
            OpenQuaternionf q = new OpenQuaternionf(r.getX(), r.getY(), r.getZ(), true);
            Vector4f f = new Vector4f(this.offset.func_177958_n(), this.offset.func_177956_o(), this.offset.func_177952_p(), 1.0f);
            f.transform(q);
            this.offset = new BlockPos(Math.round(f.x()), Math.round(f.y()), Math.round(f.z()));
            Rectangle3f of = new Rectangle3f(this.shape);
            of.mul(q);
            this.shape = new Rectangle3i(0, 0, 0, 0, 0, 0);
            this.shape.setX(Math.round(of.getX()));
            this.shape.setY(Math.round(of.getY()));
            this.shape.setZ(Math.round(of.getZ()));
            this.shape.setWidth(Math.round(of.getWidth()));
            this.shape.setHeight(Math.round(of.getHeight()));
            this.shape.setDepth(Math.round(of.getDepth()));
        }

        public BlockPos getOffset() {
            return this.offset;
        }

        public Rectangle3i getShape() {
            return this.shape;
        }

        public CompoundNBT getEntityTag() {
            return this.writeToNBT(new CompoundNBT());
        }
    }

    public static class ParentPart
    extends Part {
        private final SkinDescriptor descriptor;
        private final SkinProperties properties;
        private final Collection<BlockPos> blockPosList;
        private Collection<SkinMarker> markerList;

        public ParentPart(BlockPos offset, Rectangle3i shape, Collection<BlockPos> blockPosList, SkinDescriptor descriptor, Skin skin) {
            super(offset, shape);
            this.descriptor = descriptor;
            this.blockPosList = blockPosList;
            this.properties = skin.getProperties();
            this.markerList = skin.getMarkers();
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT tag) {
            tag = super.writeToNBT(tag);
            OptionalAPI.putOptionalBlockPosArray(tag, "Refers", this.blockPosList);
            OptionalAPI.putOptionalSkinMarkerArray(tag, "Markers", this.markerList);
            OptionalAPI.putOptionalSkinDescriptor(tag, "Skin", this.descriptor);
            OptionalAPI.putOptionalSkinProperties(tag, "SkinProperties", this.properties);
            return tag;
        }

        @Override
        public void transform(Vector3f r) {
            super.transform(r);
            OpenQuaternionf q = new OpenQuaternionf(r.getX(), r.getY(), r.getZ(), true);
            ArrayList<SkinMarker> newMarkerList = new ArrayList<SkinMarker>();
            for (SkinMarker marker : this.markerList) {
                Vector4f f = new Vector4f(marker.x, marker.y, marker.z, 1.0f);
                f.transform(OpenMatrix4f.createScaleMatrix(-1.0f, -1.0f, 1.0f));
                f.transform(q);
                int x = Math.round(f.x());
                int y = Math.round(f.y());
                int z = Math.round(f.z());
                marker = new SkinMarker((byte)x, (byte)y, (byte)z, marker.meta);
                newMarkerList.add(marker);
            }
            this.markerList = newMarkerList;
        }
    }
}

