/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.transform;

import moe.plushie.armourers_workshop.api.action.ICanRotation;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class SkinWingsTransform
implements ISkinTransform {
    private float partialTicks = 0.0f;
    private boolean isFallFlying = false;
    private final boolean isMirror;
    private final SkinMarker marker;
    private final SkinProperties properties;

    public SkinWingsTransform(ISkinPartType partType, SkinProperties properties, SkinMarker marker) {
        this.marker = marker;
        this.properties = properties;
        this.isMirror = ((ICanRotation)((Object)partType)).isMirror();
    }

    public void setup(float partialTicks, @Nullable Entity entity) {
        this.partialTicks = partialTicks;
        this.isFallFlying = entity instanceof LivingEntity && ((LivingEntity)entity).func_184613_cA();
    }

    @Override
    public void pre(IPoseStack poseStack) {
    }

    @Override
    public void post(IPoseStack poseStack) {
        Vector3i point = this.marker.getPosition();
        float angle = (float)this.getRotationDegrees();
        Vector3f offset = new Vector3f((float)point.getX() + 0.5f, (float)point.getY() + 0.5f, (float)point.getZ() + 0.5f);
        if (!this.isMirror) {
            angle = -angle;
        }
        poseStack.translate(offset.getX(), offset.getY(), offset.getZ());
        poseStack.rotate(this.getRotationMatrix().rotationDegrees(angle));
        poseStack.translate(-offset.getX(), -offset.getY(), -offset.getZ());
    }

    private double getRotationDegrees() {
        if (this.properties == null) {
            return 0.0;
        }
        double maxAngle = this.properties.get(SkinProperty.WINGS_MAX_ANGLE);
        double minAngle = this.properties.get(SkinProperty.WINGS_MIN_ANGLE);
        String movementTypeName = this.properties.get(SkinProperty.WINGS_MOVMENT_TYPE);
        SkinProperty.MovementType movementType = SkinProperty.MovementType.valueOf(movementTypeName);
        double flapTime = this.properties.get(SkinProperty.WINGS_IDLE_SPEED);
        if (this.isFallFlying) {
            flapTime = this.properties.get(SkinProperty.WINGS_FLYING_SPEED);
        }
        double angle = (double)this.partialTicks % flapTime;
        if (movementType == SkinProperty.MovementType.EASE) {
            angle = Math.sin(angle / flapTime * Math.PI * 2.0);
        }
        if (movementType == SkinProperty.MovementType.LINEAR) {
            angle /= flapTime;
        }
        double fullAngle = maxAngle - minAngle;
        if (movementType == SkinProperty.MovementType.LINEAR) {
            return fullAngle * angle;
        }
        return -minAngle - fullAngle * ((angle + 1.0) / 2.0);
    }

    private Vector3f getRotationMatrix() {
        switch (this.marker.getDirection()) {
            case UP: {
                return Vector3f.YP;
            }
            case DOWN: {
                return Vector3f.YN;
            }
            case SOUTH: {
                return Vector3f.ZN;
            }
            case NORTH: {
                return Vector3f.ZP;
            }
            case EAST: {
                return Vector3f.XP;
            }
            case WEST: {
                return Vector3f.XN;
            }
        }
        return Vector3f.YP;
    }
}

