/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import extensions.net.minecraft.world.item.ItemStack.ABI;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class SkinItem
extends BlockItem
implements IItemPropertiesProvider {
    public SkinItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static ItemStack replace(ItemStack targetStack, ItemStack sourceStack) {
        CompoundNBT sourceNBT = null;
        if (!sourceStack.func_190926_b()) {
            sourceNBT = sourceStack.func_179543_a("ArmourersWorkshop");
        }
        if (sourceNBT != null && sourceNBT.func_186856_d() != 0) {
            targetStack.func_77983_a("ArmourersWorkshop", (INBT)sourceNBT.func_74737_b());
        } else {
            CompoundNBT targetNBT = targetStack.func_77978_p();
            if (targetNBT != null) {
                targetNBT.func_82580_o("ArmourersWorkshop");
            }
        }
        return targetStack;
    }

    public static ItemStack replace(ItemStack targetStack, SkinDescriptor descriptor) {
        if (targetStack.func_190926_b()) {
            return descriptor.asItemStack();
        }
        if (ABI.is(targetStack, (Item)ModItems.SKIN_TEMPLATE.get())) {
            return descriptor.asItemStack();
        }
        if (descriptor.isEmpty()) {
            CompoundNBT targetNBT = targetStack.func_77978_p();
            if (targetNBT != null) {
                targetNBT.func_82580_o("ArmourersWorkshop");
            }
        } else {
            targetStack.func_77983_a("ArmourersWorkshop", (INBT)descriptor.serializeNBT());
        }
        return targetStack;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        SkinSlotType slotType = SkinSlotType.of(descriptor.getType());
        if (descriptor.isEmpty() || slotType == null) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)player);
        if (wardrobe == null || !wardrobe.isEditable(player)) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        int slot = wardrobe.getFreeSlot(slotType);
        if (!wardrobe.getItem(slotType, slot).func_190926_b()) {
            return ActionResult.func_226250_c_((Object)itemStack);
        }
        if (level.func_201670_d()) {
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        wardrobe.setItem(slotType, slot, itemStack.func_77946_l());
        wardrobe.broadcast();
        itemStack.func_190918_g(1);
        return ActionResult.func_226249_b_((Object)itemStack.func_77946_l());
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        ItemStack itemStack = context.func_195996_i();
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.getType() != SkinTypes.BLOCK) {
            return ActionResultType.PASS;
        }
        return super.func_195942_a((BlockItemUseContext)new SkinBlockPlaceContext((ItemUseContext)context));
    }

    public ITextComponent func_200295_i(ItemStack itemStack) {
        Skin skin = SkinLoader.getInstance().getSkin(itemStack);
        if (skin != null && !skin.getCustomName().trim().isEmpty()) {
            return TranslateUtils.formatted(skin.getCustomName());
        }
        if (skin != null) {
            return TranslateUtils.Name.of(skin.getType());
        }
        return super.func_200295_i(itemStack);
    }

    public String func_77658_a() {
        return this.func_195935_o();
    }

    @Override
    public void createModelProperties(BiConsumer<ResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("loading"), (itemStack, level, entity, id) -> {
            SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
            BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.INVENTORY);
            if (bakedSkin != null) {
                return 0.0f;
            }
            return (float)descriptor.getType().getId() / 1000.0f;
        });
    }
}

