/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.document;

import extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentListener;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.SkinUUID;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.IFormattableTextComponent;

public class SkinDocumentNode {
    private Vector3f location = Vector3f.ZERO;
    private Vector3f rotation = Vector3f.ZERO;
    private Vector3f scale = Vector3f.ONE;
    private SkinTransform transform = null;
    private ISkinPartType type = SkinPartTypes.ADVANCED;
    private SkinDescriptor skin = SkinDescriptor.EMPTY;
    private String name;
    private SkinDocumentNode parent;
    private SkinDocumentListener listener;
    private boolean isEnabled = true;
    private boolean isMirror = false;
    private final String id;
    private final ArrayList<SkinDocumentNode> children = new ArrayList();
    private String cachedTypeName;

    public SkinDocumentNode(String name) {
        this(SkinUUID.randomUUIDString(), name);
    }

    public SkinDocumentNode(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public SkinDocumentNode(CompoundNBT tag) {
        this.id = tag.func_74779_i("UID");
        this.name = OptionalAPI.getOptionalString(tag, "Name", null);
        this.type = OptionalAPI.getOptionalType(tag, "Type", SkinPartTypes.ADVANCED, SkinPartTypes::byName);
        this.skin = OptionalAPI.getOptionalSkinDescriptor(tag, "Skin");
        this.location = OptionalAPI.getOptionalVector3f(tag, "Location", Vector3f.ZERO);
        this.rotation = OptionalAPI.getOptionalVector3f(tag, "Rotation", Vector3f.ZERO);
        this.scale = OptionalAPI.getOptionalVector3f(tag, "Scale", Vector3f.ONE);
        if (tag.func_74764_b("Children")) {
            ListNBT listTag = tag.func_150295_c("Children", 10);
            int count = listTag.size();
            for (int i = 0; i < count; ++i) {
                SkinDocumentNode node = new SkinDocumentNode(listTag.func_150305_b(i));
                node.parent = this;
                this.children.add(node);
            }
        }
        this.isEnabled = OptionalAPI.getOptionalBoolean(tag, "Enabled", true);
        this.isMirror = OptionalAPI.getOptionalBoolean(tag, "Mirror", false);
    }

    public void add(SkinDocumentNode node) {
        if (node.parent != null) {
            node.removeFromParent();
        }
        this.children.add(node);
        node.parent = this;
        node.setListener(this.listener);
        if (this.listener != null) {
            this.listener.documentDidInsertNode(this, node, -1);
        }
    }

    public void insertAtIndex(SkinDocumentNode node, int index) {
        if (node.parent != null) {
            node.removeFromParent();
        }
        this.children.add(index, node);
        node.parent = this;
        node.setListener(this.listener);
        if (this.listener != null) {
            this.listener.documentDidInsertNode(this, node, index);
        }
    }

    public void moveTo(SkinDocumentNode node, int toIndex) {
        int index = this.children.indexOf(node);
        if (index < 0 || index == toIndex) {
            return;
        }
        this.children.remove(index);
        this.children.add(MathUtils.clamp(toIndex, 0, this.children.size()), node);
        if (this.listener != null) {
            this.listener.documentDidMoveNode(this, node, toIndex);
        }
    }

    public void removeFromParent() {
        if (this.parent == null) {
            return;
        }
        if (this.listener != null) {
            this.listener.documentDidRemoveNode(this);
        }
        this.parent.children.remove(this);
        this.parent = null;
        this.setListener(null);
    }

    public void setName(String value) {
        this.name = value;
        this.cachedTypeName = null;
        if (this.listener != null) {
            CompoundNBT tag = new CompoundNBT();
            OptionalAPI.putOptionalString(tag, "Name", value, null);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.cachedTypeName != null) {
            return this.cachedTypeName;
        }
        IFormattableTextComponent lhs = TranslateUtils.title("documentType.armourers_workshop.node.root", new Object[0]);
        IFormattableTextComponent rhs = TranslateUtils.title("documentType.armourers_workshop.node." + this.id, new Object[0]);
        if (this.type != SkinPartTypes.ADVANCED) {
            rhs = TranslateUtils.Name.of(this.type);
        }
        this.cachedTypeName = TranslateUtils.title("documentType.armourers_workshop.node", lhs, rhs).getString();
        return this.cachedTypeName;
    }

    public void setType(ISkinPartType type) {
        this.type = type;
        this.cachedTypeName = null;
    }

    public ISkinPartType getType() {
        return this.type;
    }

    public void setSkin(SkinDescriptor value) {
        this.skin = value;
        if (this.listener != null) {
            CompoundNBT tag = new CompoundNBT();
            OptionalAPI.putOptionalSkinDescriptor(tag, "Skin", value, null);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public SkinDescriptor getSkin() {
        return this.skin;
    }

    public void setLocation(Vector3f value) {
        this.location = value;
        this.transform = null;
        if (this.listener != null) {
            CompoundNBT tag = new CompoundNBT();
            OptionalAPI.putOptionalVector3f(tag, "Location", value, null);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public Vector3f getLocation() {
        return this.location;
    }

    public void setRotation(Vector3f value) {
        this.rotation = value;
        this.transform = null;
        if (this.listener != null) {
            CompoundNBT tag = new CompoundNBT();
            OptionalAPI.putOptionalVector3f(tag, "Rotation", value, null);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public void setScale(Vector3f value) {
        this.scale = value;
        this.transform = null;
        if (this.listener != null) {
            CompoundNBT tag = new CompoundNBT();
            OptionalAPI.putOptionalVector3f(tag, "Scale", value, null);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public SkinTransform getTransform() {
        if (this.transform != null) {
            return this.transform;
        }
        Vector3f translate = this.location;
        if (!translate.equals(Vector3f.ZERO)) {
            translate = new Vector3f(-translate.getX() * 16.0f, -translate.getY() * 16.0f, translate.getZ() * 16.0f);
        }
        this.transform = SkinTransform.create(translate, this.rotation, this.scale);
        return this.transform;
    }

    public String getId() {
        return this.id;
    }

    public void setEnabled(boolean value) {
        this.isEnabled = value;
        if (this.listener != null) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("Enabled", value);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setMirror(boolean value) {
        this.isMirror = value;
        if (this.listener != null) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("Mirror", value);
            this.listener.documentDidUpdateNode(this, tag);
        }
    }

    public boolean isMirror() {
        return this.isMirror;
    }

    public boolean isLocked() {
        return this.name == null;
    }

    public boolean isStatic() {
        return this.id.equals("static");
    }

    public boolean isFloat() {
        return this.id.equals("float");
    }

    public boolean isLocator() {
        return this.type.equals(SkinPartTypes.ADVANCED_LOCATOR);
    }

    public SkinDocumentNode parent() {
        return this.parent;
    }

    public ArrayList<SkinDocumentNode> children() {
        return this.children;
    }

    protected void setListener(SkinDocumentListener listener) {
        this.listener = listener;
        this.children.forEach(it -> it.setListener(listener));
    }

    protected SkinDocumentListener getListener() {
        return this.listener;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("UID", this.id);
        OptionalAPI.putOptionalString(tag, "Name", this.name, null);
        OptionalAPI.putOptionalType(tag, "Type", this.type, SkinPartTypes.ADVANCED);
        OptionalAPI.putOptionalSkinDescriptor(tag, "Skin", this.skin);
        OptionalAPI.putOptionalVector3f(tag, "Location", this.location, Vector3f.ZERO);
        OptionalAPI.putOptionalVector3f(tag, "Rotation", this.rotation, Vector3f.ZERO);
        OptionalAPI.putOptionalVector3f(tag, "Scale", this.scale, Vector3f.ONE);
        if (this.children.size() != 0) {
            ListNBT listTag = new ListNBT();
            this.children.forEach(it -> listTag.add((Object)it.serializeNBT()));
            tag.func_218657_a("Children", (INBT)listTag);
        }
        OptionalAPI.putOptionalBoolean(tag, "Enabled", this.isEnabled, true);
        OptionalAPI.putOptionalBoolean(tag, "Mirror", this.isMirror, false);
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        String newName;
        Vector3f newScale;
        Vector3f newRotation;
        Vector3f newLocation;
        SkinDescriptor newSkin = OptionalAPI.getOptionalSkinDescriptor(tag, "Skin", null);
        if (newSkin != null) {
            this.skin = newSkin;
        }
        if ((newLocation = OptionalAPI.getOptionalVector3f(tag, "Location", null)) != null) {
            this.location = newLocation;
            this.transform = null;
        }
        if ((newRotation = OptionalAPI.getOptionalVector3f(tag, "Rotation", null)) != null) {
            this.rotation = newRotation;
            this.transform = null;
        }
        if ((newScale = OptionalAPI.getOptionalVector3f(tag, "Scale", null)) != null) {
            this.scale = newScale;
            this.transform = null;
        }
        if ((newName = OptionalAPI.getOptionalString(tag, "Name", null)) != null) {
            this.name = newName;
        }
        if (tag.func_74764_b("Enabled")) {
            this.isEnabled = tag.func_74767_n("Enabled");
        }
        if (tag.func_74764_b("Mirror")) {
            this.isMirror = tag.func_74767_n("Mirror");
        }
        this.listener.documentDidUpdateNode(this, tag);
    }

    public static class Keys {
        public static final String UID = "UID";
        public static final String NAME = "Name";
        public static final String TYPE = "Type";
        public static final String SKIN = "Skin";
        public static final String LOCATION = "Location";
        public static final String ROTATION = "Rotation";
        public static final String SCALE = "Scale";
        public static final String CHILDREN = "Children";
        public static final String ENABLED = "Enabled";
        public static final String MIRROR = "Mirror";
    }
}

