/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.util.Collection;
import java.util.function.IntConsumer;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.ChunkSerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.Chunk;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkFlags;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkVariable;
import org.jetbrains.annotations.Nullable;

public class ChunkWriter {
    protected final ChunkOutputStream stream;

    public ChunkWriter(ChunkOutputStream stream) {
        this.stream = stream;
    }

    public <V> void write(ChunkSerializer<V, Void> serializer, @Nullable V value) throws IOException {
        this.write(serializer, value, null);
    }

    public <V, T> void write(ChunkSerializer<V, T> serializer, @Nullable V value, T obj) throws IOException {
        if (!serializer.canWrite(value, obj, this.stream)) {
            return;
        }
        String name = serializer.getChunkType().getName();
        ChunkFlags flags = serializer.getChunkFlags(value, this.stream.getContext());
        Sum sum = new Sum();
        this.stream.writeVariable(sum);
        this.stream.sumTask(sum, () -> {
            this.writeHeader(name, flags);
            this.stream.compressTask(flags, () -> this.writeContent(serializer, value, obj, flags));
            this.writeFooter(name, flags);
        });
    }

    public void writeBlobs(Object blobs) throws IOException {
        if (blobs instanceof Collection) {
            for (Object blob : (Collection)blobs) {
                if (!(blob instanceof Chunk)) continue;
                Chunk chunk = (Chunk)blob;
                String name = chunk.getName();
                ChunkFlags flags = chunk.getFlags();
                this.stream.writeInt(chunk.getLength());
                this.writeHeader(name, flags);
                chunk.writeToStream(this.stream);
                this.writeFooter(name, flags);
            }
        }
    }

    protected void writeHeader(String name, ChunkFlags flags) throws IOException {
        this.stream.writeString(name, 4);
        flags.writeToStream(this.stream);
    }

    protected <V, T> void writeContent(ChunkSerializer<V, T> serializer, @Nullable V value, T obj, ChunkFlags flags) throws IOException {
        serializer.write(value, obj, this.stream);
    }

    protected void writeFooter(String name, ChunkFlags flags) throws IOException {
    }

    protected static class Sum
    implements IntConsumer,
    ChunkVariable {
        private int length = 0;
        private boolean resolved = false;

        protected Sum() {
        }

        @Override
        public void accept(int length) {
            this.length = length;
            this.resolved = true;
        }

        @Override
        public void writeToStream(IOutputStream stream) throws IOException {
            stream.writeInt(this.length + 4);
        }

        @Override
        public boolean freeze() {
            return this.resolved;
        }
    }
}

