/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transformer.bedrock;

import java.io.IOException;
import moe.plushie.armourers_workshop.api.common.IResource;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelCube;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelGeometry;
import moe.plushie.armourers_workshop.core.skin.transformer.bedrock.BedrockModelUV;
import moe.plushie.armourers_workshop.utils.math.Rectangle2f;
import moe.plushie.armourers_workshop.utils.math.Size3f;
import moe.plushie.armourers_workshop.utils.texture.TextureBox;
import moe.plushie.armourers_workshop.utils.texture.TextureData;
import net.minecraft.util.Direction;
import org.jetbrains.annotations.Nullable;

public class BedrockModelTexture {
    protected TextureData textureData;

    public static BedrockModelTexture simpleTexture(BedrockModelGeometry geometry, IResource textureFile) throws IOException {
        BedrockModelTexture texture = new BedrockModelTexture();
        texture.load(geometry, textureFile);
        return texture;
    }

    public void load(BedrockModelGeometry geometry, IResource textureFile) throws IOException {
        this.textureData = new TextureData(textureFile.getName(), geometry.getTextureWidth(), geometry.getTextureHeight());
        this.textureData.load(textureFile.getInputStream());
    }

    public TextureBox read(BedrockModelCube cube) {
        Size3f size = cube.getSize();
        BedrockModelUV uv = cube.getUV();
        TextureBox skyBox = new TextureBox(size.getWidth(), size.getHeight(), size.getDepth(), cube.isMirror(), uv.getBase(), this.getTextureData(cube));
        uv.forEach((dir, rect) -> {
            skyBox.put((Direction)dir, (Rectangle2f)rect);
            skyBox.put((Direction)dir, this.getTextureData(cube, (Direction)dir));
        });
        return skyBox;
    }

    @Nullable
    protected TextureData getTextureData(BedrockModelCube cube) {
        return this.textureData;
    }

    @Nullable
    protected TextureData getTextureData(BedrockModelCube cube, Direction dir) {
        return this.textureData;
    }
}

