/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.init.ModContext;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class UpdateContextPacket
extends CustomPacket {
    private UUID token = null;
    private PacketBuffer buffer = null;

    public UpdateContextPacket() {
    }

    public UpdateContextPacket(PlayerEntity player) {
        this.token = player.func_110124_au();
    }

    public UpdateContextPacket(PacketBuffer buffer) {
        this.buffer = buffer;
        this.buffer.retain();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        if (this.token != null) {
            buffer.writeBoolean(true);
            buffer.func_179252_a(ModContext.t2(this.token));
            buffer.func_179252_a(ModContext.t3(this.token));
            buffer.func_180714_a("i");
        } else {
            buffer.writeBoolean(false);
        }
        this.writeConfigSpec(buffer);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        if (this.buffer != null) {
            if (this.buffer.readBoolean()) {
                ModContext.init(this.buffer.func_179253_g(), this.buffer.func_179253_g());
                this.checkNetworkVersion(this.buffer.func_218666_n());
            }
            this.readConfigSpec(this.buffer);
            this.buffer.release();
        }
    }

    private void writeConfigSpec(PacketBuffer buffer) {
        try {
            Map<Object, Object> fields = new HashMap();
            if (EnvironmentManager.isDedicatedServer()) {
                fields = ModConfigSpec.COMMON.snapshot();
            }
            buffer.writeInt(fields.size());
            if (fields.size() == 0) {
                return;
            }
            ByteBufOutputStream bo = new ByteBufOutputStream((ByteBuf)buffer);
            ObjectOutputStream oo = new ObjectOutputStream((OutputStream)bo);
            for (Map.Entry<Object, Object> entry : fields.entrySet()) {
                oo.writeUTF((String)entry.getKey());
                oo.writeObject(entry.getValue());
            }
            oo.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readConfigSpec(PacketBuffer buffer) {
        int size = buffer.readInt();
        if (size == 0) {
            return;
        }
        try {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            ByteBufInputStream bi = new ByteBufInputStream((ByteBuf)buffer);
            ObjectInputStream oi = new ObjectInputStream((InputStream)bi);
            for (int i = 0; i < size; ++i) {
                String name = oi.readUTF();
                Object value = oi.readObject();
                fields.put(name, value);
            }
            oi.close();
            ModConfigSpec.COMMON.apply(fields);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkNetworkVersion(String version) {
        if (!version.equals("i")) {
            ModLog.warn("network protocol conflict, server: {}, client: {}", version, "i");
        }
    }
}

